/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import kafka.server.ConfigHelper;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u0005\u000b\u0005=A\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u0003:\u0001\u0011\u0005!\bC\u0003@\u0001\u0011\u0005\u0003\tC\u0003_\u0001\u0011\u0005s\fC\u0003d\u0001\u0011\u0005C\rC\u0004\u0002\"\u0001!\t%a\t\u0003\u001fi[\u0017J\u001c;fe:\fG.\u00113nS:T!a\u0003\u0007\u0002\rM,'O^3s\u0015\u0005i\u0011!B6bM.\f7\u0001A\n\u0005\u0001A1\"\u0004\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011AC\u0005\u00033)\u0011Q\"\u00138uKJt\u0017\r\\!e[&t\u0007CA\u000e\u001f\u001b\u0005a\"BA\u000f\r\u0003\u0015)H/\u001b7t\u0013\tyBDA\u0004M_\u001e<\u0017N\\4\u0002\r\rd\u0017.\u001a8u!\t\u0011S%D\u0001$\u0015\t!C\"\u0001\u0002{W&\u0011ae\t\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t9\u0012&\u0003\u0002+\u0015\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f1c[1gW\u0006\u001cuN\u001c4jON+\b\u000f\u001d7jKJ\u00042!\f\u001b7\u001b\u0005q#BA\u00181\u0003!1WO\\2uS>t'BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011QG\f\u0002\t'V\u0004\b\u000f\\5feB\u0011qcN\u0005\u0003q)\u00111bS1gW\u0006\u001cuN\u001c4jO\u00061A(\u001b8jiz\"Ba\u000f\u001f>}A\u0011q\u0003\u0001\u0005\u0006A\u0011\u0001\r!\t\u0005\u0006O\u0011\u0001\r\u0001\u000b\u0005\u0006W\u0011\u0001\r\u0001L\u0001\fK:\u001cXO]3U_BL7\rF\u0003B\tF\u001b\u0006\f\u0005\u0002\u0012\u0005&\u00111I\u0005\u0002\u0004\u0013:$\b\"B#\u0006\u0001\u00041\u0015!\u0003;pa&\u001cg*Y7f!\t9eJ\u0004\u0002I\u0019B\u0011\u0011JE\u0007\u0002\u0015*\u00111JD\u0001\u0007yI|w\u000e\u001e \n\u00055\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\n\t\u000bI+\u0001\u0019A!\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0015!V\u00011\u0001V\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\t\u0003#YK!a\u0016\n\u0003\u000bMCwN\u001d;\t\u000be+\u0001\u0019\u0001.\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u00037rk\u0011\u0001M\u0005\u0003;B\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u00035a\u0017n\u001d;BY2$v\u000e]5dgR\t\u0001\rE\u0002\\C\u001aK!A\u0019\u0019\u0003\u0007M+G/A\nu_BL7mQ8oM&<WO]1uS>t7\u000fF\u0003f\u0003+\ti\u0002\u0005\u0003\\M\"\u0004\u0018BA41\u0005\ri\u0015\r\u001d\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fQCY1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edWM\u0003\u0002n\u0019\u0005!A/[3s\u0013\ty'NA\u0005OC6,\u0017I\u001c3JIB\u0019\u0011O^=\u000f\u0005I$hBA%t\u0013\u0005\u0019\u0012BA;\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\t1K7\u000f\u001e\u0006\u0003kJ\u00012A_A\b\u001d\rY\u00181B\u0007\u0002y*\u0011QP`\u0001\b[\u0016\u001c8/Y4f\u0015\ry\u0018\u0011A\u0001\u0007G>lWn\u001c8\u000b\u00075\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB1qC\u000eDWM\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u00055A0A\u000eEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003#\t\u0019BA\u000bEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u000b\u0007\u00055A\u0010C\u0004\u0002\u0018\u001d\u0001\r!!\u0007\u0002\rQ|\u0007/[2t!\u0011Y\u00161\u0004$\n\u0005]\u0004\u0004bBA\u0010\u000f\u0001\u0007\u0011\u0011D\u0001\u000bG>tg-[4LKf\u001c\u0018!E;qI\u0006$X\rV8qS\u000e\u001cuN\u001c4jOR1\u0011QEA\u0016\u0003[\u00012!EA\u0014\u0013\r\tIC\u0005\u0002\u0005+:LG\u000fC\u0003F\u0011\u0001\u0007a\t\u0003\u0004\u00020!\u0001\rAW\u0001\u0007G>tg-[4")
public final class ZkInternalAdmin
implements InternalAdmin,
Logging {
    private final AdminZkClient client;
    private final MetadataCache metadataCache;
    private final Supplier<KafkaConfig> kafkaConfigSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int ensureTopic(String topicName, int numPartitions, short replicationFactor, Properties topicConfig) {
        int n;
        try {
            if (!this.client.topicExists(topicName)) {
                this.client.createTopic(topicName, numPartitions, replicationFactor, topicConfig, this.client.createTopic$default$5(), this.client.createTopic$default$6(), this.client.createTopic$default$7(), this.client.createTopic$default$8());
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = ZkInternalAdmin.$anonfun$ensureTopic$4(topicName, numPartitions);
                    Object var5_5 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return numPartitions;
            }
            n = this.lookUpNumPartitions$1(topicName, numPartitions);
        }
        catch (TopicExistsException topicExistsException) {
            n = this.lookUpNumPartitions$1(topicName, numPartitions);
        }
        return n;
    }

    @Override
    public Set<String> listAllTopics() {
        return this.metadataCache.topicNamesToIds().keySet();
    }

    @Override
    public Map<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>> topicConfigurations(java.util.List<String> topics, java.util.List<String> configKeys) {
        HashMap<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>> topicToConfigs = new HashMap<NameAndId, List<DescribeConfigsResponseData.DescribeConfigsResult>>();
        ZkConfigRepository configRepository = new ZkConfigRepository(this.client);
        ConfigHelper configHelper = new ConfigHelper(this.metadataCache, this.kafkaConfigSupplier.get(), configRepository, (Option<AlterConfigPolicy>)None$.MODULE$, null);
        topics.stream().forEach(topic -> {
            Uuid tpId = $this.metadataCache.getTopicId((String)topic);
            .colon.colon configResources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(topic).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(configKeys), (List)Nil$.MODULE$);
            List<DescribeConfigsResponseData.DescribeConfigsResult> configResults = configHelper.describeConfigs((List<DescribeConfigsRequestData.DescribeConfigsResource>)configResources, false, null, false);
            if (tpId.equals((Object)$this.metadataCache.getTopicId((String)topic))) {
                topicToConfigs.put(new NameAndId((String)topic, tpId), configResults);
                return;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = ZkInternalAdmin.$anonfun$topicConfigurations$2(topic);
                Object var8_8 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
        });
        return topicToConfigs;
    }

    @Override
    public void updateTopicConfig(String topicName, Properties config) {
        Properties prevConfig = this.client.fetchEntityConfig("topics", topicName);
        if (config.entrySet().stream().anyMatch(expected -> {
            block3: {
                block2: {
                    Object prevVal = prevConfig.get(expected.getKey());
                    if (prevVal == null) break block2;
                    String string = prevVal.toString();
                    String string2 = expected.getValue().toString();
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                }
                return true;
            }
            return false;
        })) {
            this.client.changeTopicConfig(topicName, config);
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = ZkInternalAdmin.$anonfun$updateTopicConfig$2(topicName, config);
                Object var4_4 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = ZkInternalAdmin.$anonfun$updateTopicConfig$3(topicName);
            Object var5_5 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$2(String topicName$1, int foundNumPartitions$1, int numPartitions$1) {
        return new StringBuilder(98).append("Topic ").append(topicName$1).append(" already exists. Mismatch between existing partition count ").append(foundNumPartitions$1).append(" ").append("and configured partition count ").append(numPartitions$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$3(String topicName$1, int foundNumPartitions$1) {
        return new StringBuilder(30).append("Topic ").append(topicName$1).append(" exists with ").append(foundNumPartitions$1).append(" partitions").toString();
    }

    private final int lookUpNumPartitions$1(String topicName$1, int numPartitions$1) {
        int foundNumPartitions = BoxesRunTime.unboxToInt((Object)this.client.numPartitions(topicName$1).getOrElse((Function0 & Serializable)() -> {
            throw new UnknownTopicOrPartitionException(new StringBuilder(22).append(topicName$1).append(" deleted unexpectedly.").toString());
        }));
        if (foundNumPartitions != numPartitions$1) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = ZkInternalAdmin.$anonfun$ensureTopic$2(topicName$1, foundNumPartitions, numPartitions$1);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = ZkInternalAdmin.$anonfun$ensureTopic$3(topicName$1, foundNumPartitions);
            Object var5_5 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return foundNumPartitions;
    }

    public static final /* synthetic */ String $anonfun$ensureTopic$4(String topicName$1, int numPartitions$1) {
        return new StringBuilder(31).append("Created topic ").append(topicName$1).append(" with ").append(numPartitions$1).append(" partitions").toString();
    }

    public static final /* synthetic */ String $anonfun$topicConfigurations$2(String topic$1) {
        return new StringBuilder(64).append("Ignoring topic ").append(topic$1).append(". It has been deleted or recreated with same name").toString();
    }

    public static final /* synthetic */ String $anonfun$updateTopicConfig$2(String topicName$2, Properties config$1) {
        return new StringBuilder(38).append("Successfully updated topic ").append(topicName$2).append(" to config ").append(config$1).toString();
    }

    public static final /* synthetic */ String $anonfun$updateTopicConfig$3(String topicName$2) {
        return new StringBuilder(68).append("Skipped updating topic config for ").append(topicName$2).append(" as the config values are expected").toString();
    }

    public ZkInternalAdmin(AdminZkClient client, MetadataCache metadataCache, Supplier<KafkaConfig> kafkaConfigSupplier) {
        this.client = client;
        this.metadataCache = metadataCache;
        this.kafkaConfigSupplier = kafkaConfigSupplier;
    }
}

