/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.cell;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.controller.ControllerContext;
import kafka.server.KafkaConfig;
import kafka.server.cell.ZkCellControlManager;
import kafka.server.cell.ZkTenantControlManager$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.errors.CellNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ResourceNotFoundException;
import org.apache.kafka.common.errors.TenantNotFoundException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.apache.kafka.metadata.placement.TenantDescriber;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\u000b\u0017\u0001uA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B*\u0001\t\u0003!\u0006\"B.\u0001\t\u0003a\u0006\"B?\u0001\t\u0003q\bbBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-uaBAH-!\u0005\u0011\u0011\u0013\u0004\u0007+YA\t!a%\t\rM\u000bB\u0011AAK\u0011%\t9*\u0005b\u0001\n\u0003\tI\nC\u0004\u0002\u001cF\u0001\u000b\u0011B;\u0003-i[G+\u001a8b]R\u001cuN\u001c;s_2l\u0015M\\1hKJT!a\u0006\r\u0002\t\r,G\u000e\u001c\u0006\u00033i\taa]3sm\u0016\u0014(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\b\u0013+!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qEG\u0001\u0006kRLGn]\u0005\u0003S\u0019\u0012q\u0001T8hO&tw\r\u0005\u0002,k5\tAF\u0003\u0002.]\u0005I\u0001\u000f\\1dK6,g\u000e\u001e\u0006\u0003_A\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u00037ER!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO&\u0011a\u0007\f\u0002\u0010)\u0016t\u0017M\u001c;EKN\u001c'/\u001b2fe\u0006A!p[\"mS\u0016tG\u000f\u0005\u0002:y5\t!H\u0003\u0002<5\u0005\u0011!p[\u0005\u0003{i\u0012QbS1gW\u0006T6n\u00117jK:$\u0018aC2fY2\u001cuN\u001c;s_2\u0004\"\u0001Q!\u000e\u0003YI!A\u0011\f\u0003)i[7)\u001a7m\u0007>tGO]8m\u001b\u0006t\u0017mZ3s\u0003\u001d\u0019wN\u001c;fqR\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u000e\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002J\r\n\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002\r\r|gNZ5h!\taU*D\u0001\u0019\u0013\tq\u0005DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;peB\u0011q$U\u0005\u0003%\u0002\u0012Qa\u00155peR\fa\u0001P5oSRtDCB+W/bK&\f\u0005\u0002A\u0001!)qG\u0002a\u0001q!)aH\u0002a\u0001\u007f!)1I\u0002a\u0001\t\")!J\u0002a\u0001\u0017\")qJ\u0002a\u0001!\u0006\ts-\u001a;Pe\u000e\u0013X-\u0019;f)\u0016t\u0017M\u001c;U_\u000e+G\u000e\\!tg&<g.\\3oiR!Ql\u00199y!\tq\u0016-D\u0001`\u0015\t\u0001\u0007'\u0001\u0004d_6lwN\\\u0005\u0003E~\u0013AaQ3mY\")Am\u0002a\u0001K\u0006AA/\u001a8b]RLE\r\u0005\u0002g[:\u0011qm\u001b\t\u0003Q\u0002j\u0011!\u001b\u0006\u0003Ur\ta\u0001\u0010:p_Rt\u0014B\u00017!\u0003\u0019\u0001&/\u001a3fM&\u0011an\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u0004\u0003\"B9\b\u0001\u0004\u0011\u0018!D;tC\ndWM\u0011:pW\u0016\u00148\u000fE\u0002ggVL!\u0001^8\u0003\u0007M+G\u000f\u0005\u0002 m&\u0011q\u000f\t\u0002\u0004\u0013:$\b\"B=\b\u0001\u0004Q\u0018\u0001\u0004<bY&$\u0017\r^3P]2L\bCA\u0010|\u0013\ta\bEA\u0004C_>dW-\u00198\u0002\u0019\r\u0014X-\u0019;f)\u0016t\u0017M\u001c;\u0015\u000b}\f)!a\u0002\u0011\u0007}\t\t!C\u0002\u0002\u0004\u0001\u0012A!\u00168ji\")A\r\u0003a\u0001K\"1\u0011\u0011\u0002\u0005A\u0002U\faaY3mY&#\u0017AE1tg&<g\u000eV3oC:$Hk\\\"fY2$\u0012b`A\b\u0003#\t\u0019\"!\u0006\t\u000b\u0011L\u0001\u0019A3\t\r\u0005%\u0011\u00021\u0001v\u0011\u0015\t\u0018\u00021\u0001s\u0011\u0019\t9\"\u0003a\u0001u\u0006)am\u001c:dK\u0006iq-\u001a;UK:\fg\u000e^\"fY2$B!!\b\u0002$A!q$a\b^\u0013\r\t\t\u0003\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\u0011T\u0001\u0019A3\u0002\u0019\u0011,G.\u001a;f)\u0016t\u0017M\u001c;\u0015\u0007}\fI\u0003C\u0003e\u0017\u0001\u0007Q-A\u0007t_J$X\r\u001a+f]\u0006tGo]\u000b\u0003\u0003_\u0001b!!\r\u0002<\u0005\u0005c\u0002BA\u001a\u0003oq1\u0001[A\u001b\u0013\u0005\t\u0013bAA\u001dA\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001f\u0003\u007f\u00111aU3r\u0015\r\tI\u0004\t\t\u0004=\u0006\r\u0013bAA#?\n1A+\u001a8b]R\f\u0001cZ3u)\u0016t\u0017M\u001c;DK2d\u0017\nZ:\u0015\t\u0005-\u0013q\r\t\u0007\u0003\u001b\n9&a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\nA!\u001e;jY*\u0011\u0011QK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0005=#\u0001\u0002'jgR\u0004B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019&\u0001\u0003mC:<\u0017\u0002BA3\u0003?\u0012q!\u00138uK\u001e,'\u000fC\u0003e\u001b\u0001\u0007Q-A\u0012dC2\u001cW\u000f\\1uKB\u000b'\u000f^5uS>t\u0007\u000b\\1dK6,g\u000e^*ue\u0006$XmZ=\u0015\t\u00055\u00141\u000f\t\u0004=\u0006=\u0014bAA9?\nQ\u0002+\u0019:uSRLwN\u001c)mC\u000e,W.\u001a8u'R\u0014\u0018\r^3hs\"9\u0011Q\u000f\bA\u0002\u0005]\u0014\u0001\u00049sS:\u001c\u0017\u000e]1m\u001fB$\b#B\u0010\u0002 \u0005e\u0004\u0003BA>\u0003\u000bk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\u0005CV$\bNC\u0002\u0002\u0004~\u000b\u0001b]3dkJLG/_\u0005\u0005\u0003\u000f\u000biH\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u00029%\u001cH+\u001a8b]R\u001cU\r\u001c7QY\u0006\u001cW-\\3oi\u0016s\u0017M\u00197fIR\u0019!0!$\t\u000f\u0005Ut\u00021\u0001\u0002x\u00051\"l\u001b+f]\u0006tGoQ8oiJ|G.T1oC\u001e,'\u000f\u0005\u0002A#M\u0011\u0011C\b\u000b\u0003\u0003#\u000b\u0001$T1y)\u0016t\u0017M\u001c;Va\u0012\fG/Z:QKJ\u0014\u0015\r^2i+\u0005)\u0018!G'bqR+g.\u00198u+B$\u0017\r^3t!\u0016\u0014()\u0019;dQ\u0002\u0002")
public class ZkTenantControlManager
implements Logging,
TenantDescriber {
    private final KafkaZkClient zkClient;
    private final ZkCellControlManager cellControl;
    private final ControllerContext context;
    private final KafkaConfig config;
    private final short replicationFactor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int MaxTenantUpdatesPerBatch() {
        return ZkTenantControlManager$.MODULE$.MaxTenantUpdatesPerBatch();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public synchronized Cell getOrCreateTenantToCellAssignment(String tenantId, scala.collection.immutable.Set<Object> usableBrokers, boolean validateOnly) {
        return (Cell)this.getTenantCell(tenantId).orElse((Function0 & Serializable)() -> $this.cellControl.computeUsableCell(usableBrokers).flatMap((Function1 & Serializable)cell -> {
            try {
                if (!validateOnly) {
                    Tenant tenant = new Tenant(tenantId, Collections.singletonList(Predef$.MODULE$.int2Integer(cell.cellId())));
                    $this.zkClient.createTenant(tenant, $this.context.epochZkVersion());
                    $this.context.updateTenantIfAbsent(tenant);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Tenant ").append(tenantId).append(" is assigned cell ").append(cell.cellId()).toString());
                }
                return new Some(cell);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                return this.getTenantCell(tenantId);
            }
        })).getOrElse((Function0 & Serializable)() -> {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Cluster is unable to create partitions due to it not having any usable cells.");
            throw new ResourceNotFoundException("Cluster is unable to create partitions");
        });
    }

    public void createTenant(String tenantId, int cellId) {
        synchronized (this) {
            this.cellControl.getCell(cellId).map((Function1 & Serializable)x$1 -> {
                ZkTenantControlManager.$anonfun$createTenant$1(this, tenantId, cellId, x$1);
                return BoxedUnit.UNIT;
            }).orElse((Function0 & Serializable)() -> {
                throw new CellNotFoundException(new StringBuilder(20).append("Cell ").append(cellId).append(" does not exist").toString());
            });
            return;
        }
    }

    public synchronized void assignTenantToCell(String tenantId, int cellId, scala.collection.immutable.Set<Object> usableBrokers, boolean force) {
        Option<Cell> option = this.cellControl.getCell(cellId);
        Option<Cell> option2 = this.getTenantCell(tenantId);
        Tuple2 tuple2 = new Tuple2(option2, option);
        if (option2 instanceof Some) {
            Cell sourceCell = (Cell)((Some)option2).value();
            if (option instanceof Some) {
                Cell targetCell = (Cell)((Some)option).value();
                if (sourceCell.equals((Object)targetCell)) {
                    return;
                }
                if (!CellAssignor.isCellOpenForAssignment((Cell)targetCell, (java.util.Set)CollectionConverters$.MODULE$.SetHasAsJava((Set)usableBrokers.map((Function1 & Serializable)x -> ZkTenantControlManager.$anonfun$assignTenantToCell$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), (int)this.replicationFactor)) {
                    throw new InvalidRequestException(new StringBuilder(146).append("Tenant ").append(tenantId).append(" cannot be moved to cells ").append(targetCell.cellId()).append(" since the cells either ").append("does not have enough brokers to meet its minSize or does not have at least ").append(this.replicationFactor).append(" alive brokers").toString());
                }
                if (!force) {
                    if (CellAssignor.PROHIBITED_TARGET_STATES.contains(targetCell.state())) {
                        throw new InvalidRequestException(new StringBuilder(56).append("Tenant ").append(tenantId).append(" cannot be moved to cells ").append(targetCell.cellId()).append(" since it is prohibited").toString());
                    }
                    if (CellAssignor.PROHIBITED_SOURCE_STATES.contains(sourceCell.state())) {
                        throw new InvalidRequestException(new StringBuilder(58).append("Tenant ").append(tenantId).append(" cannot be moved from cells ").append(sourceCell.cellId()).append(" since it is prohibited").toString());
                    }
                }
                Tenant tenant = new Tenant(tenantId, Collections.singletonList(Predef$.MODULE$.int2Integer(cellId)));
                this.zkClient.setTenant(tenant, this.context.epochZkVersion());
                this.context.updateTenant(tenant);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Tenant ").append(tenantId).append(" is manually assigned cell ").append(cellId).toString());
                return;
            }
        }
        if (None$.MODULE$.equals(option)) {
            throw new CellNotFoundException(new StringBuilder(20).append("Cell ").append(cellId).append(" does not exist").toString());
        }
        if (None$.MODULE$.equals(option2)) {
            throw new TenantNotFoundException(new StringBuilder(22).append("Tenant ").append(tenantId).append(" does not exist").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<Cell> getTenantCell(String tenantId) {
        Option tenant2 = this.context.tenantIdToTenant().get((Object)tenantId);
        Option cell = tenant2.flatMap((Function1 & Serializable)tenant -> $this.cellControl.getCell(Predef$.MODULE$.Integer2int((Integer)tenant.cellIds().get(0))));
        if (tenant2.isDefined() && cell.isEmpty()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Tenant ").append(tenantId).append(" is assigned to cell ").append(((Tenant)tenant2.get()).cellIds().get(0)).append(", however the cell does not exist").toString());
        }
        return cell;
    }

    public synchronized void deleteTenant(String tenantId) {
        boolean deleted = false;
        if (this.context.tenantIdToTenant().contains((Object)tenantId)) {
            deleted = this.zkClient.deleteTenant(tenantId, this.context.epochZkVersion());
            this.context.removeTenant(tenantId);
        }
        if (deleted) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Deleted tenant ").append(tenantId).append(" information").toString());
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Tenant ").append(tenantId).append(" information was already deleted").toString());
    }

    public Seq<Tenant> sortedTenants() {
        return (Seq)this.context.tenantIdToTenant().values().toSeq().sortBy((Function1 & Serializable)x$2 -> x$2.tenantId(), (Ordering)Ordering.String$.MODULE$);
    }

    public List<Integer> getTenantCellIds(String tenantId) {
        int cellId = BoxesRunTime.unboxToInt((Object)this.getTenantCell(tenantId).map((Function1 & Serializable)cell -> BoxesRunTime.boxToInteger((int)cell.cellId())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
        return Arrays.asList(Predef$.MODULE$.int2Integer(cellId));
    }

    public PartitionPlacementStrategy calculatePartitionPlacementStrategy(Option<KafkaPrincipal> principalOpt) {
        return CellAssignor.calculatePartitionPlacementStrategy((Optional)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(principalOpt)), (PartitionPlacementStrategy)this.config.defaultPartitionPlacementStrategy());
    }

    public boolean isTenantCellPlacementEnabled(Option<KafkaPrincipal> principalOpt) {
        return CellAssignor.isTenantCellPlacementEnabled((Optional)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(principalOpt)), (PartitionPlacementStrategy)this.config.defaultPartitionPlacementStrategy());
    }

    public static final /* synthetic */ void $anonfun$createTenant$1(ZkTenantControlManager $this, String tenantId$2, int cellId$1, Cell x$1) {
        try {
            Tenant tenant = new Tenant(tenantId$2, Collections.singletonList(Predef$.MODULE$.int2Integer(cellId$1)));
            $this.zkClient.createTenant(tenant, $this.context.epochZkVersion());
            $this.context.updateTenantIfAbsent(tenant);
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Tenant ").append(tenantId$2).append(" is created with cell ").append(cellId$1).toString());
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new InvalidRequestException(new StringBuilder(22).append("Tenant ").append(tenantId$2).append(" already exists").toString());
        }
    }

    public static final /* synthetic */ Integer $anonfun$assignTenantToCell$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public ZkTenantControlManager(KafkaZkClient zkClient, ZkCellControlManager cellControl, ControllerContext context, KafkaConfig config, short replicationFactor) {
        this.zkClient = zkClient;
        this.cellControl = cellControl;
        this.context = context;
        this.config = config;
        this.replicationFactor = replicationFactor;
    }
}

