/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkChannelContext;
import kafka.server.link.ClusterLinkClientType;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class ClusterLinkAdminClient$
implements Logging {
    public static final ClusterLinkAdminClient$ MODULE$ = new ClusterLinkAdminClient$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public ClusterLinkAdminClient createRemoteAdmin(KafkaConfig brokerConfig, String linkName, ClusterLinkConfig linkConfig, Option<ClusterLinkConnectionManager> connectionManager, ClusterLinkClientType clientType, int localBrokerId, Metrics metrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkChannelContext clusterLinkChannelContext, Function0<Object> intranetConnectivityDeniedChecker, Time time) {
        String clientId = new StringBuilder(16).append("cluster-link-").append(clientType.name()).append("-").append(linkName).append("-").append(linkConfig.linkMode().lowerCaseName()).append("-").append(localBrokerId).toString();
        LogContext logContext = new LogContext(new StringBuilder(24).append("[AdminClient clientId=").append(clientId).append("] ").toString(), (AtomicReference)connectionManager.map((Function1 & Serializable)x$1 -> x$1.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Properties clientProps = new Properties();
        linkConfig.originals().forEach((k, v) -> clientProps.put(k, v));
        clientProps.put("bootstrap.servers", linkConfig.bootstrapServersToConnect(intranetConnectivityDeniedChecker));
        clientProps.put("client.id", clientId);
        AdminClientConfig adminConfig = new AdminClientConfig((Map)clientProps);
        AdminMetadataManager metadataManager = new AdminMetadataManager(logContext, Predef$.MODULE$.Long2long(adminConfig.getLong("retry.backoff.ms")), Predef$.MODULE$.Long2long(adminConfig.getLong("metadata.max.age.ms")), false);
        List addresses = ClientUtils.parseAndValidateAddresses((List)adminConfig.getList("bootstrap.servers"), (String)adminConfig.getString("client.dns.lookup"));
        metadataManager.update(Cluster.bootstrap((List)addresses), time.milliseconds());
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(brokerConfig, linkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(linkName), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)metadataManager.updater()), metrics, selectorMetricsRegistry, ClusterLinkFactory$.MODULE$.linkMetricTags(linkName), time, clientId, clientType, (Option<ClusterLinkChannelContext>)Option$.MODULE$.apply((Object)clusterLinkChannelContext), logContext, (AtomicReference)connectionManager.map((Function1 & Serializable)x$2 -> x$2.maxLogLevel()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        try {
            NetworkClient networkClient = (NetworkClient)clusterLinkClient.networkClient();
            connectionManager.foreach((Function1 & Serializable)x$3 -> {
                x$3.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)new Some((Object)metadataManager));
                return BoxedUnit.UNIT;
            });
            ConfluentAdmin admin = ConfluentAdminUtils.createConfluentAdmin((AdminClientConfig)adminConfig, (AdminMetadataManager)metadataManager, (KafkaClient)networkClient, (Time)time);
            return new ClusterLinkAdminClient(admin, metadataManager, clusterLinkClient, networkClient, clientId);
        }
        catch (Throwable e) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = "Failed to create cluster link admin client";
                Object var22_22 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
            }
            clusterLinkClient.close();
            throw e;
        }
    }

    public static final /* synthetic */ String $anonfun$createRemoteAdmin$5() {
        return "Failed to create cluster link admin client";
    }

    public static final /* synthetic */ Throwable $anonfun$createRemoteAdmin$6(Throwable e$1) {
        return e$1;
    }

    private ClusterLinkAdminClient$() {
    }
}

