/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason;
import kafka.server.link.LinkState;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnavailableLinkReason$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u0010!\u0001\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\bC\u0005C\u0001\t\u0005\t\u0015!\u0003D\r\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\nC\u0005N\u0001\t\u0005\t\u0015!\u0003K\u001d\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0013y\u0003!\u0011!Q\u0001\n}c\u0007\"C7\u0001\u0005\u0003\u0005\u000b\u0011\u00028s\u0011\u0015\u0019\b\u0001\"\u0001u\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u0003\u0011%\ti\u0002\u0001a\u0001\n\u0013\ty\u0002C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$!9\u0011q\u0006\u0001!B\u0013\u0019\u0005\"CA\u0019\u0001\u0001\u0007I\u0011BA\u001a\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002H\u0001\u0001\u000b\u0015BA\u001b\u0011!\t\t\u0006\u0001C)A\u0005M\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!a0\u0001\t#\n\t\rC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0007bBAv\u0001\u0011%\u0011Q\u001e\u0002!\u00072,8\u000f^3s\u0019&t7n\u00115fG.d\u0015N\\6Bm\u0006LG.\u00192jY&$\u0018P\u0003\u0002\"E\u0005!A.\u001b8l\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tISF\u0004\u0002+W5\t\u0001%\u0003\u0002-A\u0005!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!AL\u0018\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u00051\u0002\u0013A\u00037j].\u001cuN\u001c4jOB\u0019!'N\u001c\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005)B\u0014BA\u001d!\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\tQC(\u0003\u0002>A\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0011\u0005)\u0002\u0015BA!!\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u0015%tG/\u001a:wC2l5\u000f\u0005\u00023\t&\u0011Qi\r\u0002\u0004\u0013:$\u0018BA$.\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\fG2\u001c6\r[3ek2,'/F\u0001K!\tQ3*\u0003\u0002MA\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\fAb\u00197TG\",G-\u001e7fe\u0002J!aT\u0017\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0001\u00037j].$\u0015\r^1\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0013\u0002\u0005i\\\u0017BA,U\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u0003-\u0011X-\\8uK\u0006#W.\u001b8\u0011\u0005)Z\u0016B\u0001/!\u0005U\u0019E.^:uKJd\u0015N\\6CCR\u001c\u0007.\u00113nS:\f!\u0002\\8dC2\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0005\u0001TW\"A1\u000b\u0005\t\u001c\u0017!B;uS2\u001c(B\u00013f\u0003\u0019\u0019w.\\7p]*\u0011QE\u001a\u0006\u0003O\"\fa!\u00199bG\",'\"A5\u0002\u0007=\u0014x-\u0003\u0002lC\n!A+[7f\u0013\tqV&A\u0003rk>$\u0018\r\u0005\u0002pa6\t!%\u0003\u0002rE\t92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0003[6\na\u0001P5oSRtDcC;wobL(p\u001f?~}~\u0004\"A\u000b\u0001\t\u000bAj\u0001\u0019A\u0019\t\u000bij\u0001\u0019A\u001e\t\u000byj\u0001\u0019A \t\u000b\tk\u0001\u0019A\"\t\u000b!k\u0001\u0019\u0001&\t\u000bAk\u0001\u0019\u0001*\t\u000bek\u0001\u0019\u0001.\t\u000buk\u0001\u0019\u0001.\t\u000byk\u0001\u0019A0\t\u000b5l\u0001\u0019\u00018\u0002\u00111Lgn\u001b(b[\u0016,\"!!\u0002\u0011\t\u0005\u001d\u0011Q\u0003\b\u0005\u0003\u0013\t\t\u0002E\u0002\u0002\fMj!!!\u0004\u000b\u0007\u0005=a%\u0001\u0004=e>|GOP\u0005\u0004\u0003'\u0019\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0005e!AB*ue&twMC\u0002\u0002\u0014M\n\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\u0013\u0019\f\u0017\u000e\\\"pk:$X#A\"\u0002\u001b\u0019\f\u0017\u000e\\\"pk:$x\fJ3r)\u0011\t)#a\u000b\u0011\u0007I\n9#C\u0002\u0002*M\u0012A!\u00168ji\"A\u0011QF\t\u0002\u0002\u0003\u00071)A\u0002yIE\n!BZ1jY\u000e{WO\u001c;!\u0003!!\u0018m]6EKN\u001cWCAA\u001b!\u0015\u0011\u0014qGA\u001e\u0013\r\tId\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007)\ni$C\u0002\u0002@\u0001\u0012q\u0002V1tW\u0012+7o\u0019:jaRLwN\\\u0001\ri\u0006\u001c8\u000eR3tG~#S-\u001d\u000b\u0005\u0003K\t)\u0005C\u0005\u0002.Q\t\t\u00111\u0001\u00026\u0005IA/Y:l\t\u0016\u001c8\r\t\u0015\u0004+\u0005-\u0003c\u0001\u001a\u0002N%\u0019\u0011qJ\u001a\u0003\u0011Y|G.\u0019;jY\u0016\f1A];o)\t\t)\u0006\u0005\u0003\u0002X\u0005\u0015dbAA-W9!\u00111LA2\u001d\u0011\ti&!\u0019\u000f\t\u0005-\u0011qL\u0005\u0002K%\u00111\u0005J\u0005\u0003C\tJ1!a\u001a0\u0005)!\u0016m]6SKN,H\u000e^\u0001\u001cg.L\u0007OU3n_R,\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u000eCWmY6\u0016\u0005\u00055\u0004c\u0001\u001a\u0002p%\u0019\u0011\u0011O\u001a\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0002.\u00198eY\u0016$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z:vYR$b!!\u0016\u0002x\u0005\u0005\u0005bBA=1\u0001\u0007\u00111P\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002X\u0005u\u0014bAA@_\tYA+Y:l\u0007>tG/\u001a=u\u0011\u001d\t\u0019\t\u0007a\u0001\u0003\u000b\u000bq%\\1zE\u0016\u001cE.^:uKJd\u0015N\\6D_:tWm\u0019;j_:\u001c\u0005.Z2lKJ\u0014Vm];miB)!'a\u000e\u0002\bB\u0019!&!#\n\u0007\u0005-\u0005E\u0001\u0012DYV\u001cH/\u001a:MS:\\7i\u001c8oK\u000e$\u0018n\u001c8DQ\u0016\u001c7.\u001a:SKN,H\u000e^\u0001&Q\u0006tG\r\\3M_\u000e\fG\u000eR3tGJL'-Z\"mkN$XM\u001d'j].\u001c(+Z:vYR$b!!\u0016\u0002\u0012\u0006M\u0005bBA=3\u0001\u0007\u00111\u0010\u0005\b\u0003+K\u0002\u0019AAL\u0003M!Wm]2sS\n,G*\u001b8lg\u001a+H/\u001e:f!\u0019\tI*a'\u0002 6\t1-C\u0002\u0002\u001e\u000e\u00141bS1gW\u00064U\u000f^;sKB1\u0011\u0011UAV\u0003_k!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u0005kRLGN\u0003\u0002\u0002*\u0006!!.\u0019<b\u0013\u0011\ti+a)\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u000b\u0005$W.\u001b8\u000b\u0007\u0005eV-A\u0004dY&,g\u000e^:\n\t\u0005u\u00161\u0017\u0002\u0017\u00072,8\u000f^3s\u0019&t7\u000eR3tGJL\u0007\u000f^5p]\u0006aqN\\\"p[BdW\r^5p]R!\u0011QEAb\u0011\u001d\t)M\u0007a\u0001\u0003\u000f\faA]3tk2$\bcA\u0015\u0002J&\u0019\u00111Z\u0018\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u001fQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:$\"!!\u000e\u0002+1L7\u000f\u001e*f[>$Xm\u00117vgR,'\u000fT5oWR!\u0011QKAk\u0011\u001d\tI\b\ba\u0001\u0003w\nA\u0003[1oI2,G*[:u\u0019&t7NU3tk2$HCBA+\u00037\fi\u000eC\u0004\u0002zu\u0001\r!a\u001f\t\u000f\u0005}W\u00041\u0001\u0002b\u00061a-\u001e;ve\u0016\u0004b!!'\u0002\u001c\u0006\r\bCBAQ\u0003W\u000b)\u000f\u0005\u0003\u00022\u0006\u001d\u0018\u0002BAu\u0003g\u0013!c\u00117vgR,'\u000fT5oW2K7\u000f^5oO\u0006!Bn\\4MS:\\G)Z:de&\u0014W-\u0012:s_J$b!!\n\u0002p\n\u0015\u0001bBAy=\u0001\u0007\u00111_\u0001\u0002KB!\u0011Q_A\u0000\u001d\u0011\t90a?\u000f\t\u0005-\u0011\u0011`\u0005\u0002i%\u0019\u0011Q`\u001a\u0002\u000fA\f7m[1hK&!!\u0011\u0001B\u0002\u0005%!\u0006N]8xC\ndWMC\u0002\u0002~NBqAa\u0002\u001f\u0001\u0004\t)!\u0001\u0005mS:\\G)Z:d\u0001")
public class ClusterLinkCheckLinkAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final Function0<ClusterLinkConfig> linkConfig;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final String linkName;
    private int failCount;
    private volatile Option<TaskDescription> taskDesc;

    public ClusterLinkScheduler clScheduler() {
        return super.scheduler();
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    private String linkName() {
        return this.linkName;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.skipRemoteAvailabilityCheck()) {
            KafkaFuture describeLinksFuture = this.localAdmin.describeClusterLink(this.linkName()).result();
            this.scheduleWhenComplete(describeLinksFuture, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleLocalDescribeClusterLinksResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkDescription>>)describeLinksFuture), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        ClusterLinkBatchAdmin doBasicDescribeCluster_admin = this.remoteAdmin;
        Object var7_4 = null;
        DescribeClusterResult describeClusterResult = doBasicDescribeCluster_admin.describeCluster();
        JFunction0.mcZ.sp & Serializable intranetConnectivityDeniedChecker = (JFunction0.mcZ.sp & Serializable)() -> $this.clusterLinkManager.isIntranetConnectivityDeniedForOrg((Option<String>)this.linkData().tenantPrefix().map((Function1 & Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix)));
        this.scheduleWhenComplete(describeClusterResult.clusterId(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)((Function1 & Serializable)arg_0 -> ClusterLinkCheckLinkAvailability.$anonfun$run$4(this, describeClusterResult, (Function0)intranetConnectivityDeniedChecker, arg_0)), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private boolean skipRemoteAvailabilityCheck() {
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode = this.clusterLinkManager.brokerConfig().clusterLinkAvailabilityCheckMode();
        ConfluentConfigs.ClusterLinkAvailabilityCheckMode clusterLinkAvailabilityCheckMode2 = ConfluentConfigs.ClusterLinkAvailabilityCheckMode.LINK_COORDINATOR;
        return !(clusterLinkAvailabilityCheckMode != null ? !clusterLinkAvailabilityCheckMode.equals(clusterLinkAvailabilityCheckMode2) : clusterLinkAvailabilityCheckMode2 != null) && !this.clusterLinkManager.metadataManager().isLinkCoordinator(this.linkName());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeClusterResult(ClusterLinkScheduler.TaskContext taskContext, Option<ClusterLinkConnectionCheckerResult> maybeClusterLinkConnectionCheckerResult) {
        if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        String linkName = this.metrics.linkName();
        if (None$.MODULE$.equals(maybeClusterLinkConnectionCheckerResult)) {
            this.failCount_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Link ").append(linkName).append(" availability check succeeded").toString());
            this.clusterLinkManager.reportAvailableLink(linkName);
        } else if (maybeClusterLinkConnectionCheckerResult instanceof Some) {
            ClusterLinkConnectionCheckerResult linkUnavailableResult = (ClusterLinkConnectionCheckerResult)((Some)maybeClusterLinkConnectionCheckerResult).value();
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkUnavailableSensor().record();
            if (linkUnavailableResult.unavailableLinkReason() instanceof InvalidBootstrapInternalEndpointUnavailableLinkReason) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Link ").append(linkName).append(" availability check failed with authorization error").toString());
                this.clusterLinkManager.failClusterLink(linkName, linkUnavailableResult.throwable(), UnauthorizedBootstrapFailedLinkReason$.MODULE$, (ClusterLinkConfig)((Object)this.linkConfig.apply()));
            } else {
                LinkState linkState;
                if (this.failCount() >= Predef$.MODULE$.Integer2int(((ClusterLinkConfig)((Object)this.linkConfig.apply())).availabilityCheckConsecutiveFailureThreshold())) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Reporting ").append(linkName).append(" as unavailable with exception ").append(linkUnavailableResult.throwable().getCause()).append(" and reason ").append(linkUnavailableResult.unavailableLinkReason()).append(" failCount ").append(this.failCount()).toString());
                    this.clusterLinkManager.reportUnavailableLink(linkName, linkUnavailableResult.unavailableLinkReason());
                }
                LinkState linkState2 = linkState = this.clusterLinkManager.linkState(linkName);
                ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
                if (linkState2 != null && linkState2.equals(activeClusterLink$)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Link ").append(linkName).append(" availability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> linkUnavailableResult.throwable());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Link ").append(linkName).append(" availability check in state ").append(linkState).append(" failed ").append(this.failCount()).append(" times with exception ").append(linkUnavailableResult.throwable().getCause()).append(" ").append("and reason code ").append(linkUnavailableResult.unavailableLinkReason()).toString());
                }
            }
        } else {
            throw new MatchError(maybeClusterLinkConnectionCheckerResult);
        }
        if (!((ClusterLinkConfig)((Object)this.linkConfig.apply())).remoteIsUnmanaged()) {
            if (this.failCount() == 0) {
                return this.listRemoteClusterLink(taskContext);
            }
            this.clusterLinkManager.updateRemoteLinkState(linkName, new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)"Failed to obtain remote link state since cluster link is unavailable"), super.time().milliseconds()));
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleLocalDescribeClusterLinksResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkDescription>> describeLinksFuture) {
        void var5_6;
        void var4_5;
        if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        Tuple2 tuple2 = this.liftedTree1$1(describeLinksFuture);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Collection links = (Collection)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        var4_5.forEach(link -> {
            if (!$this.clusterLinkManager.metadataManager().isLinkCoordinator(link.linkName())) {
                RemoteLinkState remoteLinkState = new RemoteLinkState(link.remoteLinkState(), link.remoteLinkError(), (Option<String>)Option$.MODULE$.apply((Object)link.remoteLinkErrorMessage()), link.remoteLinkStateTimeMs());
                ClusterLinkDescription.LinkState linkState = link.linkState();
                if (ClusterLinkDescription.LinkState.ACTIVE.equals(linkState)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") is active").toString());
                    $this.clusterLinkManager.reportAvailableLink(link.linkName());
                } else if (ClusterLinkDescription.LinkState.UNAVAILABLE.equals(linkState)) {
                    UnavailableLinkReason reason = UnavailableLinkReason$.MODULE$.fromError(link.clusterLinkError(), link.linkErrorMessage());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") is unavailable, reason ").append(reason).toString());
                    $this.metrics.linkUnavailableSensor().record();
                    $this.clusterLinkManager.reportUnavailableLink(link.linkName(), reason);
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Link ").append(link.linkName()).append("(").append(link.clusterLinkId()).append(") has state ").append(linkState).append(", ignoring.").toString());
                }
                $this.clusterLinkManager.updateRemoteLinkState(link.linkName(), remoteLinkState);
                return;
            }
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Ignoring link state of ").append(link.linkName()).append(" since this broker has already processed the state as link coordinator").toString());
        });
        if (var5_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_6).value();
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(var5_6)) {
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        throw new MatchError((Object)var5_6);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkCheckAvailabilityTaskType$.MODULE$, false, "run the availability check task"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult listRemoteClusterLink(ClusterLinkScheduler.TaskContext taskContext) {
        KafkaFuture listLinkResult = this.remoteAdmin.listClusterLink(this.linkName()).result();
        this.scheduleWhenComplete(listLinkResult, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListLinkResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkListing>>)listLinkResult), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleListLinkResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkListing>> future) {
        .colon.colon colon2;
        void var6_6;
        void var7_7;
        block9: {
            Tuple2 tuple2;
            block8: {
                if (Predef$.MODULE$.Boolean2boolean(((ClusterLinkConfig)((Object)this.linkConfig.apply())).clusterLinkPaused())) {
                    Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
                    return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                }
                long now = super.time().milliseconds();
                tuple2 = this.liftedTree2$1(future, now);
                if (tuple2 == null) break block8;
                Option errOpt = (Option)tuple2._1();
                RemoteLinkState remoteLinkState = (RemoteLinkState)tuple2._2();
                if (errOpt != null && remoteLinkState != null) break block9;
            }
            throw new MatchError((Object)tuple2);
        }
        this.clusterLinkManager.updateRemoteLinkState(this.linkName(), (RemoteLinkState)var7_7);
        if (var6_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var6_6).value();
            colon2 = new .colon.colon((Object)err, (List)Nil$.MODULE$);
        } else if (None$.MODULE$.equals(var6_6)) {
            colon2 = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)var6_6);
        }
        .colon.colon errs = colon2;
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private void logLinkDescribeError(Throwable e, String linkDesc) {
        Throwable cause;
        Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
        if (this.failCount() == 0 && !(cause instanceof RetriableException)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append(linkDesc).append(" link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append(linkDesc).append(" link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
    }

    public static final /* synthetic */ ClusterLinkScheduler.TaskResult $anonfun$run$4(ClusterLinkCheckLinkAvailability $this, DescribeClusterResult describeClusterResult$1, Function0 intranetConnectivityDeniedChecker$1, ClusterLinkScheduler.TaskContext tc) {
        return $this.handleDescribeClusterResult(tc, ClusterLinkConnectionChecker$.MODULE$.check(describeClusterResult$1, (ClusterLinkConfig)((Object)$this.linkConfig.apply()), (Option<ClusterLinkFactory.LinkMetrics>)Option$.MODULE$.apply((Object)$this.metrics), true, (Function0<Object>)intranetConnectivityDeniedChecker$1, $this.linkData().tenantPrefix()));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture describeLinksFuture$2) {
        try {
            return new Tuple2(describeLinksFuture$2.get(), (Object)None$.MODULE$);
        }
        catch (Throwable e) {
            this.logLinkDescribeError(e, "Local");
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to obtain local link state from the link coordinator.");
            return new Tuple2(Collections.emptySet(), (Object)new Some((Object)err));
        }
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture future$1, long now$1) {
        Tuple2 tuple2;
        try {
            Collection listing = (Collection)future$1.get();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("handleListLinkResult ").append(this.linkName()).append(": ").append(listing).toString());
            if (!listing.isEmpty()) {
                ClusterLinkListing remoteLink = (ClusterLinkListing)listing.iterator().next();
                return new Tuple2((Object)None$.MODULE$, (Object)new RemoteLinkState(remoteLink.linkState(), remoteLink.clusterLinkError(), (Option<String>)Option$.MODULE$.apply((Object)remoteLink.linkErrorMessage()), now$1));
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Remote link state is empty for cluster link ").append(this.linkName()).toString());
            None$ x$4 = None$.MODULE$;
            Tuple2 tuple22 = new Tuple2((Object)None$.MODULE$, (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND, ClusterLinkError.NO_ERROR, (Option<String>)x$4, now$1));
            tuple2 = tuple22;
        }
        catch (Throwable ex) {
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(59).append("Remote link state could not be determined for cluster link ").append(this.linkName()).toString());
            this.logLinkDescribeError(e, "Remote");
            if (e instanceof AuthenticationException) {
                String errMsg = "Failed to obtain remote link state due to authentication failure. This failure may impact functioning of this link until credentials are updated.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHENTICATION_ERROR, (Option<String>)new Some((Object)errMsg), now$1));
            }
            if (e instanceof ClusterAuthorizationException) {
                String errMsg = "Failed to obtain remote link state due to Describe:Cluster authorization failure. This failure may impact functioning of this link until appropriate access is granted.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHORIZATION_ERROR, (Option<String>)new Some((Object)errMsg), now$1));
            }
            if (e != null) {
                String errMsg = "Failed to obtain remote link state for an unknown reason.";
                return new Tuple2((Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)), (Object)new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)errMsg), now$1));
            }
            throw new MatchError(null);
        }
        return tuple2;
    }

    public ClusterLinkCheckLinkAvailability(Function0<ClusterLinkConfig> linkConfig, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs, ClusterLinkScheduler clScheduler, ClusterLinkData linkData, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota) {
        this.linkConfig = linkConfig;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clScheduler, "ClusterLinkCheckLinkAvailability", intervalMs, time, quota);
        this.linkName = linkData.linkName();
        this.failCount = 0;
        this.taskDesc = None$.MODULE$;
    }
}

