/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kafka.network.RequestChannel;
import kafka.server.ForwardingManager;
import kafka.server.link.ClusterLinkDisabled$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.MirrorTopicRequestHelperKraft;
import kafka.server.link.MirrorTopicRequestHelperKraft$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001\u0002\u000f\u001e\u0001\u0011B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\n}\u0001\u0011\t\u0011)A\u0005\u007f%C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011!\t\bA!A!\u0002\u0013\u0011\b\"B;\u0001\t\u00031\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u000f\u0005\u001d\u0002\u0001)A\u0005e\"Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0016\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\t\u0017\u0005-\u0004\u00011A\u0001B\u0003&\u0011Q\u0006\u0005\b\u0003[\u0002A\u0011KA8\u0011\u001d\ti\b\u0001C)\u0003\u007fBq!!!\u0001\t#\ny\bC\u0004\u0002\u0004\u0002!\t&!\"\t\u000f\u0005E\u0005\u0001\"\u0015\u0002p!9\u00111\u0013\u0001\u0005R\u0005}\u0004bBAK\u0001\u0011E\u0013q\u0013\u0005\b\u00033\u0003A\u0011BAN\u0005u\u0019%/Z1uK6K'O]8s)>\u0004\u0018nY:IK2\u0004XM]&sC\u001a$(B\u0001\u0010 \u0003\u0011a\u0017N\\6\u000b\u0005\u0001\n\u0013AB:feZ,'OC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0007\u0019:\u0013&D\u0001\u001e\u0013\tASDA\u000fNSJ\u0014xN\u001d+pa&\u001c'+Z9vKN$\b*\u001a7qKJ\\%/\u00194u!\tQC'D\u0001,\u0015\taS&A\u0004nKN\u001c\u0018mZ3\u000b\u00059z\u0013AB2p[6|gN\u0003\u0002#a)\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h\u0013\t)4F\u0001\rDe\u0016\fG/\u001a+pa&\u001c7OU3ta>t7/\u001a#bi\u0006\fA\"\u00193nS:l\u0015M\\1hKJ\u0004\"\u0001O\u001e\u000f\u0005\u0019J\u0014B\u0001\u001e\u001e\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005qj$\u0001D!e[&tW*\u00198bO\u0016\u0014(B\u0001\u001e\u001e\u0003\u001d\u0011X-];fgR\u0004\"\u0001\u0011$\u000f\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u000b\u0013a\u00028fi^|'o[\u0005\u0003\u000b\n\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002H\u0011\n9!+Z9vKN$(BA#C\u0013\tqt%\u0001\u0004go\u0012luM\u001d\t\u0003\u00196k\u0011aH\u0005\u0003\u001d~\u0011\u0011CR8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s\u0003U\u0019XM\u001c3G_J<\u0018M\u001d3fIJ+7\u000f]8og\u0016\u0004R!\u0015+@-rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\n\rVt7\r^5p]J\u0002\"a\u0016.\u000e\u0003aS!!W\u0017\u0002\u0011I,\u0017/^3tiNL!a\u0017-\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007CA)^\u0013\tq&K\u0001\u0003V]&$\u0018a\u00055b]\u0012dW-\u0012:s_J\u0014Vm\u001d9p]N,\u0007#B)U\u007f\u0005d\u0006C\u00012k\u001d\t\u0019\u0007N\u0004\u0002eO6\tQM\u0003\u0002gG\u00051AH]8pizJ\u0011aU\u0005\u0003SJ\u000bq\u0001]1dW\u0006<W-\u0003\u0002lY\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003SJ\u000bQ\u0005[1oI2,\u0017J\u001c<bY&$g+\u001a:tS>t7\u000fR;sS:<gi\u001c:xCJ$\u0017N\\4\u0011\tE{w\bX\u0005\u0003aJ\u0013\u0011BR;oGRLwN\\\u0019\u0002%i\\W*[4sCRLwN\\#oC\ndW\r\u001a\t\u0003#NL!\u0001\u001e*\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"\u0002b\u001e=zundXP \t\u0003M\u0001AQA\u000e\u0005A\u0002]BQA\u0010\u0005A\u0002}BQA\u0013\u0005A\u0002-CQa\u0014\u0005A\u0002ACQa\u0018\u0005A\u0002\u0001DQ!\u001c\u0005A\u00029DQ!\u001d\u0005A\u0002I\f1c\u0019:fCR,Gk\u001c9jGN\u0014V-];fgR,\"!a\u0001\u0011\u0007]\u000b)!C\u0002\u0002\ba\u00131c\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR\fAc\u0019:fCR,Gk\u001c9jGN\u0014V-];fgR\u0004\u0013!\u0003;j[\u0016|W\u000f^'t+\t\ty\u0001E\u0002R\u0003#I1!a\u0005S\u0005\rIe\u000e^\u0001\u000bi&lWm\\;u\u001bN\u0004\u0013a\u0002<feNLwN\\\u000b\u0003\u00037\u00012!UA\u000f\u0013\r\tyB\u0015\u0002\u0006'\"|'\u000f^\u0001\tm\u0016\u00148/[8oA\u0005aa/\u00197jI\u0006$Xm\u00148msV\t!/A\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010I\u0001\u0010g>,(oY3U_BL7-\u00138g_V\u0011\u0011Q\u0006\t\t\u0003_\t)$!\u000f\u0002J5\u0011\u0011\u0011\u0007\u0006\u0004\u0003g\u0011\u0016AC2pY2,7\r^5p]&!\u0011qGA\u0019\u0005\ri\u0015\r\u001d\t\u0005\u0003w\t\u0019E\u0004\u0003\u0002>\u0005}\u0002C\u00013S\u0013\r\t\tEU\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0013q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005#\u000b\u0005\u0004\u0002L\u0005e\u0013QL\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005M\u0013QK\u0001\u0005kRLGN\u0003\u0002\u0002X\u0005!!.\u0019<b\u0013\u0011\tY&!\u0014\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002'\u0003?J1!!\u0019\u001e\u0005Q\u0019E.^:uKJd\u0015N\\6U_BL7-\u00138g_\u0006\u00192o\\;sG\u0016$v\u000e]5d\u0013:4wn\u0018\u0013fcR\u0019A,a\u001a\t\u0013\u0005%$#!AA\u0002\u00055\u0012a\u0001=%c\u0005\u00012o\\;sG\u0016$v\u000e]5d\u0013:4w\u000eI\u0001'I>\u001c%/Z1uKZ\u000bG.\u001b3bi\u0016|e\u000e\\=NSJ\u0014xN\u001d+pa&\u001c'+Z9vKN$HCAA9!\u0015\t\u00161OA<\u0013\r\t)H\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007]\u000bI(C\u0002\u0002|a\u0013q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\u0017I>4\u0016\r\\5eCR,W*\u001b:s_J$v\u000e]5dgR\tA,A\u000fe_\u001a+Go\u00195T_V\u00148-\u001a+pa&\u001c\u0017J\u001c4pe6\fG/[8o\u0003\u0011\"wNV1mS\u0012\fG/Z'jeJ|'\u000fV8qS\u000e\u001cx+\u001b;i'>,(oY3J]\u001a|Gc\u0001/\u0002\b\"9\u0011\u0011R\fA\u0002\u0005-\u0015\u0001C2bY2\u0014\u0017mY6\u0011\tE\u000bi\tX\u0005\u0004\u0003\u001f\u0013&!\u0003$v]\u000e$\u0018n\u001c81\u0003e!wn\u0011:fCR,g)\u001b8bYR{\u0007/[2SKF,Xm\u001d;\u0002-\u0011|7+\u001a8e%\u0016\u001c\bo\u001c8tKR{7\t\\5f]R\fqF\\8NSJ\u0014xN\u001d+pa&\u001c7o\u0014:BY2l\u0015N\u001d:peR{\u0007/[2t\r\u0006LG.\u001a3WC2LG-\u0019;j_:$\u0012A]\u0001\u001dm\u0006d\u0017\u000eZ1uK\u000e\u0013X-\u0019;bE2,W*\u001b:s_J$v\u000e]5d)!\ti*a)\u0002J\u00065\u0007cA,\u0002 &\u0019\u0011\u0011\u0015-\u0003\u0011\u0005\u0003\u0018.\u0012:s_JDq!!*\u001c\u0001\u0004\t9+A\u0003u_BL7\r\u0005\u0003\u0002*\u0006\rg\u0002BAV\u0003\u007fsA!!,\u0002>:!\u0011qVA^\u001d\u0011\t\t,!/\u000f\t\u0005M\u0016q\u0017\b\u0004I\u0006U\u0016\"A\u001a\n\u0005E\u0012\u0014B\u0001\u00121\u0013\tqs&\u0003\u0002-[%\u0019\u0011\u0011Y\u0016\u0002/\r\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;ECR\f\u0017\u0002BAc\u0003\u000f\u0014ab\u0011:fCR\f'\r\\3U_BL7MC\u0002\u0002B.Bq!!\u000b\u001c\u0001\u0004\tY\rE\u0003R\u0003g\ni\u0003\u0003\u0004\u0002$m\u0001\rA\u001d")
public class CreateMirrorTopicsHelperKraft
extends MirrorTopicRequestHelperKraft<CreateTopicsResponseData> {
    private final ClusterLinkFactory.AdminManager adminManager;
    private final Function2<RequestChannel.Request, AbstractResponse, BoxedUnit> sendForwardedResponse;
    private final boolean zkMigrationEnabled;
    private final CreateTopicsRequest createTopicsRequest;
    private final int timeoutMs;
    private final short version;
    private final boolean validateOnly;
    private Map<String, CompletableFuture<ClusterLinkTopicInfo>> sourceTopicInfo;

    private CreateTopicsRequest createTopicsRequest() {
        return this.createTopicsRequest;
    }

    private int timeoutMs() {
        return this.timeoutMs;
    }

    private short version() {
        return this.version;
    }

    private boolean validateOnly() {
        return this.validateOnly;
    }

    private Map<String, CompletableFuture<ClusterLinkTopicInfo>> sourceTopicInfo() {
        return this.sourceTopicInfo;
    }

    private void sourceTopicInfo_$eq(Map<String, CompletableFuture<ClusterLinkTopicInfo>> x$1) {
        this.sourceTopicInfo = x$1;
    }

    @Override
    public Option<AbstractRequest> doCreateValidateOnlyMirrorTopicRequest() {
        CreateTopicsRequestData requestData = this.createTopicsRequest().data().duplicate();
        Iterator iterator = requestData.topics().iterator();
        while (iterator.hasNext()) {
            if (((CreateTopicsRequestData.CreatableTopic)iterator.next()).mirrorTopic() != null) continue;
            iterator.remove();
        }
        requestData.setValidateOnly(true);
        if (this.zkMigrationEnabled) {
            requestData.setIsClusterLinkingValidatedByBroker(true);
        }
        if (!requestData.topics().isEmpty()) {
            return new Some((Object)new CreateTopicsRequest.Builder(requestData).build(this.version()));
        }
        return None$.MODULE$;
    }

    @Override
    public void doValidateMirrorTopics() {
        this.validateOnlyMirrorTopicResponseData().foreach((Function1 & Serializable)x$9 -> {
            CreateMirrorTopicsHelperKraft.$anonfun$doValidateMirrorTopics$1(this, x$9);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void doFetchSourceTopicInformation() {
        this.validateOnlyMirrorTopicResponseData().foreach((Function1 & Serializable)responseData -> {
            CreateMirrorTopicsHelperKraft.$anonfun$doFetchSourceTopicInformation$1(this, responseData);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void doValidateMirrorTopicsWithSourceInfo(Function0<BoxedUnit> callback) {
        this.adminManager.tryCompleteElseWatch(this.timeoutMs(), this.sourceTopicInfo().values().toSeq(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.validateOnlyMirrorTopicResponseData().foreach((Function1 & Serializable)x$12 -> {
                CreateMirrorTopicsHelperKraft.$anonfun$doValidateMirrorTopicsWithSourceInfo$2(this, x$12);
                return BoxedUnit.UNIT;
            });
            callback.apply$mcV$sp();
        });
    }

    @Override
    public Option<AbstractRequest> doCreateFinalTopicRequest() {
        Option option = this.validateOnlyMirrorTopicResponseData();
        if (option instanceof Some) {
            CreateTopicsResponseData responseData = (CreateTopicsResponseData)((Some)option).value();
            CreateTopicsRequestData requestData = this.createTopicsRequest().data().duplicate();
            if (this.zkMigrationEnabled) {
                requestData.setIsClusterLinkingValidatedByBroker(true);
            }
            Iterator iterator = requestData.topics().iterator();
            while (iterator.hasNext()) {
                CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
                if (!Option$.MODULE$.apply((Object)responseData.topics().find(creatableTopic.name())).exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)CreateMirrorTopicsHelperKraft.$anonfun$doCreateFinalTopicRequest$1(x$13)))) continue;
                iterator.remove();
            }
            if (!requestData.topics().isEmpty()) {
                return new Some((Object)new CreateTopicsRequest.Builder(requestData).build(this.version()));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return new Some((Object)this.createTopicsRequest());
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doSendResponseToClient() {
        Option option = this.finalResponseData();
        if (option instanceof Some) {
            CreateTopicsResponseData finalResponse = (CreateTopicsResponseData)((Some)option).value();
            Option option2 = this.validateOnlyMirrorTopicResponseData();
            if (option2 instanceof Some) {
                ((CreateTopicsResponseData)((Some)option2).value()).topics().forEach(topic -> {
                    if (topic.errorCode() != Errors.NONE.code()) {
                        finalResponse.topics().add((ImplicitLinkedHashCollection.Element)topic.duplicate());
                        return;
                    }
                });
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("No mirror topics in the CreateTopics request ").append(this.createTopicsRequest()).toString());
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            this.finalResponseFromController_$eq(this.validateOnlyMirrorTopicResponse());
        }
        Option<AbstractResponse> option3 = this.finalResponseFromController();
        if (option3 instanceof Some) {
            AbstractResponse finalResponse = (AbstractResponse)((Some)option3).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)this.sendForwardedResponse.apply((Object)super.request(), (Object)finalResponse);
            return;
        }
        if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
        throw new IllegalStateException("Unable to process the request");
    }

    @Override
    public boolean noMirrorTopicsOrAllMirrorTopicsFailedValidation() {
        return this.validateOnlyMirrorTopicResponseData().forall((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CreateMirrorTopicsHelperKraft.$anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$1(x$14)));
    }

    private ApiError validateCreatableMirrorTopic(CreateTopicsRequestData.CreatableTopic topic, Option<Map<String, CompletableFuture<ClusterLinkTopicInfo>>> sourceTopicInfo, boolean validateOnly) {
        try {
            MirrorTopicRequestHelperKraft$.MODULE$.transformCreatableTopic(this.adminManager.clusterLinkManager(), topic, (Option<CompletableFuture<ClusterLinkTopicInfo>>)sourceTopicInfo.flatMap((Function1 & Serializable)x$16 -> x$16.get((Object)topic.name())), validateOnly, this.version());
            return ApiError.NONE;
        }
        catch (ConfigException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause()));
        }
        catch (ApiException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return ApiError.fromThrowable((Throwable)e);
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return ApiError.fromThrowable((Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$doValidateMirrorTopics$1(CreateMirrorTopicsHelperKraft $this, CreateTopicsResponseData x$9) {
        x$9.topics().forEach(topic -> {
            if (topic.errorCode() == Errors.NONE.code()) {
                if ($this.adminManager.clusterLinkingIsDisabled()) {
                    ApiError clDisabledApiError = ApiError.fromThrowable((Throwable)ClusterLinkDisabled$.MODULE$.exception(false));
                    topic.setErrorCode(clDisabledApiError.error().code());
                    topic.setErrorMessage(clDisabledApiError.message());
                    return;
                }
                ApiError apiError = $this.validateCreatableMirrorTopic($this.createTopicsRequest().data().topics().find(topic.name()), (Option<Map<String, CompletableFuture<ClusterLinkTopicInfo>>>)None$.MODULE$, true);
                topic.setErrorCode(apiError.error().code());
                topic.setErrorMessage(apiError.message());
                return;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$doFetchSourceTopicInformation$2(CreateTopicsResponseData.CreatableTopicResult topic) {
        return topic.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ void $anonfun$doFetchSourceTopicInformation$1(CreateMirrorTopicsHelperKraft $this, CreateTopicsResponseData responseData) {
        Iterable validatedMirrors = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responseData.topics()).asScala().filter((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)CreateMirrorTopicsHelperKraft.$anonfun$doFetchSourceTopicInformation$2(topic)));
        scala.collection.immutable.Map validatedMirrorToLinkIdMap = ((IterableOnceOps)validatedMirrors.map((Function1 & Serializable)topicResult -> {
            CreateTopicsRequestData.CreatableTopic creatableTopic = $this.createTopicsRequest().data().topics().find(topicResult.name());
            Option linkId = Option$.MODULE$.apply((Object)creatableTopic.linkName()).flatMap((Function1 & Serializable)name -> $this.adminManager.clusterLinkManager().clusterLinkMetadataManager().flatMap((Function1 & Serializable)x$10 -> x$10.getClusterLinkData((String)name)).map((Function1 & Serializable)x$11 -> x$11.linkId()));
            return new Tuple2((Object)creatableTopic.name(), (Object)linkId);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map validateMirrorsErrorInfo = ((IterableOnceOps)validatedMirrors.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.name()), (Object)new ApiError(topic.errorCode(), topic.errorMessage())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        $this.sourceTopicInfo_$eq($this.adminManager.clusterLinkManager().fetchSourceTopicInfoForMirrors((Map<String, Option<Uuid>>)validatedMirrorToLinkIdMap, (Map<String, ApiError>)validateMirrorsErrorInfo, (Function2 & Serializable)(topics, client) -> {
            scala.collection.immutable.Map topicsWithStartOffsetSpec = ((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)BoxesRunTime.boxToLong((long)$this.createTopicsRequest().data().topics().find(topic).mirrorStartOffsetSpec())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return client.fetchTopicInfos((Map<String, Object>)topicsWithStartOffsetSpec, $this.timeoutMs());
        }));
    }

    public static final /* synthetic */ void $anonfun$doValidateMirrorTopicsWithSourceInfo$2(CreateMirrorTopicsHelperKraft $this, CreateTopicsResponseData x$12) {
        x$12.topics().forEach(topic -> {
            if (topic.errorCode() == Errors.NONE.code()) {
                ApiError apiError = $this.validateCreatableMirrorTopic($this.createTopicsRequest().data().topics().find(topic.name()), (Option<Map<String, CompletableFuture<ClusterLinkTopicInfo>>>)new Some($this.sourceTopicInfo()), $this.validateOnly());
                topic.setErrorCode(apiError.error().code());
                topic.setErrorMessage(apiError.message());
                return;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$doCreateFinalTopicRequest$1(CreateTopicsResponseData.CreatableTopicResult x$13) {
        return x$13.errorCode() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$2(CreateTopicsResponseData.CreatableTopicResult x$15) {
        return x$15.errorCode() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$1(CreateTopicsResponseData x$14) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)x$14.topics()).asScala().forall((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CreateMirrorTopicsHelperKraft.$anonfun$noMirrorTopicsOrAllMirrorTopicsFailedValidation$2(x$15)));
    }

    public CreateMirrorTopicsHelperKraft(ClusterLinkFactory.AdminManager adminManager, RequestChannel.Request request, ForwardingManager fwdMgr, Function2<RequestChannel.Request, AbstractResponse, BoxedUnit> sendForwardedResponse, Function2<RequestChannel.Request, Throwable, BoxedUnit> handleErrorResponse, Function1<RequestChannel.Request, BoxedUnit> handleInvalidVersionsDuringForwarding, boolean zkMigrationEnabled) {
        this.adminManager = adminManager;
        this.sendForwardedResponse = sendForwardedResponse;
        this.zkMigrationEnabled = zkMigrationEnabled;
        super(request, fwdMgr, handleErrorResponse, handleInvalidVersionsDuringForwarding, zkMigrationEnabled);
        this.createTopicsRequest = (CreateTopicsRequest)super.request().body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class));
        this.timeoutMs = this.createTopicsRequest().data().timeoutMs();
        this.version = this.createTopicsRequest().version();
        this.validateOnly = this.createTopicsRequest().data().validateOnly();
    }
}

