/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.PartitionUnfence;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionUnfence
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 40;
    private final TopicIdPartition topicIdPartition;
    private final PartitionUnfence metadata;

    public TierPartitionUnfence(TopicIdPartition topicIdPartition, UUID messageId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(40).forceDefaults(true);
        PartitionUnfence.startPartitionUnfence((FlatBufferBuilder)builder);
        PartitionUnfence.addVersion((FlatBufferBuilder)builder, (byte)0);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)messageId.getMostSignificantBits(), (long)messageId.getLeastSignificantBits());
        PartitionUnfence.addMessageId((FlatBufferBuilder)builder, (int)messageIdOffset);
        int entryId = PartitionUnfence.endPartitionUnfence((FlatBufferBuilder)builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionUnfence.getRootAsPartitionUnfence((ByteBuffer)builder.dataBuffer());
    }

    public TierPartitionUnfence(TopicIdPartition topicIdPartition, PartitionUnfence metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 40;
    }

    public byte version() {
        return this.metadata.version();
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionUnfence;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    public String toString() {
        return "TierPartitionUnfence(version=" + this.version() + ", topicIdPartition=" + this.topicIdPartition() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ")";
    }
}

