/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.common.io.BaseEncoding;
import java.util.Arrays;

final class EncryptedDataKey {
    private final byte[] encryptedDataKey;

    EncryptedDataKey(byte[] encryptedDataKey) {
        this.encryptedDataKey = encryptedDataKey;
    }

    public static EncryptedDataKey fromBase64Encoded(String base64Encoded) {
        BaseEncoding encoding = BaseEncoding.base64();
        byte[] raw = encoding.decode((CharSequence)base64Encoded);
        return new EncryptedDataKey(raw);
    }

    byte[] keyMaterial() {
        return (byte[])this.encryptedDataKey.clone();
    }

    public String base64Encoded() {
        BaseEncoding encoding = BaseEncoding.base64();
        return encoding.encode(this.encryptedDataKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptedDataKey that = (EncryptedDataKey)o;
        return Arrays.equals(this.encryptedDataKey, that.encryptedDataKey);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encryptedDataKey);
    }
}

