/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.zip.Checksum;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.store.CombinedObjectStream;
import kafka.tier.store.ThrottledFileInputStream;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Crc32C;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.SegmentMetadataLayoutPutMode;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TierSegmentUpload<P> {
    private static final Logger log = LoggerFactory.getLogger(TierSegmentUpload.class);
    private final Time time = Time.SYSTEM;
    private final SegmentMetadataLayoutPutMode putMode;
    private final ObjectMetadata objectMetadata;
    private final File segment;
    private final File offsetIdx;
    private final File timestampIdx;
    private final Optional<P> producerStateSnapshotOpt;
    private final Optional<ByteBuffer> txnIdxOpt;
    private final Optional<ByteBuffer> epochStateOpt;
    private final LinkedHashMap<FragmentType, Object> orderedFragmentsForCombinedObject = new LinkedHashMap();
    private static final List<FragmentType> CANONICAL_ORDER_FOR_COMBINED_OBJECT;

    protected TierSegmentUpload(SegmentMetadataLayoutPutMode putMode, ObjectMetadata objectMetadata, File segment, File offsetIdx, File timestampIdx, Optional<P> producerStateSnapshotOpt, Optional<ByteBuffer> txnIdxOpt, Optional<ByteBuffer> epochStateOpt) {
        this.putMode = putMode;
        this.objectMetadata = objectMetadata;
        this.segment = segment;
        this.offsetIdx = offsetIdx;
        this.producerStateSnapshotOpt = producerStateSnapshotOpt;
        this.timestampIdx = timestampIdx;
        this.txnIdxOpt = txnIdxOpt;
        this.epochStateOpt = epochStateOpt;
        this.orderedFragmentsForCombinedObject.put(FragmentType.SEGMENT, segment);
        this.orderedFragmentsForCombinedObject.put(FragmentType.OFFSET_INDEX, offsetIdx);
        this.orderedFragmentsForCombinedObject.put(FragmentType.TIMESTAMP_INDEX, timestampIdx);
        producerStateSnapshotOpt.ifPresent(producerState -> this.orderedFragmentsForCombinedObject.put(FragmentType.PRODUCER_STATE, producerState));
        txnIdxOpt.ifPresent(txnIdx -> this.orderedFragmentsForCombinedObject.put(FragmentType.TRANSACTION_INDEX, txnIdx));
        epochStateOpt.ifPresent(epochState -> this.orderedFragmentsForCombinedObject.put(FragmentType.EPOCH_STATE, epochState));
    }

    public ObjectMetadata objectMetadata() {
        return this.objectMetadata;
    }

    public File segment() {
        return this.segment;
    }

    public File offsetIdx() {
        return this.offsetIdx;
    }

    public File timestampIdx() {
        return this.timestampIdx;
    }

    public Optional<P> producerStateSnapshotOpt() {
        return this.producerStateSnapshotOpt;
    }

    public Optional<ByteBuffer> txnIdxOpt() {
        return this.txnIdxOpt;
    }

    public Optional<ByteBuffer> epochStateOpt() {
        return this.epochStateOpt;
    }

    public Optional<Throttler> throttlerOpt() {
        if (this instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload throttledSegmentUpload = (ThrottledSegmentUpload)this;
            return throttledSegmentUpload.throttlerOpt();
        }
        return Optional.empty();
    }

    public SegmentMetadataLayoutPutMode putMode() {
        return this.putMode;
    }

    public LinkedHashMap<FragmentType, Object> orderedFragmentsForCombinedObject() {
        return this.orderedFragmentsForCombinedObject;
    }

    public static List<FragmentType> canonicalOrderForCombinedObject() {
        return CANONICAL_ORDER_FOR_COMBINED_OBJECT;
    }

    public CombinedObjectStream makeCombinedObjectStream() {
        return this.makeCombinedObjectStream(0);
    }

    public CombinedObjectStream makeCombinedObjectStream(int defaultBufferSize) {
        long start = this.time.milliseconds();
        ArrayList<InputStream> inOrderFragmentStreams = new ArrayList<InputStream>();
        long totalLength = 0L;
        for (Object fragment : this.orderedFragmentsForCombinedObject.values()) {
            if (fragment == null) {
                log.warn("Skipping null fragment in orderedFragmentsForCombinedObject");
                continue;
            }
            if (fragment instanceof File) {
                File file = (File)fragment;
                try {
                    FileInputStream fis = this.throttlerOpt().isPresent() ? new ThrottledFileInputStream(file, this.throttlerOpt().get()) : new FileInputStream(file);
                    inOrderFragmentStreams.add(fis);
                    totalLength += file.length();
                    continue;
                }
                catch (IOException e) {
                    throw new TierObjectStoreFatalException("Could not open/read file " + file.getAbsolutePath() + " during segment upload", e);
                }
            }
            if (!(fragment instanceof ByteBuffer)) continue;
            ByteBuffer buf = (ByteBuffer)fragment;
            totalLength += (long)(buf.limit() - buf.position());
            inOrderFragmentStreams.add((InputStream)new ByteBufferInputStream(buf.duplicate()));
        }
        CombinedObjectStream stream = defaultBufferSize <= 0 ? new CombinedObjectStream(inOrderFragmentStreams, totalLength) : new CombinedObjectStream(inOrderFragmentStreams, totalLength, defaultBufferSize);
        long elapsed = this.time.milliseconds() - start;
        if (this.objectMetadata != null) {
            log.info("[{}, baseOffset={}] constructed CombinedObjectStream in {}ms of total length {} bytes", new Object[]{this.objectMetadata.topicIdPartition(), this.objectMetadata.baseOffset(), elapsed, totalLength});
        }
        return stream;
    }

    public String getChecksumForCombinedObject() {
        long start = this.time.milliseconds();
        Checksum crc = Crc32C.create();
        for (Object fragment : this.orderedFragmentsForCombinedObject.values()) {
            if (fragment instanceof File) {
                E2EChecksumUtils.compute32BitBase64Crc32c((File)((File)fragment), (Checksum)crc);
                continue;
            }
            if (!(fragment instanceof ByteBuffer)) continue;
            Checksums.update((Checksum)crc, (ByteBuffer)((ByteBuffer)fragment), (int)((ByteBuffer)fragment).remaining());
        }
        String checksum = E2EChecksumUtils.convertTo32BitBase64((long)crc.getValue());
        long elapsed = this.time.milliseconds() - start;
        if (this.objectMetadata != null) {
            log.info("[{}, baseOffset={}] computed checksum for CombinedObject in {}ms: {}", new Object[]{this.objectMetadata.topicIdPartition(), this.objectMetadata.baseOffset(), elapsed, checksum});
        }
        return checksum;
    }

    public void postPutSegmentCleanup(E2EChecksumStore checksumStore) {
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT)) {
            checksumStore.store().remove(this.segment.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.OFFSET_INDEX)) {
            checksumStore.store().remove(this.offsetIdx.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX)) {
            checksumStore.store().remove(this.timestampIdx.getAbsolutePath());
        }
        if (checksumStore.checksumProtectionEnabled(E2EChecksumProtectedObjectType.PRODUCER_STATE) && this.producerStateSnapshotOpt.isPresent() && this instanceof ThrottledSegmentUpload) {
            ThrottledSegmentUpload throttledSegmentUpload = (ThrottledSegmentUpload)this;
            throttledSegmentUpload.producerStateSnapshotOpt().ifPresent(file -> checksumStore.store().remove(file.getAbsolutePath()));
        }
    }

    static {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        fragmentTypes.add(FragmentType.SEGMENT);
        fragmentTypes.add(FragmentType.OFFSET_INDEX);
        fragmentTypes.add(FragmentType.TIMESTAMP_INDEX);
        fragmentTypes.add(FragmentType.PRODUCER_STATE);
        fragmentTypes.add(FragmentType.TRANSACTION_INDEX);
        fragmentTypes.add(FragmentType.EPOCH_STATE);
        CANONICAL_ORDER_FOR_COMBINED_OBJECT = Collections.unmodifiableList(fragmentTypes);
    }
}

