/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.common.NoSuchLogSegmentException;
import kafka.log.AbstractLog;
import kafka.log.UploadableSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFatalException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.ThrottledSegmentUpload;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class ArchiveTask$
implements Logging {
    public static final ArchiveTask$ MODULE$ = new ArchiveTask$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    public ArchiveTask apply(CancellationContext ctx, TopicIdPartition topicIdPartition, int leaderEpoch, ArchiverMetrics archiverMetrics, int brokerId) {
        return new ArchiveTask(ctx, topicIdPartition, new BeforeLeader(leaderEpoch), archiverMetrics, brokerId);
    }

    public Future<ArchiveTaskState> checkFailedState(FailedState state, TopicIdPartition topicIdPartition, ReplicaManager replicaManager) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> (Product)replicaManager.getLog(topicIdPartition.topicPartition()).map((Function1 & Serializable)log -> {
            int tierEpoch = log.tierPartitionState().tierEpoch();
            int leaderEpoch = state.leaderEpoch();
            if (log.tierPartitionState().status().hasError()) {
                throw new TierArchiverFailedException(topicIdPartition);
            }
            if (tierEpoch > leaderEpoch) {
                throw new TierArchiverFencedException(topicIdPartition, null);
            }
            if (tierEpoch == leaderEpoch) {
                return new BeforeUpload(leaderEpoch);
            }
            if (tierEpoch < leaderEpoch) {
                return new BeforeLeader(leaderEpoch);
            }
            throw new TierArchiverFatalException(new StringBuilder(81).append("attempted to transition from a FailedState for ").append(topicIdPartition).append(" while in non-transitionable state").toString(), null);
        }).getOrElse((Function0 & Serializable)() -> state)));
    }

    public Future<BeforeUpload> establishLeadership(BeforeLeader state, TopicIdPartition topicIdPartition, TierTopicAppender tierTopicAppender, int brokerId, ReplicaManager replicaManager, ExecutionContext ec) {
        return Future$.MODULE$.unit().flatMap((Function1 & Serializable)x$3 -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Errors error = (Errors)((Left)either).value();
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (either instanceof Right) {
                Partition partition = (Partition)((Right)either).value();
                return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(new TierTopicInitLeader(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), brokerId, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(partition.metadataOffsetAndEpoch())))))).map((Function1 & Serializable)x0$1 -> {
                    if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                        ArchiveTask$ info_this = MODULE$;
                        if (info_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = ArchiveTask$.$anonfun$establishLeadership$3(topicIdPartition);
                            Object var4_4 = null;
                            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                        }
                        Object var3_3 = null;
                        return new BeforeUpload(state.leaderEpoch());
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                        throw new TierArchiverFailedException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                        throw new TierArchiverFencedException(topicIdPartition, null);
                    }
                    if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                        throw new TierArchiverRestoreFencedException(topicIdPartition);
                    }
                    throw new TierArchiverFatalException(new StringBuilder(21).append("Unknown AppendResult ").append(x0$1).toString(), null);
                }, ec);
            }
            throw new MatchError(either);
        }, ec);
    }

    public Future<ArchiveTaskState> maybeInitiateUpload(BeforeUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Errors error = (Errors)((Left)either).value();
                throw new TierArchiverFencedException(topicIdPartition, (Throwable)error.exception());
            }
            if (either instanceof Right) {
                Tuple3 tuple3;
                Partition partition = (Partition)((Right)either).value();
                if (partition.isUncleanLeader()) {
                    throw new TierMetadataRetriableException(new StringBuilder(53).append("Backing off as ").append(topicIdPartition).append(" is undergoing unclean leader recovery").toString());
                }
                Option option = partition.log().flatMap((Function1 & Serializable)log -> {
                    if (!log.tierPartitionState().isTieringEnabled()) {
                        throw new NotTierablePartitionException(topicIdPartition);
                    }
                    if (log.tierPartitionState().tierEpoch() != state.leaderEpoch()) {
                        throw new TierArchiverFencedException(topicIdPartition, null);
                    }
                    OffsetAndEpoch stateOffset = log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
                    return ((IterableOnceOps)log.tierableLogSegments().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ArchiveTask$.$anonfun$maybeInitiateUpload$3(x$4)))).collectFirst((PartialFunction)new Serializable((AbstractLog)log, stateOffset){
                        private static final long serialVersionUID = 0L;
                        private final AbstractLog log$1;
                        private final OffsetAndEpoch stateOffset$1;

                        public final <A1 extends LogSegment, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            if (x1 != null) {
                                return (B1)new Tuple3((Object)this.log$1, (Object)this.stateOffset$1, x1);
                            }
                            return (B1)function1.apply(null);
                        }

                        public final boolean isDefinedAt(LogSegment x1) {
                            return x1 != null;
                        }
                        {
                            this.log$1 = log$1;
                            this.stateOffset$1 = stateOffset$1;
                        }
                    });
                });
                if (None$.MODULE$.equals(option)) {
                    ArchiveTask$ debug_this = MODULE$;
                    if (debug_this.logger().underlying().isDebugEnabled()) {
                        String msgWithLogIdent_msg = ArchiveTask$.$anonfun$maybeInitiateUpload$4(topicIdPartition);
                        Object var25_13 = null;
                        debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
                    }
                    Object var24_12 = null;
                    return Future$.MODULE$.apply((Function0 & Serializable)() -> state, ec);
                }
                if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
                    AbstractLog log2 = (AbstractLog)tuple3._1();
                    OffsetAndEpoch stateOffset = (OffsetAndEpoch)tuple3._2();
                    LogSegment logSegment = (LogSegment)tuple3._3();
                    if (log2 != null && stateOffset != null && logSegment != null) {
                        List<FragmentDescriptionWrapper> list;
                        ObjectRef segment = ObjectRef.create(null);
                        try {
                            segment.elem = MODULE$.uploadableSegment(log2, logSegment, topicIdPartition);
                        }
                        catch (CorruptIndexException e) {
                            throw new E2EChecksumInvalidException("Index associated with the segment is corrupted", (Throwable)e);
                        }
                        if (log2.isDeleted() || log2.isStray()) {
                            throw new NotTierablePartitionException(topicIdPartition);
                        }
                        OpaqueData opaqueData = (OpaqueData)Option$.MODULE$.apply((Object)tierObjectStore.prepPutSegment()).getOrElse((Function0 & Serializable)() -> OpaqueData.ZEROED);
                        try {
                            list = FragmentDescriptionWrapper.createFragmentDescriptionsList(topicIdPartition, config.segmentMetadataLayoutPutMode(), logSegment.size(), ((UploadableSegment)segment.elem).offsetIndex().length(), ((UploadableSegment)segment.elem).timeIndex().length(), BoxesRunTime.unboxToInt((Object)((UploadableSegment)segment.elem).abortedTxnIndexOpt().map((Function1 & Serializable)bb -> BoxesRunTime.boxToInteger((int)ArchiveTask$.$anonfun$maybeInitiateUpload$7(bb))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), BoxesRunTime.unboxToInt((Object)((UploadableSegment)segment.elem).leaderEpochStateOpt().map((Function1 & Serializable)bb -> BoxesRunTime.boxToInteger((int)ArchiveTask$.$anonfun$maybeInitiateUpload$9(bb))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), BoxesRunTime.unboxToLong((Object)((UploadableSegment)segment.elem).producerStateOpt().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.length())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
                        }
                        catch (IllegalArgumentException e) {
                            throw new TierArchiverFatalException(new StringBuilder(88).append("TierArchiver failed while ").append("attempting to describe the metadata layout of a segment from ").append(topicIdPartition).append(".").toString(), (Throwable)e);
                        }
                        List<FragmentDescriptionWrapper> fragmentDescriptionsList = list;
                        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, state.leaderEpoch(), UUID.randomUUID(), Optional.empty(), logSegment.baseOffset(), ((UploadableSegment)segment.elem).nextOffset() - 1L, logSegment.largestTimestamp(), logSegment.getFirstBatchTimestamp(), logSegment.size(), ((UploadableSegment)segment.elem).leaderEpochStateOpt().isDefined(), ((UploadableSegment)segment.elem).abortedTxnIndexOpt().isDefined(), ((UploadableSegment)segment.elem).producerStateOpt().isDefined(), TierUploadType.Archive, stateOffset, opaqueData, Optional.of(fragmentDescriptionsList));
                        long startTimeMs = time.milliseconds();
                        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadInitiate))))).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable)x0$1 -> {
                            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                                ArchiveTask$ info_this = MODULE$;
                                if (info_this.logger().underlying().isInfoEnabled()) {
                                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$maybeInitiateUpload$16(uploadInitiate, topicIdPartition, time, startTimeMs);
                                    Object var9_8 = null;
                                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                                }
                                Object var8_7 = null;
                                return new Upload(state.leaderEpoch(), uploadInitiate, (UploadableSegment)segment$1.elem);
                            }
                            if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                                throw new TierArchiverFailedException(topicIdPartition);
                            }
                            if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                                throw new NotTierablePartitionException(topicIdPartition);
                            }
                            if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                                throw new TierArchiverFencedException(topicIdPartition, null);
                            }
                            if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                                throw new TierArchiverRestoreFencedException(topicIdPartition);
                            }
                            throw new MatchError((Object)x0$1);
                        }, ec);
                    }
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError(either);
        }, ec).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec);
    }

    public Future<AfterUpload> upload(Upload state, TopicIdPartition topicIdPartition, Time time, CancellationContext ctx, TierObjectStore tierObjectStore, Option<Throttler> throttlerOpt, TierTasksConfig config, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            UploadableSegment uploadableSegment = state.uploadableSegment();
            TierSegmentUploadInitiate uploadInitiate = state.uploadInitiate();
            ObjectMetadata metadata = new ObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadableSegment.abortedTxnIndexOpt().isDefined(), uploadableSegment.producerStateOpt().isDefined(), uploadableSegment.leaderEpochStateOpt().isDefined(), uploadInitiate.opaqueData(), uploadInitiate.segmentAndMetadataLayout().orElse(null));
            return (AfterUpload)package$.MODULE$.blocking((Function0 & Serializable)() -> {
                if (ctx.isCancelled()) {
                    throw new TierArchiverFencedException(topicIdPartition, null);
                }
                long startTimeMs = time.milliseconds();
                try {
                    ThrottledSegmentUpload segmentUpload = new ThrottledSegmentUpload(config.segmentMetadataLayoutPutMode(), metadata, uploadableSegment.logSegmentFile(), uploadableSegment.offsetIndex(), uploadableSegment.timeIndex(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.producerStateOpt())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.abortedTxnIndexOpt().map((Function1 & Serializable)x$6 -> x$6.duplicate()))), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(uploadableSegment.leaderEpochStateOpt().map((Function1 & Serializable)x$7 -> x$7.duplicate()))), (Optional<Throttler>)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(throttlerOpt)));
                    tierObjectStore.putSegment(segmentUpload);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        if (!MODULE$.segmentFilesExist(state.uploadableSegment())) {
                            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(uploadableSegment.logSegmentFile().getAbsolutePath()).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), exception);
                        }
                    }
                    throw throwable;
                }
                ArchiveTask$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$upload$5(topicIdPartition, time, startTimeMs);
                    Object var16_15 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var15_14 = null;
                return new AfterUpload(state.leaderEpoch(), uploadInitiate, state.uploadableSegment().uploadedSize());
            });
        }, ec);
    }

    public Option<Throttler> upload$default$6() {
        return None$.MODULE$;
    }

    public Future<BeforeUpload> finalizeUpload(AfterUpload state, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender, Option<Meter> byteRateMetric, ExecutionContext ec) {
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(state.uploadInitiate());
        long startTimeMs = time.milliseconds();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(uploadComplete))))).flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), ec).map((Function1 & Serializable)x0$1 -> {
            if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals(x0$1)) {
                ArchiveTask$ info_this = MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = ArchiveTask$.$anonfun$finalizeUpload$4(uploadComplete, topicIdPartition, time, startTimeMs);
                    Object var9_8 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                Object var8_7 = null;
                byteRateMetric.foreach((Function1 & Serializable)x$8 -> {
                    x$8.mark(state.uploadedSize());
                    return BoxedUnit.UNIT;
                });
                return new BeforeUpload(state.leaderEpoch());
            }
            if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals(x0$1)) {
                throw new TierArchiverFailedException(topicIdPartition);
            }
            if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals(x0$1)) {
                throw new NotTierablePartitionException(topicIdPartition);
            }
            if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals(x0$1)) {
                throw new TierArchiverFencedException(topicIdPartition, null);
            }
            if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals(x0$1)) {
                throw new TierArchiverRestoreFencedException(topicIdPartition);
            }
            throw new MatchError((Object)x0$1);
        }, ec);
    }

    public UploadableSegment uploadableSegment(AbstractLog log, LogSegment logSegment, TopicIdPartition topicIdPartition) {
        try {
            return log.createUploadableSegment(logSegment);
        }
        catch (NoSuchLogSegmentException e) {
            throw new ArchiveTask.SegmentDeletedException(new StringBuilder(33).append("Segment ").append(logSegment).append(" of ").append(topicIdPartition).append(" deleted when tiering").toString(), e);
        }
    }

    private boolean segmentFilesExist(UploadableSegment uploadableSegment) {
        return uploadableSegment.allFiles().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.exists()));
    }

    public static final /* synthetic */ String $anonfun$establishLeadership$3(TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(27).append("established leadership for ").append(topicIdPartition$2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$maybeInitiateUpload$3(LogSegment x$4) {
        return x$4.size() != 0;
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$4(TopicIdPartition topicIdPartition$3) {
        return new StringBuilder(78).append("Retrying BeforeUpload for ").append(topicIdPartition$3).append(" as log has moved or no tierable segments were found").toString();
    }

    public static final /* synthetic */ int $anonfun$maybeInitiateUpload$7(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ int $anonfun$maybeInitiateUpload$9(ByteBuffer bb) {
        return bb.limit() - bb.position();
    }

    public static final /* synthetic */ String $anonfun$maybeInitiateUpload$16(TierSegmentUploadInitiate uploadInitiate$1, TopicIdPartition topicIdPartition$3, Time time$2, long startTimeMs$1) {
        return new StringBuilder(21).append("Completed ").append(uploadInitiate$1).append(" for ").append(topicIdPartition$3).append(" in ").append(time$2.milliseconds() - startTimeMs$1).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$upload$5(TopicIdPartition topicIdPartition$4, Time time$3, long startTimeMs$2) {
        return new StringBuilder(27).append("Uploaded segment for ").append(topicIdPartition$4).append(" in ").append(time$3.milliseconds() - startTimeMs$2).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$finalizeUpload$4(TierSegmentUploadComplete uploadComplete$1, TopicIdPartition topicIdPartition$5, Time time$4, long startTimeMs$3) {
        return new StringBuilder(22).append("Finalized ").append(uploadComplete$1).append(" for ").append(topicIdPartition$5).append(" in ").append(time$4.milliseconds() - startTimeMs$3).append(" ms").toString();
    }

    private ArchiveTask$() {
    }
}

