/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.Header;
import kafka.tier.state.PathAndHeader;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.tools.PartitionUploadInfo;
import kafka.tier.tools.SelectFileTierPartitionStatePolicy;
import kafka.tier.tools.SelectFileTierPartitionStatePolicyUtils;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.tier.topic.recovery.SelectRemoteFileTierPartitionStateOutput;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRemoteFurthestFileTierPartitionStatePolicy
implements SelectFileTierPartitionStatePolicy {
    private static final Logger log = LoggerFactory.getLogger(SelectRemoteFurthestFileTierPartitionStatePolicy.class);
    private final String remoteRecoveryDir;
    private final String tierConfigFile;
    private final String adminConfigFile;
    private final String bootstrapServers;
    private final boolean skipReplicationFactorCheck;
    private final int replicationFactorOverride;
    private final String outputDir;

    public SelectRemoteFurthestFileTierPartitionStatePolicy(String remoteRecoveryDir, String tierConfigFile, String adminConfigFile, String bootstrapServers, boolean skipReplicationFactorCheck, int replicationFactorOverride, String outputDir) {
        this.remoteRecoveryDir = remoteRecoveryDir;
        this.tierConfigFile = tierConfigFile;
        this.adminConfigFile = adminConfigFile;
        this.bootstrapServers = bootstrapServers;
        this.skipReplicationFactorCheck = skipReplicationFactorCheck;
        this.replicationFactorOverride = replicationFactorOverride;
        this.outputDir = outputDir;
    }

    public static PathAndHeader getFurthestFTPSForTopicPartition(TierObjectStore objectStore, List<PartitionUploadInfo> ftpsList, TopicIdPartition topicPartition) throws IOException, InterruptedException {
        ArrayList<PathAndHeader> furthestFTPSs = new ArrayList<PathAndHeader>(Collections.emptyList());
        ArrayList<String> leaders = new ArrayList<String>();
        for (PartitionUploadInfo ftps : ftpsList) {
            if (ftps.isLeader) {
                leaders.add(ftps.objectStorePath);
            }
            FileTierPartitionStateRecoveryUploadMetadata ftpsRecoveryUploadMetadata = FileTierPartitionStateRecoveryUploadMetadata.fromPath(ftps.objectStorePath);
            TierObjectStoreResponse response = TierObjectStoreFunctionUtils.getObjectStoreFragment(() -> false, objectStore, ftpsRecoveryUploadMetadata, FragmentType.FILE_TIER_PARTITION_STATE_UPLOAD);
            InputStream stream = response.getInputStream();
            Throwable throwable = null;
            try {
                Optional<Header> header = ChecksumUtils.readRemoteHeader(ftpsRecoveryUploadMetadata.uploadObject().checksumAlgorithm(), stream);
                if (!header.isPresent()) {
                    throw new KafkaStorageException("Unexpectedly encountered FTPS with no header. Please validate the uploaded FTPSs for topicIdPartition=" + topicPartition);
                }
                furthestFTPSs.add(new PathAndHeader(ftps.objectStorePath, header));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        if (leaders.size() > 1) {
            log.warn("Found more than 1 leader for topicPartition {}. List of leader FTPSs object store paths {}", (Object)topicPartition, (Object)String.join((CharSequence)", ", leaders));
        }
        return SelectRemoteFurthestFileTierPartitionStatePolicy.furthestTierStateHeader(furthestFTPSs, topicPartition);
    }

    public static PathAndHeader furthestTierStateHeader(List<PathAndHeader> metadataPerReplica, TopicIdPartition topicIdPartition) {
        PathAndHeader furthestMaterializedPathAndHeaderSoFar = null;
        for (PathAndHeader entry : metadataPerReplica) {
            if (furthestMaterializedPathAndHeaderSoFar == null) {
                furthestMaterializedPathAndHeaderSoFar = entry;
                continue;
            }
            if (!SelectRemoteFurthestFileTierPartitionStatePolicy.tierStateHeaderIsFurther(furthestMaterializedPathAndHeaderSoFar, entry, topicIdPartition)) continue;
            furthestMaterializedPathAndHeaderSoFar = entry;
        }
        return furthestMaterializedPathAndHeaderSoFar;
    }

    public static boolean tierStateHeaderIsFurther(PathAndHeader firstPathAndHeader, PathAndHeader secondPathAndHeader, TopicIdPartition topicIdPartition) {
        Header firstHeader = firstPathAndHeader.header().get();
        Header secondHeader = secondPathAndHeader.header().get();
        String firstPath = firstPathAndHeader.path();
        String secondPath = secondPathAndHeader.path();
        SelectRemoteFurthestFileTierPartitionStatePolicy.warnWhenFtpsHasLowerLocalMaterializedOffsetAndHigherEndOffset(firstHeader, secondHeader, firstPath, secondPath, topicIdPartition);
        SelectRemoteFurthestFileTierPartitionStatePolicy.warnWhenFtpsHasLowerLocalMaterializedOffsetAndHigherEndOffset(secondHeader, firstHeader, secondPath, firstPath, topicIdPartition);
        log.debug("Comparing FTPSs for topicPartition={}... \nFTPS 1: (header={}, path={}). \nFTPS 2: (header={}, path={}).", new Object[]{topicIdPartition, firstHeader, firstPath, secondHeader, secondPath});
        if (firstHeader.endOffset() == secondHeader.endOffset()) {
            return ChecksumUtils.compareOffsetAndEpoch(firstHeader.localMaterializedOffsetAndEpoch(), secondHeader.localMaterializedOffsetAndEpoch(), topicIdPartition.topicId());
        }
        return secondHeader.endOffset() > firstHeader.endOffset();
    }

    private static void warnWhenFtpsHasLowerLocalMaterializedOffsetAndHigherEndOffset(Header firstHeader, Header secondHeader, String firstPath, String secondPath, TopicIdPartition topicIdPartition) {
        if (firstHeader.localMaterializedOffsetAndEpoch().offset() <= secondHeader.localMaterializedOffsetAndEpoch().offset() && firstHeader.endOffset() > secondHeader.endOffset()) {
            log.warn("Found unexpected FTPS with a lower or equal localMaterializedOffsetAndEpoch and higher endOffset for topicIdPartition= " + topicIdPartition + ".\n\tFTPS 1: (topicId={}, path={}, endOffset={}, localMaterializedOffsetAndEpoch={}, header={}). FTPS 2: (topicId={}, path={}, endOffset={}, localMaterializedOffsetAndEpoch={}, header={}).", new Object[]{firstHeader.topicId(), firstPath, firstHeader.endOffset(), firstHeader.localMaterializedOffsetAndEpoch(), firstHeader, secondHeader.topicId(), secondPath, secondHeader.endOffset(), secondHeader.localMaterializedOffsetAndEpoch(), secondHeader});
        }
    }

    @Override
    public void run(Set<TopicIdPartition> topicPartitions) throws Exception {
        TierObjectStore objectStore;
        File dir = new File(this.outputDir);
        if (dir.mkdirs()) {
            log.info("Created output directory: {}", (Object)this.outputDir);
        }
        if (!dir.exists()) {
            throw new IOException("Failed to create output directory: " + this.outputDir);
        }
        if (topicPartitions.isEmpty()) {
            throw new IllegalArgumentException("No affected topic partitions found. Exiting... Please check the input and try again");
        }
        log.info("Running SelectRemoteFurthestFileTierPartitionStatePolicy tool on the topicPartitions: {}", topicPartitions);
        try {
            objectStore = TierObjectStoreUtils.objectStore(this.tierConfigFile);
        }
        catch (IOException e) {
            log.error("Failed to create object store instance with config: {}", (Object)this.tierConfigFile);
            throw new UncheckedIOException(e);
        }
        HashMap<TopicIdPartition, String> furthestFTPSs = new HashMap<TopicIdPartition, String>();
        String identifier = TierMetadataRecoveryUtils.getIdentifierFromRecoveryDir(this.remoteRecoveryDir);
        Map<TopicIdPartition, List<PartitionUploadInfo>> metadataList = SelectFileTierPartitionStatePolicyUtils.getRecoveryMetadata(objectStore, identifier, this.adminConfigFile, this.bootstrapServers);
        int numPartitions = topicPartitions.size();
        ArrayList<TopicIdPartition> failedPartitions = new ArrayList<TopicIdPartition>();
        for (TopicIdPartition topicPartition : topicPartitions) {
            try {
                List<PartitionUploadInfo> ftpsList = metadataList.getOrDefault(topicPartition, Collections.emptyList());
                SelectFileTierPartitionStatePolicyUtils.validateNumOfFTPSObjects(this.skipReplicationFactorCheck, this.replicationFactorOverride, ftpsList);
                PathAndHeader furthestFTPS = SelectRemoteFurthestFileTierPartitionStatePolicy.getFurthestFTPSForTopicPartition(objectStore, ftpsList, topicPartition);
                furthestFTPSs.put(topicPartition, furthestFTPS.path());
            }
            catch (Exception e) {
                failedPartitions.add(topicPartition);
                log.error("Failed to get the furthest FTPS for topicPartition {}", (Object)topicPartition, (Object)e);
            }
        }
        SelectRemoteFileTierPartitionStateOutput output = new SelectRemoteFileTierPartitionStateOutput(1, furthestFTPSs);
        SelectFileTierPartitionStatePolicyUtils.writeSelectRemoteFTPSOutputToFile(output, numPartitions, failedPartitions, this.outputDir);
    }
}

