/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.SocketServerConfigs;
import org.apache.kafka.server.util.Csv;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());
    private static final InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    private Logger logger() {
        return logger;
    }

    private InetAddressValidator inetAddressValidator() {
        return inetAddressValidator;
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                logging.error((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.WARN.equals(logLevel)) {
                logging.warn((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.INFO.equals(logLevel)) {
                logging.info((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.DEBUG.equals(logLevel)) {
                logging.debug((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.TRACE.equals(logLevel)) {
                logging.trace((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            throw new MatchError((Object)logLevel);
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef exception = ObjectRef.create(null);
        all.foreach((Function1 & Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public <T> T createObject(String className, scala.collection.immutable.Seq<Object> args) {
        return Utils.loadClass((String)className, Object.class).getConstructor((Class[])((IterableOnceOps)args.map((Function1 & Serializable)x$1 -> x$1.getClass())).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        boolean locked = true;
        try {
            Object object;
            lock.lock();
            try {
                object = fun.apply();
            }
            finally {
                lock.unlock();
                locked = false;
            }
            return (T)object;
        }
        catch (Exception e) {
            if (locked && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(55).append("Potential lock issue: exception before unlocking lock ").append(lock).append(":").toString(), (Throwable)e);
            }
            throw e;
        }
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        Lock inLock_lock = lock.readLock();
        boolean inLock_locked = true;
        try {
            Object object;
            inLock_lock.lock();
            try {
                object = fun.apply();
            }
            finally {
                inLock_lock.unlock();
                inLock_locked = false;
            }
            return (T)object;
        }
        catch (Exception inLock_e) {
            if (inLock_locked && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(55).append("Potential lock issue: exception before unlocking lock ").append(inLock_lock).append(":").toString(), (Throwable)inLock_e);
            }
            throw inLock_e;
        }
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        boolean wasAlreadyHoldingWriteLock = CoreUtils$.isWriteLockedByCurrentThread$1(lock);
        try {
            Lock inLock_lock = lock.writeLock();
            boolean inLock_locked = true;
            try {
                inLock_lock.lock();
                try {
                    object = fun.apply();
                }
                finally {
                    inLock_lock.unlock();
                    inLock_locked = false;
                }
            }
            catch (Exception inLock_e) {
                if (inLock_locked && this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(55).append("Potential lock issue: exception before unlocking lock ").append(inLock_lock).append(":").toString(), (Throwable)inLock_e);
                }
                throw inLock_e;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            if (wasAlreadyHoldingWriteLock != CoreUtils$.isWriteLockedByCurrentThread$1(lock) && this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(81).append("Potential lock issue: write lock / unlock").append(" didn't restore lock ").append(lock.writeLock()).append(" into holding=").append(wasAlreadyHoldingWriteLock).append("\n\tat ").append(Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n\tat ")).toString());
            }
            throw throwable;
        }
        if (wasAlreadyHoldingWriteLock != CoreUtils$.isWriteLockedByCurrentThread$1(lock) && this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(new StringBuilder(81).append("Potential lock issue: write lock / unlock").append(" didn't restore lock ").append(lock.writeLock()).append(" into holding=").append(wasAlreadyHoldingWriteLock).append("\n\tat ").append(Predef$.MODULE$.wrapRefArray((Object[])Thread.currentThread().getStackTrace()).mkString("\n\tat ")).toString());
            return (T)object;
        }
        return (T)object;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapOps)s.groupBy((Function1 & Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object k = x0$1._1();
                Iterable l = (Iterable)x0$1._2();
                return new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
            }
            throw new MatchError(null);
        }).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return this.listenerListToEndPoints(listeners, securityProtocolMap, true);
    }

    public Map<String, String> clusterLinkLocalReverseConnectionListenerMap(String listenerToListenerConfigVal, Seq<ListenerName> listeners) {
        Set listenersSet = ((IterableOnceOps)listeners.map((Function1 & Serializable)x$2 -> x$2.value())).toSet();
        if (listenerToListenerConfigVal != null) {
            scala.collection.immutable.Map listenerToListener = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(Csv.parseCsvList((String)listenerToListenerConfigVal)).asScala().map((Function1 & Serializable)listenerToListenerStr -> {
                String key = listenerToListenerStr.substring(0, listenerToListenerStr.lastIndexOf(":")).trim();
                String value = listenerToListenerStr.substring(listenerToListenerStr.lastIndexOf(":") + 1).trim();
                if (listenersSet.contains((Object)key) && !listenersSet.contains((Object)value)) {
                    throw new IllegalArgumentException(new StringBuilder(61).append("Listener ").append(value).append(" does not exist in the brokers configured ").append("listeners ").append(listenersSet).toString());
                }
                return new Tuple2((Object)key, (Object)value);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            listenersSet.foreach((Function1 & Serializable)l -> {
                CoreUtils$.$anonfun$clusterLinkLocalReverseConnectionListenerMap$3(listenerToListener, listenerToListenerConfigVal, l);
                return BoxedUnit.UNIT;
            });
            return listenerToListener;
        }
        return ((IterableOnceOps)listeners.map((Function1 & Serializable)l -> new Tuple2((Object)l.value(), (Object)l.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void checkDuplicateListenerPorts(Seq<EndPoint> endpoints, String listeners) {
        Seq distinctPorts = (Seq)((SeqOps)endpoints.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.port()))).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == ((SeqOps)endpoints.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.port()))).size(), (Function0 & Serializable)() -> new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners).toString());
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap, boolean requireDistinctPorts) {
        Buffer buffer;
        try {
            buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(SocketServerConfigs.listenerListToEndPoints((String)listeners, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(securityProtocolMap).asJava())).asScala().map((Function1 & Serializable)x$7 -> EndPoint$.MODULE$.fromJava((Endpoint)x$7));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        Buffer endPoints = buffer;
        this.validate$1((Seq)endPoints, listeners, requireDistinctPorts);
        return endPoints;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return this.uuidToBase64(uuid);
    }

    public String uuidToBase64(UUID uuid) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public UUID uuidFromBase64(String str) {
        ByteBuffer bb = ByteBuffer.wrap(Base64.getUrlDecoder().decode(str));
        return new UUID(bb.getLong(), bb.getLong());
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Uuid toKafkaUUID(UUID uuid) {
        return new Uuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public UUID toJavaUUID(Uuid uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public Uuid toKafkaUuidFromJavaUUIDString(String id) {
        return this.toKafkaUUID(UUID.fromString(id));
    }

    public String toJavaUUIDStringFromKafkaUuidString(String id) {
        return this.toJavaUUID(Uuid.fromString((String)id)).toString();
    }

    public byte[] md5hash(ByteBuffer buf) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf.duplicate());
        return md5.digest();
    }

    public String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    public Properties propsWith(scala.collection.immutable.Seq<Tuple2<String, String>> props) {
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return properties.put(k, v);
            }
            throw new MatchError(null);
        });
        return properties;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Option option = map.get(key);
        if (option instanceof Some) {
            return (V)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            Object value = createValue.apply();
            return (V)map.putIfAbsent(key, value).getOrElse((Function0 & Serializable)() -> value);
        }
        throw new MatchError((Object)option);
    }

    public <T, K, B> Map<K, B> groupMapReduce(Iterable<T> elements, Function1<T, K> key, Function1<T, B> f, Function2<B, B, B> reduce) {
        return elements.groupMapReduce(key, f, reduce);
    }

    public Map<Object, Seq<Object>> replicaToBrokerAssignmentAsScala(java.util.Map<Integer, List<Integer>> map) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(map).asScala().map((Function1 & Serializable)e -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)e._1())), CollectionConverters$.MODULE$.ListHasAsScala((List)e._2()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)CoreUtils$.$anonfun$replicaToBrokerAssignmentAsScala$2(x$8)))));
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f), (boolean)false);
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        try {
            element.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if ((Throwable)exception$1.elem != null) {
                ((Throwable)exception$1.elem).addSuppressed(e);
                return;
            }
            exception$1.elem = e;
            return;
        }
    }

    private static final boolean isWriteLockedByCurrentThread$1(ReadWriteLock lock$1) {
        return lock$1 instanceof ReentrantReadWriteLock && ((ReentrantReadWriteLock)lock$1).isWriteLockedByCurrentThread();
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcI$sp() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$clusterLinkLocalReverseConnectionListenerMap$3(scala.collection.immutable.Map listenerToListener$1, String listenerToListenerConfigVal$1, String l) {
        if (!listenerToListener$1.contains((Object)l)) {
            throw new IllegalArgumentException(new StringBuilder(42).append(listenerToListenerConfigVal$1).append(" does not contain a mapping for listener ").append(l).append(".").toString());
        }
    }

    private final boolean validateOneIsIpv4AndOtherIpv6$1(String first, String second) {
        return this.inetAddressValidator().isValidInet4Address(first) && this.inetAddressValidator().isValidInet6Address(second) || this.inetAddressValidator().isValidInet6Address(first) && this.inetAddressValidator().isValidInet4Address(second);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$3(EndPoint ep) {
        return ep.port() != 0;
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Seq)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$7(EndPoint ep) {
        return ep.host() != null && MODULE$.inetAddressValidator().isValid(ep.host());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$listenerListToEndPoints$8(CoreUtils$ $this, boolean requireDistinctPorts$1, String listeners$2, Tuple2 x0$3) {
        if (x0$3 == null) throw new MatchError((Object)x0$3);
        int port = x0$3._1$mcI$sp();
        Tuple2 tuple2 = (Tuple2)x0$3._2();
        if (tuple2 == null) throw new MatchError((Object)x0$3);
        Seq duplicatesWithIpHosts = (Seq)tuple2._1();
        Seq duplicatesWithoutIpHosts = (Seq)tuple2._2();
        if (requireDistinctPorts$1) {
            MODULE$.checkDuplicateListenerPorts((Seq<EndPoint>)duplicatesWithoutIpHosts, listeners$2);
        }
        if (duplicatesWithIpHosts.isEmpty()) {
            return;
        }
        SeqOps seqOps = Seq$.MODULE$.unapplySeq((SeqOps)duplicatesWithIpHosts);
        if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) {
            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                EndPoint ep1 = (EndPoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                EndPoint ep2 = (EndPoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (!requireDistinctPorts$1) return;
                String errorMessage = new StringBuilder(108).append("If you have two listeners on ").append("the same port then one needs to be IPv4 and the other IPv6, listeners: ").append(listeners$2).append(", port: ").append(port).toString();
                Predef$.MODULE$.require($this.validateOneIsIpv4AndOtherIpv6$1(ep1.host(), ep2.host()), (Function0 & Serializable)() -> errorMessage);
                if (!duplicatesWithoutIpHosts.nonEmpty()) return;
                throw new IllegalArgumentException(errorMessage);
            }
        }
        if (!requireDistinctPorts$1) return;
        throw new IllegalArgumentException(new StringBuilder(136).append("Each listener must have a different port unless exactly one listener has ").append("an IPv4 address and the other IPv6 address, listeners: ").append(listeners$2).append(", port: ").append(port).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void validate$1(Seq endPoints, String listeners$2, boolean requireDistinctPorts$1) {
        void var6_6;
        Seq distinctListenerNames = (Seq)((SeqOps)endPoints.map((Function1 & Serializable)x$5 -> x$5.listenerName())).distinct();
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0 & Serializable)() -> new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$2).toString());
        Tuple2 tuple2 = ((IterableOps)endPoints.filter((Function1 & Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$3(ep)))).groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.port())).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$5(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Map duplicatePorts = (scala.collection.immutable.Map)tuple2._1();
        ((scala.collection.immutable.Map)var6_6.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int port = x0$2._1$mcI$sp();
                Seq eps = (Seq)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)port), (Object)eps.partition((Function1 & Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$7(ep))));
            }
            throw new MatchError(null);
        })).foreach((Function1 & Serializable)x0$3 -> {
            CoreUtils$.$anonfun$listenerListToEndPoints$8(this, requireDistinctPorts$1, listeners$2, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$replicaToBrokerAssignmentAsScala$2(Integer x$8) {
        return BoxesRunTime.unboxToInt((Object)x$8);
    }

    private CoreUtils$() {
    }
}

