/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerHealthZNode$ {
    public static final BrokerHealthZNode$ MODULE$ = new BrokerHealthZNode$();

    public String path() {
        return "/leadership_priority";
    }

    public byte[] encode(Map<Object, Set<DegradedBrokerComponent>> brokerHealthInfo) {
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokers"), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)brokerHealthInfo.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int brokerId = x0$1._1$mcI$sp();
                Set degradedBrokerComponents = (Set)x0$1._2();
                return CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reasons"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)degradedBrokerComponents.map((Function1 & Serializable)degradedBrokerComponent -> degradedBrokerComponent.reason())).toSeq()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"degradedBrokerHealthStates"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)degradedBrokerComponents.map((Function1 & Serializable)degradedBrokerComponent -> CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)degradedBrokerComponent.reason()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)BoxesRunTime.boxToByte((byte)degradedBrokerComponent.brokerComponent().id()))}))).asJava())).toSeq()).asJava())}))).asJava();
            }
            throw new MatchError(null);
        })).asJava())}))).asJava());
    }

    public Map<Object, Set<DegradedBrokerComponent>> decode(byte[] bytes) {
        if (bytes == null) {
            return (Map)Map$.MODULE$.empty();
        }
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(bytes);
        if (either instanceof Right) {
            JsonObject brokerHealthInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)brokerHealthInfo.apply("version").to(DecodeJson$DecodeInt$.MODULE$));
            if (version == 0) {
                return (Map)brokerHealthInfo.get("brokers").map((Function1 & Serializable)brokers -> brokers.asJsonArray().iterator().map((Function1 & Serializable)x$37 -> x$37.asJsonObject()).map((Function1 & Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(broker.apply("id").to(DecodeJson$DecodeInt$.MODULE$)), MODULE$.decodeReasons((JsonObject)broker))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> (Map)Map$.MODULE$.empty());
            }
            if (version >= 1) {
                return (Map)brokerHealthInfo.get("brokers").map((Function1 & Serializable)brokers -> brokers.asJsonArray().iterator().map((Function1 & Serializable)x$38 -> x$38.asJsonObject()).map((Function1 & Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(broker.apply("id").to(DecodeJson$DecodeInt$.MODULE$)), broker.apply("degradedBrokerHealthStates").asJsonArray() == null || broker.apply("degradedBrokerHealthStates").asJsonArray().iterator().isEmpty() ? MODULE$.decodeReasons((JsonObject)broker) : MODULE$.decodeDegradedBrokerHealthStates((JsonObject)broker))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> (Map)Map$.MODULE$.empty());
            }
            throw new IllegalArgumentException(new StringBuilder(25).append("Valid version not found: ").append(version).toString());
        }
        if (either instanceof Left) {
            JsonProcessingException e = (JsonProcessingException)((Object)((Left)either).value());
            throw new IllegalArgumentException(new StringBuilder(43).append("Failed to parse broker health information: ").append(new String(bytes, StandardCharsets.UTF_8)).toString(), e);
        }
        throw new MatchError(either);
    }

    private Set<DegradedBrokerComponent> decodeReasons(JsonObject broker) {
        return broker.apply("reasons").asJsonArray().iterator().map((Function1 & Serializable)reason -> new DegradedBrokerComponent(reason.to(DecodeJson$DecodeString$.MODULE$), BrokerComponent.UNSPECIFIED.id())).toSet();
    }

    private Set<DegradedBrokerComponent> decodeDegradedBrokerHealthStates(JsonObject broker) {
        return broker.apply("degradedBrokerHealthStates").asJsonArray().iterator().map((Function1 & Serializable)record -> new DegradedBrokerComponent(record.asJsonObject().apply("reason").to(DecodeJson$DecodeString$.MODULE$), (byte)BoxesRunTime.unboxToInt((Object)record.asJsonObject().apply("component").to(DecodeJson$DecodeInt$.MODULE$)))).toSet();
    }

    private BrokerHealthZNode$() {
    }
}

