/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FeatureZNode$
implements Serializable {
    public static final FeatureZNode$ MODULE$ = new FeatureZNode$();
    private static final String VersionKey = "version";
    private static final String StatusKey = "status";
    private static final String FeaturesKey = "features";
    private static final String V1MinVersionKey = "min_version_level";
    private static final String V1MaxVersionKey = "max_version_level";
    private static final int V1 = 1;
    private static final int V2 = 2;

    private String VersionKey() {
        return VersionKey;
    }

    private String StatusKey() {
        return StatusKey;
    }

    private String FeaturesKey() {
        return FeaturesKey;
    }

    private String V1MinVersionKey() {
        return V1MinVersionKey;
    }

    private String V1MaxVersionKey() {
        return V1MaxVersionKey;
    }

    public int V1() {
        return V1;
    }

    public int V2() {
        return V2;
    }

    public FeatureZNode apply(MetadataVersion metadataVersion, FeatureZNodeStatus status, Map<String, Object> features) {
        int version = metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV0) ? this.V2() : this.V1();
        return new FeatureZNode(version, status, features);
    }

    public String path() {
        return "/feature";
    }

    public java.util.Map<String, java.util.Map<String, Short>> asJavaMap(Map<String, Map<String, Object>> scalaMap) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)scalaMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)versionInfo.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String label = (String)x0$2._1();
                        short version = BoxesRunTime.unboxToShort((Object)x0$2._2());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)label), (Object)version);
                    }
                    throw new MatchError(null);
                })).asJava());
            }
            throw new MatchError(null);
        })).asJava();
    }

    public byte[] encode(FeatureZNode featureZNode) {
        java.util.Map<String, java.util.Map<String, Short>> features = featureZNode.version() == this.V1() ? this.asJavaMap((Map<String, Map<String, Object>>)((Map)featureZNode.features().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String feature = (String)x0$1._1();
                short version = BoxesRunTime.unboxToShort((Object)x0$1._2());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.V1MaxVersionKey()), (Object)BoxesRunTime.boxToShort((short)version)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.V1MinVersionKey()), (Object)BoxesRunTime.boxToShort((short)version))})));
            }
            throw new MatchError(null);
        }))) : this.asJavaMap((Map<String, Map<String, Object>>)((Map)featureZNode.features().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String feature = (String)x0$2._1();
                short version = BoxesRunTime.unboxToShort((Object)x0$2._2());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.V1MaxVersionKey()), (Object)BoxesRunTime.boxToShort((short)version))})));
            }
            throw new MatchError(null);
        })));
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)featureZNode.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.StatusKey()), (Object)BoxesRunTime.boxToInteger((int)featureZNode.status().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.FeaturesKey()), features)}));
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.MutableMapHasAsJava(jsonMap).asJava());
    }

    public FeatureZNode decode(byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            JsonObject featureInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)featureInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < this.V1() || version > this.V2()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Unsupported version: ").append(version).append(" of feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option statusInt = featureInfo.get(this.StatusKey()).flatMap((Function1 & Serializable)x$35 -> {
                DecodeJson$DecodeInt$ decodeOption_decodeJson = DecodeJson$DecodeInt$.MODULE$;
                Object var1_1 = null;
                return (Option)x$35.to(new DecodeJson<Option<E>>(decodeOption_decodeJson){
                    private final DecodeJson decodeJson$1;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, Option<E>> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeOption$1(node, this.decodeJson$1);
                    }
                    {
                        this.decodeJson$1 = decodeJson$1;
                    }
                });
            });
            if (statusInt.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Status can not be absent in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option<FeatureZNodeStatus> status = FeatureZNodeStatus$.MODULE$.withNameOpt(BoxesRunTime.unboxToInt((Object)statusInt.get()));
            if (status.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Malformed status: ").append(statusInt).append(" found in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Map<String, Object> finalizedFeatures = this.decodeFeature(version, featureInfo, jsonBytes);
            return new FeatureZNode(version, (FeatureZNodeStatus)status.get(), finalizedFeatures);
        }
        if (either instanceof Left) {
            JsonProcessingException e = (JsonProcessingException)((Object)((Left)either).value());
            throw new IllegalArgumentException(new StringBuilder(37).append("Failed to parse feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), e);
        }
        throw new MatchError(either);
    }

    private Map<String, Object> decodeFeature(int version, JsonObject featureInfo, byte[] jsonBytes) {
        Option featuresMap = featureInfo.get(this.FeaturesKey()).flatMap((Function1 & Serializable)x$36 -> {
            void decodeMap_factory;
            Factory decodeMap_factory2 = Map$.MODULE$.mapFactory();
            DecodeJson$DecodeInt$ decodeMap_decodeJson = DecodeJson$DecodeInt$.MODULE$;
            Object var1_2 = null;
            Object var2_1 = null;
            Factory factory = Map$.MODULE$.mapFactory();
            DecodeJson decodeMap_decodeJson2 = new DecodeJson<M>(decodeMap_decodeJson, decodeMap_factory2){
                private final DecodeJson decodeJson$3;
                private final Factory factory$2;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, M> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeMap$1(node, this.decodeJson$3, this.factory$2);
                }
                {
                    this.decodeJson$3 = decodeJson$3;
                    this.factory$2 = factory$2;
                }
            };
            Object var3_4 = null;
            factory = null;
            DecodeJson decodeOption_decodeJson = new /* invalid duplicate definition of identical inner class */;
            Object var5_5 = null;
            return (Option)x$36.to(new /* invalid duplicate definition of identical inner class */);
        });
        if (featuresMap.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Features map can not be absent in: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
        }
        return (Map)((MapOps)featuresMap.get()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                if (version == MODULE$.V1() && !versionInfo.contains((Object)MODULE$.V1MinVersionKey())) {
                    throw new IllegalArgumentException(new StringBuilder(13).append(MODULE$.V1MinVersionKey()).append(" absent in [").append(versionInfo).append("]").toString());
                }
                if (!versionInfo.contains((Object)MODULE$.V1MaxVersionKey())) {
                    throw new IllegalArgumentException(new StringBuilder(13).append(MODULE$.V1MaxVersionKey()).append(" absent in [").append(versionInfo).append("]").toString());
                }
                Option minValueOpt = versionInfo.get((Object)MODULE$.V1MinVersionKey());
                int maxValue = BoxesRunTime.unboxToInt((Object)versionInfo.apply((Object)MODULE$.V1MaxVersionKey()));
                if (version == MODULE$.V1() && (BoxesRunTime.unboxToInt((Object)minValueOpt.get()) < 1 || maxValue < BoxesRunTime.unboxToInt((Object)minValueOpt.get()))) {
                    throw new IllegalArgumentException(new StringBuilder(99).append("Expected minValue >= 1, maxValue >= 1 and maxValue >= minValue, but received minValue: ").append(minValueOpt.get()).append(", maxValue: ").append(maxValue).toString());
                }
                if (maxValue < 1) {
                    throw new IllegalArgumentException(new StringBuilder(47).append("Expected maxValue >= 1, but received maxValue: ").append(maxValue).toString());
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName), (Object)BoxesRunTime.boxToShort((short)((short)maxValue)));
            }
            throw new MatchError(null);
        });
    }

    public FeatureZNode apply(int version, FeatureZNodeStatus status, Map<String, Object> features) {
        return new FeatureZNode(version, status, features);
    }

    public Option<Tuple3<Object, FeatureZNodeStatus, Map<String, Object>>> unapply(FeatureZNode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.version()), (Object)x$0.status(), x$0.features()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FeatureZNode$.class);
    }

    private FeatureZNode$() {
    }
}

