/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.function.Supplier;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient;
import kafka.zk.migration.ZkAclMigrationClient;
import kafka.zk.migration.ZkBrokerHealthMigrationClient;
import kafka.zk.migration.ZkClusterLinkMigrationClient;
import kafka.zk.migration.ZkConfigMigrationClient;
import kafka.zk.migration.ZkDelegationTokenMigrationClient;
import kafka.zk.migration.ZkReplicaExclusionMigrationClient;
import kafka.zk.migration.ZkTopicMigrationClient;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.zookeeper.KeeperException;
import scala.Function0;

public final class ZkMigrationClient$ {
    public static final ZkMigrationClient$ MODULE$ = new ZkMigrationClient$();
    private static final int kafka$zk$ZkMigrationClient$$MaxBatchSize = 100;

    public int kafka$zk$ZkMigrationClient$$MaxBatchSize() {
        return kafka$zk$ZkMigrationClient$$MaxBatchSize;
    }

    public ZkMigrationClient apply(KafkaZkClient zkClient, PasswordEncoder zkConfigEncoder, Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier, ClusterLinkConfigEncoder zkLinkConfigEncoder) {
        ZkTopicMigrationClient topicClient = new ZkTopicMigrationClient(zkClient);
        ZkConfigMigrationClient configClient = new ZkConfigMigrationClient(zkClient, zkConfigEncoder, zkLinkConfigEncoder);
        ZkAclMigrationClient aclClient = new ZkAclMigrationClient(zkClient);
        ZkClusterLinkMigrationClient clusterLinkClient = new ZkClusterLinkMigrationClient(zkClient, zkLinkConfigEncoder);
        ZkBrokerHealthMigrationClient brokerHealthClient = new ZkBrokerHealthMigrationClient(zkClient);
        ZkReplicaExclusionMigrationClient replicaExclusionClient = new ZkReplicaExclusionMigrationClient(zkClient);
        ZkDelegationTokenMigrationClient delegationTokenClient = new ZkDelegationTokenMigrationClient(zkClient);
        return new ZkMigrationClient(zkClient, currentMetadataEncryptorFactorySupplier, topicClient, configClient, aclClient, delegationTokenClient, clusterLinkClient, brokerHealthClient, replicaExclusionClient);
    }

    public <T> T wrapZkException(Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public <T> T logAndRethrow(Logging logger, String msg, Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable e) {
            logger.error((Function0<String>)(Function0 & Serializable)() -> msg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw e;
        }
    }

    private ZkMigrationClient$() {
    }
}

