/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1 = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts$1.generateOpt(), opts$1.executeOpt(), opts$1.verifyOpt()}))).count((Function1)new Serializable(opts$1){
            public static final long serialVersionUID;
            private final ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.opts$1.options().has(optionSpec);
            }
            {
                this.opts$1 = reassignPartitionsCommandOptions;
            }
        });
        if (actions != 1) {
            opts$1.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts$1.parser(), opts$1.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts$1.zkConnectOpt()}));
        String zkConnect = (String)opts$1.options().valueOf(opts$1.zkConnectOpt());
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        try {
            if (opts$1.options().has((OptionSpec)opts$1.verifyOpt())) {
                this.verifyAssignment(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.generateOpt())) {
                this.generateAssignment(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.executeOpt())) {
                this.executeAssignment(zkClient, opts$1);
            }
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public void verifyAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            opts.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
        }
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils$.MODULE$.readFileAsString(jsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(jsonString);
        Predef$.MODULE$.println((Object)"Status of partition reassignment:");
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkClient, partitionsToBeReassigned);
        reassignedPartitionsStatus.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<TopicAndPartition, ReassignmentStatus> partition) {
                ReassignmentStatus reassignmentStatus;
                block5: {
                    block3: {
                        block4: {
                            block2: {
                                reassignmentStatus = (ReassignmentStatus)partition._2();
                                ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                                ReassignmentStatus reassignmentStatus2 = reassignmentStatus;
                                if (reassignmentCompleted$ != null ? !reassignmentCompleted$.equals(reassignmentStatus2) : reassignmentStatus2 != null) break block2;
                                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition._1()})));
                                break block3;
                            }
                            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                            ReassignmentStatus reassignmentStatus3 = reassignmentStatus;
                            if (reassignmentFailed$ != null ? !reassignmentFailed$.equals(reassignmentStatus3) : reassignmentStatus3 != null) break block4;
                            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Reassignment of partition %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition._1()})));
                            break block3;
                        }
                        ReassignmentInProgress$ reassignmentInProgress$ = ReassignmentInProgress$.MODULE$;
                        ReassignmentStatus reassignmentStatus4 = reassignmentStatus;
                        if (reassignmentInProgress$ != null ? !reassignmentInProgress$.equals(reassignmentStatus4) : reassignmentStatus4 != null) break block5;
                        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition._1()})));
                    }
                    return;
                }
                throw new MatchError((Object)reassignmentStatus);
            }
        });
    }

    public void generateAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
            opts.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
        }
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign$1 = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt())).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string) {
                return Predef$.MODULE$.augmentString(string).toInt();
            }
        }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()));
        String topicsToMoveJsonString = Utils$.MODULE$.readFileAsString(topicsToMoveJsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> topicPartitionsToReassign = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, topicsToReassign);
        ObjectRef partitionsToBeReassigned$2 = new ObjectRef((Object)new HashMap());
        scala.collection.immutable.Map groupedByTopic = topicPartitionsToReassign.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> tp) {
                return ((TopicAndPartition)tp._1()).topic();
            }
        });
        groupedByTopic.foreach((Function1)new Serializable(brokerListToReassign$1, partitionsToBeReassigned$2){
            public static final long serialVersionUID;
            private final int[] brokerListToReassign$1;
            private final ObjectRef partitionsToBeReassigned$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> topicInfo$1) {
                Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(this.brokerListToReassign$1), ((TraversableOnce)topicInfo$1._2()).size(), ((SeqLike)((Tuple2)((IterableLike)topicInfo$1._2()).head())._2()).size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                this.partitionsToBeReassigned$2.elem = ((Map)this.partitionsToBeReassigned$2.elem).$plus$plus((GenTraversableOnce)assignedReplicas.map((Function1)new Serializable(this, topicInfo$1){
                    public static final long serialVersionUID;
                    private final Tuple2 topicInfo$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> replicaInfo) {
                        return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition((String)this.topicInfo$1._1(), replicaInfo._1$mcI$sp())).$minus$greater(replicaInfo._2());
                    }
                    {
                        this.topicInfo$1 = tuple2;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            }
            {
                this.brokerListToReassign$1 = nArray;
                this.partitionsToBeReassigned$2 = objectRef;
            }
        });
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)((TraversableOnce)((Map)partitionsToBeReassigned$2.elem).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return ((TopicAndPartition)tuple2._1()).topic();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)((Map)partitionsToBeReassigned$2.elem))})));
    }

    public void executeAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile;
        String reassignmentJsonString;
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned;
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            opts.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
        }
        if ((partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(reassignmentJsonString = Utils$.MODULE$.readFileAsString(reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt()), Utils$.MODULE$.readFileAsString$default$2()))).isEmpty()) {
            throw new AdminCommandFailedException(Predef$.MODULE$.augmentString("Partition reassignment data file %s is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reassignmentJsonFile})));
        }
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, partitionsToBeReassigned);
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)((TraversableOnce)partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return ((TopicAndPartition)tuple2._1()).topic();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
        if (reassignPartitionsCommand.reassignPartitions()) {
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Successfully started reassignment of partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData(partitionsToBeReassigned)})));
        } else {
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Failed to reassign partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeReassigned})));
        }
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkClient zkClient$1, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned$1) {
        Map partitionsBeingReassigned$1 = ZkUtils$.MODULE$.getPartitionsBeingReassigned(zkClient$1).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Object> apply(ReassignedPartitionsContext reassignedPartitionsContext) {
                return reassignedPartitionsContext.newReplicas();
            }
        });
        return (Map)partitionsToBeReassigned$1.map((Function1)new Serializable(zkClient$1, partitionsToBeReassigned$1, partitionsBeingReassigned$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;
            private final Map partitionsToBeReassigned$1;
            private final Map partitionsBeingReassigned$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<TopicAndPartition, ReassignmentStatus> apply(Tuple2<TopicAndPartition, Seq<Object>> topicAndPartition) {
                return new Tuple2(topicAndPartition._1(), (Object)ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkClient$1, (TopicAndPartition)topicAndPartition._1(), (Seq<Object>)((Seq)topicAndPartition._2()), (Map<TopicAndPartition, Seq<Object>>)this.partitionsToBeReassigned$1, (Map<TopicAndPartition, Seq<Object>>)this.partitionsBeingReassigned$1));
            }
            {
                this.zkClient$1 = zkClient;
                this.partitionsToBeReassigned$1 = map;
                this.partitionsBeingReassigned$1 = map2;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkClient zkClient, TopicAndPartition topicAndPartition, Seq<Object> reassignedReplicas, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Option option;
        block7: {
            Product product;
            block6: {
                Seq<Object> assignedReplicas;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
                    option = partitionsBeingReassigned.get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    product = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                Seq<Object> seq = assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(zkClient, topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq2 = newReplicas;
                if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                    product = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    product = ReassignmentFailed$.MODULE$;
                }
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

