/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionStateInfo;
import kafka.api.StopReplicaRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.KafkaConfig;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\res!B\u0001\u0003\u0011\u000b9\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148cA\u0005\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000e\n\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001dq\u0012B1A\u0005\u0002}\t1#\u00168l]><h\u000eT8h\u000b:$wJ\u001a4tKR,\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\t1{gn\u001a\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002)Us7N\\8x]2{w-\u00128e\u001f\u001a47/\u001a;!\u0011\u001d1\u0013B1A\u0005\u0002\u001d\nQ\u0003S5hQ^\u000bG/\u001a:nCJ\\g)\u001b7f]\u0006lW-F\u0001)!\ti\u0011&\u0003\u0002+\u001d\t11\u000b\u001e:j]\u001eDa\u0001L\u0005!\u0002\u0013A\u0013A\u0006%jO\"<\u0016\r^3s[\u0006\u00148NR5mK:\fW.\u001a\u0011\u0007\t)\u0011\u0001AL\n\u0006[1yS\u0007\u0006\t\u0003aMj\u0011!\r\u0006\u0003e\u0011\tQ!\u001e;jYNL!\u0001N\u0019\u0003\u000f1{wmZ5oOB\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\b[\u0016$(/[2t\u0013\tQtGA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001\u0002P\u0017\u0003\u0006\u0004%\t!P\u0001\u0007G>tg-[4\u0016\u0003y\u0002\"\u0001C \n\u0005\u0001\u0013!aC&bM.\f7i\u001c8gS\u001eD\u0001BQ\u0017\u0003\u0002\u0003\u0006IAP\u0001\bG>tg-[4!\u0011!!UF!A!\u0002\u0013)\u0015\u0001\u0002;j[\u0016\u0004\"\u0001\r$\n\u0005\u001d\u000b$\u0001\u0002+j[\u0016D\u0001\"S\u0017\u0003\u0006\u0004%\tAS\u0001\tu.\u001cE.[3oiV\t1\n\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u0006A!p[2mS\u0016tGO\u0003\u0002Q#\u00061\u0011\nM%uK\u000eT\u0011AU\u0001\u0004_J<\u0017B\u0001+N\u0005!Q6n\u00117jK:$\b\u0002\u0003,.\u0005\u0003\u0005\u000b\u0011B&\u0002\u0013i\\7\t\\5f]R\u0004\u0003\u0002\u0003-.\u0005\u0003\u0005\u000b\u0011B-\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u0019[\u0013\tY\u0016GA\u0005TG\",G-\u001e7fe\"AQ,\fBC\u0002\u0013\u0005a,\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012a\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0003E\u0012\t1\u0001\\8h\u0013\t!\u0017M\u0001\u0006M_\u001el\u0015M\\1hKJD\u0001BZ\u0017\u0003\u0002\u0003\u0006IaX\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005i[\t\u0015\r\u0011\"\u0001j\u00039I7o\u00155viRLgn\u001a#po:,\u0012A\u001b\t\u0003WJl\u0011\u0001\u001c\u0006\u0003[:\fa!\u0019;p[&\u001c'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003cB\tA!\u001e;jY&\u00111\u000f\u001c\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u0011Ul#\u0011!Q\u0001\n)\fq\"[:TQV$H/\u001b8h\t><h\u000e\t\u0005\u000675\"\ta\u001e\u000b\bqfT8\u0010`?\u007f!\tAQ\u0006C\u0003=m\u0002\u0007a\bC\u0003Em\u0002\u0007Q\tC\u0003Jm\u0002\u00071\nC\u0003Ym\u0002\u0007\u0011\fC\u0003^m\u0002\u0007q\fC\u0003im\u0002\u0007!\u000eC\u0005\u0002\u00025\u0002\r\u0011\"\u0001\u0002\u0004\u0005y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002\u0006A\u0019Q#a\u0002\n\u0007\u0005%aCA\u0002J]RD\u0011\"!\u0004.\u0001\u0004%\t!a\u0004\u0002'\r|g\u000e\u001e:pY2,'/\u00129pG\"|F%Z9\u0015\t\u0005E\u0011q\u0003\t\u0004+\u0005M\u0011bAA\u000b-\t!QK\\5u\u0011)\tI\"a\u0003\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0004\u0002CA\u000f[\u0001\u0006K!!\u0002\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0003\u0006BA\u000e\u0003C\u00012!FA\u0012\u0013\r\t)C\u0006\u0002\tm>d\u0017\r^5mK\"I\u0011\u0011F\u0017C\u0002\u0013%\u00111A\u0001\u000eY>\u001c\u0017\r\u001c\"s_.,'/\u00133\t\u0011\u00055R\u0006)A\u0005\u0003\u000b\ta\u0002\\8dC2\u0014%o\\6fe&#\u0007\u0005C\u0005\u000225\u0012\r\u0011\"\u0003\u00024\u0005i\u0011\r\u001c7QCJ$\u0018\u000e^5p]N,\"!!\u000e\u0011\u000fA\n9$a\u000f\u0002N%\u0019\u0011\u0011H\u0019\u0003\tA{w\u000e\u001c\t\b+\u0005u\u0012\u0011IA\u0003\u0013\r\tyD\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\r\u0013\u0011\n\b\u0004+\u0005\u0015\u0013bAA$-\u00051\u0001K]3eK\u001aL1AKA&\u0015\r\t9E\u0006\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011qKA)\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002\\5\u0002\u000b\u0011BA\u001b\u00039\tG\u000e\u001c)beRLG/[8og\u0002B\u0011\"a\u0018.\u0001\u0004%I!!\u0019\u0002!1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001cXCAA2!\u0019\t)'a\u001c\u0002N5\u0011\u0011q\r\u0006\u0005\u0003S\nY'A\u0004nkR\f'\r\\3\u000b\u0007\u00055d#\u0001\u0006d_2dWm\u0019;j_:LA!!\u001d\u0002h\t9\u0001*Y:i'\u0016$\b\"CA;[\u0001\u0007I\u0011BA<\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011\u0011CA=\u0011)\tI\"a\u001d\u0002\u0002\u0003\u0007\u00111\r\u0005\t\u0003{j\u0003\u0015)\u0003\u0002d\u0005\tB.Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0013\u0005\u0005UF1A\u0005\n\u0005\r\u0015\u0001\u00067fC\u0012,'\u000fU1si&$\u0018n\u001c8t\u0019>\u001c7.F\u0001\r\u0011\u001d\t9)\fQ\u0001\n1\tQ\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\:M_\u000e\\\u0007\u0005C\u0005\u0002\f6\u0012\r\u0011\"\u0003\u0002\u0004\u00061\"/\u001a9mS\u000e\f7\u000b^1uK\u000eC\u0017M\\4f\u0019>\u001c7\u000eC\u0004\u0002\u00106\u0002\u000b\u0011\u0002\u0007\u0002/I,\u0007\u000f\\5dCN#\u0018\r^3DQ\u0006tw-\u001a'pG.\u0004\u0003\"CAJ[\t\u0007I\u0011AAK\u0003U\u0011X\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ,\"!a&\u0011\u0007!\tI*C\u0002\u0002\u001c\n\u0011QCU3qY&\u001c\u0017MR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005\u0002 6\u0002\u000b\u0011BAL\u0003Y\u0011X\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ\u0004\u0003\u0002CAR[\t\u0007I\u0011B5\u0002I!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b)pS:$H\u000b\u001b:fC\u0012\u001cF/\u0019:uK\u0012Dq!a*.A\u0003%!.A\u0013iS\u001eDw+\u0019;fe6\f'o[\"iK\u000e\\\u0007k\\5oiRC'/Z1e'R\f'\u000f^3eA!I\u00111V\u0017C\u0002\u0013\u0005\u0011QV\u0001\u0019Q&<\u0007nV1uKJl\u0017M]6DQ\u0016\u001c7\u000e]8j]R\u001cXCAAX!\u001d\t\t,a.)\u0003wk!!a-\u000b\t\u0005U\u00161N\u0001\nS6lW\u000f^1cY\u0016LA!!/\u00024\n\u0019Q*\u00199\u0011\u0007!\ti,C\u0002\u0002@\n\u0011\u0001c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\t\u0011\u0005\rW\u0006)A\u0005\u0003_\u000b\u0011\u0004[5hQ^\u000bG/\u001a:nCJ\\7\t[3dWB|\u0017N\u001c;tA!I\u0011qY\u0017A\u0002\u0013%\u0011\u0011Z\u0001\u0014Q^$\u0006N]3bI&s\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0003\u0017\u00042!FAg\u0013\r\tyM\u0006\u0002\b\u0005>|G.Z1o\u0011%\t\u0019.\fa\u0001\n\u0013\t).A\fioRC'/Z1e\u0013:LG/[1mSj,Gm\u0018\u0013fcR!\u0011\u0011CAl\u0011)\tI\"!5\u0002\u0002\u0003\u0007\u00111\u001a\u0005\t\u00037l\u0003\u0015)\u0003\u0002L\u0006!\u0002n\u001e+ie\u0016\fG-\u00138ji&\fG.\u001b>fI\u0002B\u0011\"a8.\u0005\u0004%\t!!9\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002dB!\u0011Q]Ay\u001d\u0011\t9/!<\u000e\u0005\u0005%(bAAv\t\u0005Q1m\u001c8ue>dG.\u001a:\n\t\u0005=\u0018\u0011^\u0001\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe&!\u00111_A{\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0006\u0005\u0003_\fI\u000f\u0003\u0005\u0002z6\u0002\u000b\u0011BAr\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u0013\u0005uXF1A\u0005\u0002\u0005}\u0018!D5te\u0016C\b/\u00198e%\u0006$X-\u0006\u0002\u0003\u0002A!!1\u0001B\n\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011\u0001B2pe\u0016T1\u0001\u000fB\u0006\u0015\u0011\u0011iAa\u0004\u0002\re\fW.\\3s\u0015\t\u0011\t\"A\u0002d_6LAA!\u0006\u0003\u0006\t)Q*\u001a;fe\"A!\u0011D\u0017!\u0002\u0013\u0011\t!\u0001\bjgJ,\u0005\u0010]1oIJ\u000bG/\u001a\u0011\t\u0013\tuQF1A\u0005\u0002\u0005}\u0018!D5teNC'/\u001b8l%\u0006$X\r\u0003\u0005\u0003\"5\u0002\u000b\u0011\u0002B\u0001\u00039I7O]*ie&t7NU1uK\u0002BqA!\n.\t\u0003\u00119#A\u000fv]\u0012,'OU3qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u)\t\t)\u0001C\u0004\u0003,5\"\tA!\f\u0002GM$\u0018M\u001d;IS\u001eDw+\u0019;fe6\u000b'o[:DQ\u0016\u001c7\u000eU8j]R$\u0006N]3bIR\u0011\u0011\u0011\u0003\u0005\b\u0005ciC\u0011\u0001B\u001a\u0003\u0001:W\r\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\r\u0005\u0015!Q\u0007B\u001d\u0011!\u00119Da\fA\u0002\u0005\u0005\u0013!\u0002;pa&\u001c\u0007\u0002\u0003B\u001e\u0005_\u0001\r!!\u0002\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0005\u007fiC\u0011\u0001B\u0017\u0003\u001d\u0019H/\u0019:ukBDqAa\u0011.\t\u0003\u0011)%A\u0006ti>\u0004(+\u001a9mS\u000e\fG\u0003\u0003B$\u0005\u001b\u0012yE!\u0015\u0011\u0007U\u0011I%C\u0002\u0003LY\u0011Qa\u00155peRD\u0001Ba\u000e\u0003B\u0001\u0007\u0011\u0011\t\u0005\t\u0005w\u0011\t\u00051\u0001\u0002\u0006!A!1\u000bB!\u0001\u0004\tY-A\beK2,G/\u001a)beRLG/[8o\u0011\u001d\u00119&\fC\u0001\u00053\nAb\u001d;paJ+\u0007\u000f\\5dCN$BAa\u0017\u0003nA9Q#!\u0010\u0003^\t\u001d\u0003\u0003CA3\u0005?\u0012\tGa\u0012\n\t\u0005e\u0016q\r\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)\u0019!q\r\u0003\u0002\r\r|W.\\8o\u0013\u0011\u0011YG!\u001a\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0003p\tU\u0003\u0019\u0001B9\u0003I\u0019Ho\u001c9SKBd\u0017nY1SKF,Xm\u001d;\u0011\t\tM$\u0011P\u0007\u0003\u0005kR1Aa\u001e\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005w\u0012)H\u0001\nTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$\bb\u0002B@[\u0011\u0005!\u0011Q\u0001\u0015O\u0016$xJ]\"sK\u0006$X\rU1si&$\u0018n\u001c8\u0015\u0011\u00055#1\u0011BC\u0005\u000fC\u0001Ba\u000e\u0003~\u0001\u0007\u0011\u0011\t\u0005\t\u0005w\u0011i\b1\u0001\u0002\u0006!A!\u0011\u0012B?\u0001\u0004\t)!A\tsKBd\u0017nY1uS>tg)Y2u_JDqA!$.\t\u0003\u0011y)\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0003\u0012\n]%\u0011\u0014\t\u0006+\tM\u0015QJ\u0005\u0004\u0005+3\"AB(qi&|g\u000e\u0003\u0005\u00038\t-\u0005\u0019AA!\u0011!\u0011YDa#A\u0002\u0005\u0015\u0001b\u0002BO[\u0011\u0005!qT\u0001\u0016O\u0016$(+\u001a9mS\u000e\fwJ]#yG\u0016\u0004H/[8o)\u0019\u0011\tKa*\u0003*B!\u0011q\nBR\u0013\u0011\u0011)+!\u0015\u0003\u000fI+\u0007\u000f\\5dC\"A!q\u0007BN\u0001\u0004\t\t\u0005\u0003\u0005\u0003,\nm\u0005\u0019AA\u0003\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u000306\"\tA!-\u0002/\u001d,G\u000fT3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017J\u001a'pG\u0006dGC\u0002BQ\u0005g\u0013)\f\u0003\u0005\u00038\t5\u0006\u0019AA!\u0011!\u0011YD!,A\u0002\u0005\u0015\u0001b\u0002B][\u0011\u0005!1X\u0001\u000bO\u0016$(+\u001a9mS\u000e\fG\u0003\u0003B_\u0005\u007f\u0013\tMa1\u0011\u000bU\u0011\u0019J!)\t\u0011\t]\"q\u0017a\u0001\u0003\u0003B\u0001Ba\u000f\u00038\u0002\u0007\u0011Q\u0001\u0005\u000b\u0005\u000b\u00149\f%AA\u0002\u0005\u0015\u0011!\u0003:fa2L7-Y%e\u0011\u001d\u0011I-\fC\u0001\u0005\u0017\faCY3d_6,G*Z1eKJ|%OR8mY><XM\u001d\u000b\u0005\u0005\u001b\u0014)\u000eE\u0004\u0016\u0003{\u0011yMa\u0012\u0011\u0011\tE'1[A\u001e\u0005\u000fj!!a\u001b\n\t\u0005e\u00161\u000e\u0005\t\u0005/\u00149\r1\u0001\u0003Z\u0006\u0019B.Z1eKJ\fe\u000eZ%T%J+\u0017/^3tiB!!1\u000fBn\u0013\u0011\u0011iN!\u001e\u0003'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\t\u000f\t\u0005X\u0006\"\u0003\u0003d\u0006YQ.Y6f\u0019\u0016\fG-\u001a:t)1\t\tB!:\u0003j\n5(\u0011 B\u007f\u0011!\u00119Oa8A\u0002\u0005\u0015\u0011\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0002\u0003Bv\u0005?\u0004\r!!\u0002\u0002\u000b\u0015\u0004xn\u00195\t\u0011\t=(q\u001ca\u0001\u0005c\fa\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\u0005\u0005\u0003R\nM\u0017Q\nBz!\u0011\u0011\u0019H!>\n\t\t](Q\u000f\u0002\u0013!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0013:4w\u000e\u0003\u0005\u0003|\n}\u0007\u0019AA\u0003\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\"A!q Bp\u0001\u0004\u0019\t!A\u0006sKN\u0004xN\\:f\u001b\u0006\u0004\b\u0003CA3\u0005?\nYDa\u0012\t\u000f\r\u0015Q\u0006\"\u0003\u0004\b\u0005iQ.Y6f\r>dGn\\<feN$b\"!\u0005\u0004\n\r-1QBB\b\u0007?\u0019\t\u0003\u0003\u0005\u0003h\u000e\r\u0001\u0019AA\u0003\u0011!\u0011Yoa\u0001A\u0002\u0005\u0015\u0001\u0002\u0003Bx\u0007\u0007\u0001\rA!=\t\u0011\rE11\u0001a\u0001\u0007'\tq\u0001\\3bI\u0016\u00148\u000f\u0005\u0004\u0003R\u000eU1\u0011D\u0005\u0005\u0007/\tYGA\u0002TKR\u0004B!a\u0014\u0004\u001c%!1QDA)\u0005\u0019\u0011%o\\6fe\"A!1`B\u0002\u0001\u0004\t)\u0001\u0003\u0005\u0003\u0000\u000e\r\u0001\u0019AB\u0001\u0011\u001d\u0019)#\fC\u0005\u0005[\ta\"\\1zE\u0016\u001c\u0006N]5oW&\u001b(\u000fC\u0004\u0004*5\"\taa\u000b\u0002-I,7m\u001c:e\r>dGn\\<feB{7/\u001b;j_:$\"\"!\u0005\u0004.\r=2\u0011GB\u001a\u0011!\u00119da\nA\u0002\u0005\u0005\u0003\u0002\u0003B\u001e\u0007O\u0001\r!!\u0002\t\u0011\t\u00157q\u0005a\u0001\u0003\u000bAqa!\u000e\u0004(\u0001\u0007\u0001%\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0007siC\u0011\u0001B\u0017\u0003a\u0019\u0007.Z2la>Lg\u000e\u001e%jO\"<\u0016\r^3s[\u0006\u00148n\u001d\u0005\b\u0007{iC\u0011\u0001B\u0017\u0003!\u0019\b.\u001e;e_^t\u0007\"CB![E\u0005I\u0011AB\"\u0003Q9W\r\u001e*fa2L7-\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\t\u0016\u0005\u0003\u000b\u00199e\u000b\u0002\u0004JA!11JB+\u001b\t\u0019iE\u0003\u0003\u0004P\rE\u0013!C;oG\",7m[3e\u0015\r\u0019\u0019FF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB,\u0007\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final Scheduler scheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions;
    private final Object kafka$server$ReplicaManager$$leaderPartitionsLock;
    private final Object replicaStateChangeLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final String HighWatermarkFilename() {
        return ReplicaManager$.MODULE$.HighWatermarkFilename();
    }

    public static final long UnknownLogEndOffset() {
        return ReplicaManager$.MODULE$.UnknownLogEndOffset();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaManager replicaManager = this;
        synchronized (replicaManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    public final int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    public final HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions() {
        return this.kafka$server$ReplicaManager$$leaderPartitions;
    }

    private void kafka$server$ReplicaManager$$leaderPartitions_$eq(HashSet<Partition> hashSet) {
        this.kafka$server$ReplicaManager$$leaderPartitions = hashSet;
    }

    public final Object kafka$server$ReplicaManager$$leaderPartitionsLock() {
        return this.kafka$server$ReplicaManager$$leaderPartitionsLock;
    }

    private Object replicaStateChangeLock() {
        return this.replicaStateChangeLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean bl) {
        this.hwThreadInitialized = bl;
    }

    public KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public int underReplicatedPartitionCount() {
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            Integer n = BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$leaderPartitions().count((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Partition partition) {
                    return partition.isUnderReplicated();
                }
            }));
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    public void startHighWaterMarksCheckPointThread() {
        if (this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true)) {
            String x$9 = "highwatermark-checkpoint";
            Serializable x$10 = new Serializable(this){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointHighWatermarks();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            long x$11 = this.config().replicaHighWatermarkCheckpointIntervalMs();
            TimeUnit x$12 = TimeUnit.MILLISECONDS;
            long x$13 = this.scheduler.schedule$default$3();
            this.scheduler.schedule("highwatermark-checkpoint", (Function0<BoxedUnit>)x$10, x$13, x$11, TimeUnit.MILLISECONDS);
        }
    }

    public int getReplicationFactorForPartition(String topic, int partitionId) {
        Option<Partition> option;
        block4: {
            int n;
            block3: {
                block2: {
                    Option<Partition> partitionOpt = this.getPartition(topic, partitionId);
                    option = partitionOpt;
                    if (!(option instanceof Some)) break block2;
                    n = ((Partition)((Some)option).x()).replicationFactor();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                n = -1;
            }
            return n;
        }
        throw new MatchError(option);
    }

    public void startup() {
        String x$14 = "isr-expiration";
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        long x$16 = this.config().replicaLagTimeMaxMs();
        TimeUnit x$17 = TimeUnit.MILLISECONDS;
        long x$18 = this.scheduler.schedule$default$3();
        this.scheduler.schedule("isr-expiration", (Function0<BoxedUnit>)x$15, x$18, x$16, TimeUnit.MILLISECONDS);
    }

    /*
     * Loose catch block
     */
    public short stopReplica(String topic$2, int partitionId$2, boolean deletePartition$1) {
        Option<Partition> option;
        block11: {
            short errorCode;
            block10: {
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$2, partitionId$2, deletePartition$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final String topic$2;
                    private final int partitionId$2;
                    private final boolean deletePartition$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Broker %d handling stop replica (delete=%s) for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), ((Object)BoxesRunTime.boxToBoolean((boolean)this.deletePartition$1)).toString(), this.topic$2, BoxesRunTime.boxToInteger((int)this.partitionId$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$2 = string;
                        this.partitionId$2 = n;
                        this.deletePartition$1 = bl;
                    }
                });
                errorCode = ErrorMapping$.MODULE$.NoError();
                option = this.getPartition(topic$2, partitionId$2);
                if (option instanceof Some) {
                    Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
                    synchronized (object) {
                        Partition removedPartition;
                        this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq(((Some)option).x());
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl10 : MonitorExitStatement: MONITOREXIT : var6_6
                        if (deletePartition$1 && (removedPartition = this.kafka$server$ReplicaManager$$allPartitions().remove((Tuple2<String, Object>)new Tuple2((Object)topic$2, (Object)BoxesRunTime.boxToInteger((int)partitionId$2)))) != null) {
                            removedPartition.delete();
                        }
                        break block10;
                    }
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block11;
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$2, partitionId$2, deletePartition$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final String topic$2;
                    private final int partitionId$2;
                    private final boolean deletePartition$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Broker %d ignoring stop replica (delete=%s) for partition [%s,%d] as replica doesn't exist on broker").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)this.deletePartition$1), this.topic$2, BoxesRunTime.boxToInteger((int)this.partitionId$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$2 = string;
                        this.partitionId$2 = n;
                        this.deletePartition$1 = bl;
                    }
                });
            }
            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$2, partitionId$2, deletePartition$1){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                private final String topic$2;
                private final int partitionId$2;
                private final boolean deletePartition$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Broker %d finished handling stop replica (delete=%s) for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)this.deletePartition$1), this.topic$2, BoxesRunTime.boxToInteger((int)this.partitionId$2)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topic$2 = string;
                    this.partitionId$2 = n;
                    this.deletePartition$1 = bl;
                }
            });
            return errorCode;
        }
        throw new MatchError(option);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public Tuple2<scala.collection.mutable.Map<TopicAndPartition, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest$1) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap$1 = new HashMap();
            if (stopReplicaRequest$1.controllerEpoch() < this.controllerEpoch()) {
                this.stateChangeLogger().warn((Function0<String>)new Serializable(this, stopReplicaRequest$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.stopReplicaRequest$1.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.controllerEpoch())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$1, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                this.controllerEpoch_$eq(stopReplicaRequest$1.controllerEpoch());
                this.replicaFetcherManager().removeFetcherForPartitions((Set<TopicAndPartition>)((Set)stopReplicaRequest$1.partitions().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(TopicAndPartition r) {
                        return new TopicAndPartition(r.topic(), r.partition());
                    }
                }, Set$.MODULE$.canBuildFrom())));
                stopReplicaRequest$1.partitions().foreach((Function1)new Serializable(this, stopReplicaRequest$1, responseMap$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;
                    private final HashMap responseMap$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<Object> apply(TopicAndPartition topicAndPartition) {
                        short errorCode = this.$outer.stopReplica(topicAndPartition.topic(), topicAndPartition.partition(), this.stopReplicaRequest$1.deletePartitions());
                        return this.responseMap$1.put((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)errorCode));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest;
                        this.responseMap$1 = hashMap;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$1, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    public Partition getOrCreatePartition(String topic, int partitionId, int replicationFactor) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        if (partition == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), new Partition(topic, partitionId, replicationFactor, this.time, this));
            partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        }
        return partition;
    }

    public Option<Partition> getPartition(String topic, int partitionId) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        return partition == null ? None$.MODULE$ : new Some((Object)partition);
    }

    public Replica getReplicaOrException(String topic, int partition) {
        Option<Replica> replicaOpt = this.getReplica(topic, partition, this.getReplica$default$3());
        if (replicaOpt.isDefined()) {
            return (Replica)replicaOpt.get();
        }
        throw new ReplicaNotAvailableException(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), topic, BoxesRunTime.boxToInteger((int)partition)})));
    }

    public Replica getLeaderReplicaIfLocal(String topic, int partitionId) {
        Option<Partition> partitionOpt;
        Option<Partition> option = partitionOpt = this.getPartition(topic, partitionId);
        None$ none$ = None$.MODULE$;
        Option<Partition> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new UnknownTopicOrPartitionException(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition = (Partition)some.x();
            Partition partition2 = partition;
            Option<Replica> option3 = partition2.leaderReplicaIfLocal();
            if (option3 instanceof Some) {
                return (Replica)((Some)option3).x();
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option4 = option3;
            if (!(none$2 != null ? !none$2.equals(option4) : option4 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
            }
            throw new MatchError(option3);
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(String topic, int partitionId, int replicaId) {
        Option<Partition> option;
        block4: {
            Option<Replica> option2;
            block3: {
                block2: {
                    Option<Partition> partitionOpt;
                    option = partitionOpt = this.getPartition(topic, partitionId);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                option2 = ((Partition)((Some)option).x()).getReplica(replicaId);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndISRRequest$1) {
        leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            public final LeaderAndIsrRequest leaderAndISRRequest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                if (tuple22 != null) {
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                    if (tuple23 != null) {
                        String string = (String)tuple23._1();
                        int n = BoxesRunTime.unboxToInt((Object)tuple23._2());
                        String topic$3 = string;
                        int partition$1 = n;
                        PartitionStateInfo stateInfo$1 = partitionStateInfo;
                        this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$3, partition$1, stateInfo$1){
                            public static final long serialVersionUID;
                            private final $anonfun$becomeLeaderOrFollower$1 $outer;
                            private final String topic$3;
                            private final int partition$1;
                            private final PartitionStateInfo stateInfo$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request %s correlation id %d from controller %d epoch %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), this.stateInfo$1, BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topic$3 = string;
                                this.partition$1 = n;
                                this.stateInfo$1 = partitionStateInfo;
                            }
                        });
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple22);
            }

            public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap$2 = new HashMap();
            if (leaderAndISRRequest$1.controllerEpoch() < this.controllerEpoch()) {
                leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final LeaderAndIsrRequest leaderAndISRRequest$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null && tuple22._1() != null) {
                            this.$outer.stateChangeLogger().warn((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$becomeLeaderOrFollower$2 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlation id %d with an old controller epoch %d. Latest known controller epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().controllerEpoch())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                int controllerId$1 = leaderAndISRRequest$1.controllerId();
                int correlationId$1 = leaderAndISRRequest$1.correlationId();
                this.controllerEpoch_$eq(leaderAndISRRequest$1.controllerEpoch());
                HashMap partitionState$1 = new HashMap();
                leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1, responseMap$2, controllerId$1, correlationId$1, partitionState$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final LeaderAndIsrRequest leaderAndISRRequest$1;
                    private final HashMap responseMap$2;
                    public final int controllerId$1;
                    public final int correlationId$1;
                    private final HashMap partitionState$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null) {
                            Tuple2 tuple23 = (Tuple2)tuple22._1();
                            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                            if (tuple23 != null) {
                                Option option;
                                PartitionStateInfo partitionStateInfo$1;
                                int n;
                                int partitionId;
                                String string = (String)tuple23._1();
                                String topic$4 = string;
                                Partition partition$2 = this.$outer.getOrCreatePartition(topic$4, partitionId = (n = BoxesRunTime.unboxToInt((Object)tuple23._2())), (partitionStateInfo$1 = partitionStateInfo).replicationFactor());
                                int partitionLeaderEpoch$1 = partition$2.getLeaderEpoch();
                                if (partitionLeaderEpoch$1 < partitionStateInfo$1.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()) {
                                    if (partitionStateInfo$1.allReplicas().contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()))) {
                                        option = this.partitionState$1.put((Object)partition$2, (Object)partitionStateInfo$1);
                                    } else {
                                        this.$outer.stateChangeLogger().warn((Function0<String>)new Serializable(this, topic$4, partitionStateInfo$1, partition$2){
                                            public static final long serialVersionUID;
                                            private final $anonfun$becomeLeaderOrFollower$3 $outer;
                                            private final String topic$4;
                                            private final PartitionStateInfo partitionStateInfo$1;
                                            private final Partition partition$2;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request with correlation id %d from controller %d epoch %d as broker is not in assigned replica list %s for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$1), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.partitionStateInfo$1.allReplicas().mkString(","), this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$2.partitionId())}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.topic$4 = string;
                                                this.partitionStateInfo$1 = partitionStateInfo;
                                                this.partition$2 = partition;
                                            }
                                        });
                                        option = BoxedUnit.UNIT;
                                    }
                                } else {
                                    this.$outer.stateChangeLogger().warn((Function0<String>)new Serializable(this, topic$4, partitionStateInfo$1, partition$2, partitionLeaderEpoch$1){
                                        public static final long serialVersionUID;
                                        private final $anonfun$becomeLeaderOrFollower$3 $outer;
                                        private final String topic$4;
                                        private final PartitionStateInfo partitionStateInfo$1;
                                        private final Partition partition$2;
                                        private final int partitionLeaderEpoch$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Broker %d received invalid LeaderAndIsr request with correlation id %d from controller %d epoch %d with an older leader epoch %d for partition [%s,%d], current leader epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$1), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)this.partitionStateInfo$1.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()), this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$2.partitionId()), BoxesRunTime.boxToInteger((int)this.partitionLeaderEpoch$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topic$4 = string;
                                            this.partitionStateInfo$1 = partitionStateInfo;
                                            this.partition$2 = partition;
                                            this.partitionLeaderEpoch$1 = n;
                                        }
                                    });
                                    option = this.responseMap$2.put((Object)new Tuple2((Object)topic$4, (Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleLeaderEpochCode()));
                                }
                                return option;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple22);
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                        this.responseMap$2 = hashMap;
                        this.controllerId$1 = n;
                        this.correlationId$1 = n2;
                        this.partitionState$1 = hashMap2;
                    }
                });
                HashMap partitionsTobeLeader = (HashMap)partitionState$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<Partition, PartitionStateInfo> tuple2) {
                        Tuple2<Partition, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return ((PartitionStateInfo)tuple22._2()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == this.$outer.config().brokerId();
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                HashMap partitionsToBeFollower = (HashMap)partitionState$1.$minus$minus((GenTraversableOnce)partitionsTobeLeader.keys());
                if (!partitionsTobeLeader.isEmpty()) {
                    this.makeLeaders(controllerId$1, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsTobeLeader, leaderAndISRRequest$1.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap$2);
                }
                if (!partitionsToBeFollower.isEmpty()) {
                    this.makeFollowers(controllerId$1, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsToBeFollower, leaderAndISRRequest$1.leaders(), leaderAndISRRequest$1.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap$2);
                }
                if (!this.hwThreadInitialized()) {
                    this.startHighWaterMarksCheckPointThread();
                    this.hwThreadInitialized_$eq(true);
                }
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                tuple2 = new Tuple2((Object)responseMap$2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    /*
     * Exception decompiling
     */
    private void makeLeaders(int controllerId$2, int epoch$1, Map<Partition, PartitionStateInfo> partitionState, int correlationId$2, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap$3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void makeFollowers(int controllerId$3, int epoch$2, Map<Partition, PartitionStateInfo> partitionState, Set<Broker> leaders$1, int correlationId$3, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap$4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        });
        List curLeaderPartitions = null;
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            curLeaderPartitions = this.kafka$server$ReplicaManager$$leaderPartitions().toList();
        }
        curLeaderPartitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Partition partition) {
                partition.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void recordFollowerPosition(String topic$1, int partitionId$1, int replicaId, long offset) {
        Option<Partition> partitionOpt = this.getPartition(topic$1, partitionId$1);
        if (partitionOpt.isDefined()) {
            ((Partition)partitionOpt.get()).updateLeaderHWAndMaybeExpandIsr(replicaId, offset);
        } else {
            this.warn((Function0<String>)new Serializable(this, topic$1, partitionId$1){
                public static final long serialVersionUID;
                private final String topic$1;
                private final int partitionId$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                }
                {
                    this.topic$1 = string;
                    this.partitionId$1 = n;
                }
            });
        }
    }

    public void checkpointHighWatermarks() {
        Iterable replicas = (Iterable)((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Replica> apply(Partition partition) {
                return partition.getReplica(this.$outer.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect(new PartialFunction(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public <A1 extends Option<Replica>, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                return PartialFunction.class.orElse((PartialFunction)this, that);
            }

            public <C> PartialFunction<Option<Replica>, C> andThen(Function1<Replica, C> k) {
                return PartialFunction.class.andThen((PartialFunction)this, k);
            }

            public Function1<Option<Replica>, Option<Replica>> lift() {
                return PartialFunction.class.lift((PartialFunction)this);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
            }

            public <A> Function1<A, Replica> compose(Function1<A, Option<Replica>> g) {
                return Function1.class.compose((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcID$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJD$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcIF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJF$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcII$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJI$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcIJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJJ$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcID$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcIF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcII$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcIJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVJ$sp((Function1)this, g);
            }

            public String toString() {
                return Function1.class.toString((Function1)this);
            }

            public final Replica apply(Option<Replica> option) {
                Option<Replica> option2 = option;
                if (option2 instanceof Some) {
                    return (Replica)((Some)option2).x();
                }
                throw new MatchError(option2);
            }

            public final boolean isDefinedAt(Option<Replica> option) {
                Option<Replica> option2 = option;
                return option2 instanceof Some;
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map replicasByDir = ((TraversableLike)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.log().isDefined();
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Replica replica) {
                return ((Log)replica.log().get()).dir().getParentFile().getAbsolutePath();
            }
        });
        ((IterableLike)replicasByDir.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Iterable iterable;
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                Iterable reps = iterable = (Iterable)tuple22._2();
                scala.collection.immutable.Map hwms = ((TraversableOnce)reps.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, Object> apply(Replica r) {
                        return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(r)).$minus$greater((Object)BoxesRunTime.boxToLong((long)r.highWatermark()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                try {
                    ((OffsetCheckpoint)this.$outer.highWatermarkCheckpoints().apply(tuple22._1())).write((Map<TopicAndPartition, Object>)hwms);
                    return;
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Error writing to highwatermark file: ";
                        }
                    }, (Function0<Throwable>)new Serializable(this, iOException){
                        public static final long serialVersionUID;
                        private final IOException e$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final IOException apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = iOException;
                        }
                    });
                    Runtime.getRuntime().halt(1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shut down";
            }
        });
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutted down completely";
            }
        });
    }

    public ReplicaManager(KafkaConfig config, Time time, ZkClient zkClient, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown) {
        this.config = config;
        this.time = time;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.logManager = logManager;
        this.isShuttingDown = isShuttingDown;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = config.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.init$default$1());
        this.kafka$server$ReplicaManager$$leaderPartitions = new HashSet();
        this.kafka$server$ReplicaManager$$leaderPartitionsLock = new Object();
        this.replicaStateChangeLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(config, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)config.logDirs().map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().size());
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.underReplicatedPartitionCount();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS);
        this.isrShrinkRate = this.newMeter("IsrShrinksPerSec", "shrinks", TimeUnit.SECONDS);
    }
}

