/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.ReassignedPartitionsContext$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import kafka.utils.ZkUtils$$anonfun$getConsumersPerTopic$1$;
import kafka.utils.ZkUtils$$anonfun$getReplicaAssignmentForTopics$1$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String TopicConfigPath;
    private final String TopicConfigChangesPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String TopicConfigPath() {
        return this.TopicConfigPath;
    }

    public String TopicConfigChangesPath() {
        return this.TopicConfigChangesPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicConfigPath(String topic) {
        return new StringBuilder().append((Object)this.TopicConfigPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public int getController(ZkClient zkClient) {
        Option option = (Option)this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            return KafkaController$.MODULE$.parseControllerId((String)((Some)option).x());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError((Object)option);
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Object> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string) {
                return Predef$.MODULE$.augmentString(string).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient$4) {
        Seq brokerIds = (Seq)this.getChildrenParentMayNotExist(zkClient$4, this.BrokerIdsPath()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)brokerIds.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string) {
                return Predef$.MODULE$.augmentString(string).toInt();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(zkClient$4){
            public static final long serialVersionUID;
            private final ZkClient zkClient$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Broker> apply(int n) {
                return ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$4, n);
            }
            {
                this.zkClient$4 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Option<Broker> option) {
                return option.isDefined();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Broker apply(Option<Broker> option) {
                return (Broker)option.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    String leaderAndIsrPath = this.getTopicPartitionLeaderAndIsrPath(topic, partition);
                    Tuple2<Option<String>, Stat> leaderAndIsrInfo = this.readDataMaybeNull(zkClient, leaderAndIsrPath);
                    Option leaderAndIsrOpt = (Option)leaderAndIsrInfo._1();
                    Stat stat = (Stat)leaderAndIsrInfo._2();
                    option = leaderAndIsrOpt;
                    if (!(option instanceof Some)) break block2;
                    none$ = this.parseLeaderAndIsr((String)((Some)option).x(), topic, partition, stat);
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String topic, int partition) {
        return this.getLeaderIsrAndEpochForPartition(zkClient, topic, partition).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch) {
                return leaderIsrAndControllerEpoch.leaderAndIsr();
            }
        });
    }

    public void setupCommonPaths(ZkClient zkClient$8) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumersPath(), this.BrokerIdsPath(), this.BrokerTopicsPath(), this.TopicConfigChangesPath(), this.TopicConfigPath(), this.DeleteTopicsPath()}))).foreach((Function1)new Serializable(zkClient$8){
            public static final long serialVersionUID;
            private final ZkClient zkClient$8;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String path) {
                ZkUtils$.MODULE$.makeSurePersistentPathExists(this.zkClient$8, path);
            }
            {
                this.zkClient$8 = zkClient;
            }
        });
    }

    public Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String leaderAndIsrStr, String topic$1, int partition$1, Stat stat) {
        Option<Object> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    Object object;
                    option = Json$.MODULE$.parseFull(leaderAndIsrStr);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object m = object = some.x();
                    Map leaderIsrAndEpochInfo = (Map)m;
                    int leader$1 = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader").get());
                    int epoch$1 = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader_epoch").get());
                    List isr$1 = (List)leaderIsrAndEpochInfo.get((Object)"isr").get();
                    int controllerEpoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"controller_epoch").get());
                    int zkPathVersion$1 = stat.getVersion();
                    this.debug((Function0<String>)new Serializable(topic$1, partition$1, leader$1, epoch$1, isr$1, zkPathVersion$1){
                        public static final long serialVersionUID;
                        private final String topic$1;
                        private final int partition$1;
                        private final int leader$1;
                        private final int epoch$1;
                        private final List isr$1;
                        private final int zkPathVersion$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Leader %d, Epoch %d, Isr %s, Zk path version %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader$1), BoxesRunTime.boxToInteger((int)this.epoch$1), this.isr$1.toString(), BoxesRunTime.boxToInteger((int)this.zkPathVersion$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                        }
                        {
                            this.topic$1 = string;
                            this.partition$1 = n;
                            this.leader$1 = n2;
                            this.epoch$1 = n3;
                            this.isr$1 = list;
                            this.zkPathVersion$1 = n4;
                        }
                    });
                    none$ = new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader$1, epoch$1, (List<Object>)isr$1, zkPathVersion$1), controllerEpoch));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Object> getLeaderForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block6: {
            None$ none$;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option leaderAndIsrOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string = (String)some.x();
                            String leaderAndIsr = string;
                            option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option2 instanceof Some)) break block3;
                            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)((Map)((Some)option2).x()).get((Object)"leader").get())));
                            break block4;
                        }
                        None$ none$2 = None$.MODULE$;
                        Option<Object> option3 = option2;
                        if (none$2 != null ? !none$2.equals(option3) : option3 != null) break block5;
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$3 = None$.MODULE$;
                Option option4 = option;
                if (none$3 != null ? !none$3.equals(option4) : option4 != null) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public int getEpochForPartition(ZkClient zkClient, String topic, int partition) {
        Option leaderAndIsrOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition))._1();
        Option option = leaderAndIsrOpt;
        if (option instanceof Some) {
            String string;
            Some some = (Some)option;
            String leaderAndIsr = string = (String)some.x();
            Option<Object> option2 = Json$.MODULE$.parseFull(leaderAndIsr);
            None$ none$ = None$.MODULE$;
            Option<Object> option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})));
            }
            if (option2 instanceof Some) {
                return BoxesRunTime.unboxToInt((Object)((Map)((Some)option2).x()).get((Object)"leader_epoch").get());
            }
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        Option option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})));
        }
        throw new MatchError((Object)option);
    }

    public Seq<Object> getInSyncReplicasForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block6: {
            Seq seq;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option leaderAndIsrOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string = (String)some.x();
                            String leaderAndIsr = string;
                            option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option2 instanceof Some)) break block3;
                            seq = (Seq)((Map)((Some)option2).x()).get((Object)"isr").get();
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public Seq<Object> getReplicasForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block10: {
            Seq seq;
            block6: {
                block2: {
                    Option<Object> option2;
                    block9: {
                        block3: {
                            Option option3;
                            block8: {
                                block4: {
                                    Option option4;
                                    block7: {
                                        block5: {
                                            Option jsonPartitionMapOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPath(topic))._1();
                                            option = jsonPartitionMapOpt;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string = (String)some.x();
                                            String jsonPartitionMap = string;
                                            option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            Object object = some2.x();
                                            Object m = object;
                                            option3 = ((Map)m).get((Object)"partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            Object object2 = some3.x();
                                            Object replicaMap = object2;
                                            option4 = ((Map)replicaMap).get((Object)((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
                                            if (!(option4 instanceof Some)) break block5;
                                            seq = (Seq)((Some)option4).x();
                                            break block6;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option5 = option4;
                                        if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                        seq = (Seq)Seq$.MODULE$.empty();
                                        break block6;
                                    }
                                    throw new MatchError((Object)option4);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option6 = option3;
                                if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                                seq = (Seq)Seq$.MODULE$.empty();
                                break block6;
                            }
                            throw new MatchError((Object)option3);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option7 = option2;
                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block9;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option8 = option;
                if (none$ != null ? !none$.equals(option8) : option8 != null) break block10;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public void registerBrokerInZk(ZkClient zkClient, int id$1, String host$1, int port$1, int timeout, int jmxPort) {
        String brokerIdPath$1 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)id$1)).toString();
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)SystemTime$.MODULE$.milliseconds())).toString();
        String brokerInfo = Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"host").$minus$greater((Object)host$1), Predef$.MODULE$.any2ArrowAssoc((Object)"port").$minus$greater((Object)BoxesRunTime.boxToInteger((int)port$1)), Predef$.MODULE$.any2ArrowAssoc((Object)"jmx_port").$minus$greater((Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef$.MODULE$.any2ArrowAssoc((Object)"timestamp").$minus$greater((Object)timestamp)})));
        Broker expectedBroker = new Broker(id$1, host$1, port$1);
        try {
            this.createEphemeralPathExpectConflictHandleZKBug(zkClient, brokerIdPath$1, brokerInfo, expectedBroker, (Function2<String, Object, Object>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String brokerString, Object broker) {
                    return Broker$.MODULE$.createBroker(((Broker)broker).id(), brokerString).equals((Broker)broker);
                }
            }, timeout);
            this.info((Function0<String>)new Serializable(id$1, host$1, port$1, brokerIdPath$1){
                public static final long serialVersionUID;
                private final int id$1;
                private final String host$1;
                private final int port$1;
                private final String brokerIdPath$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Registered broker %d at path %s with address %s:%d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id$1), this.brokerIdPath$1, this.host$1, BoxesRunTime.boxToInteger((int)this.port$1)}));
                }
                {
                    this.id$1 = n;
                    this.host$1 = string;
                    this.port$1 = n2;
                    this.brokerIdPath$1 = string2;
                }
            });
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)brokerIdPath$1).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
    }

    public String getConsumerPartitionOwnerPath(String group, String topic, int partition) {
        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(group, topic);
        return new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"leader").$minus$greater((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leader())), Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch").$minus$greater((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())), Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch").$minus$greater((Object)BoxesRunTime.boxToInteger((int)controllerEpoch)), Predef$.MODULE$.any2ArrowAssoc((Object)"isr").$minus$greater(leaderAndIsr.isr())})));
    }

    public String replicaAssignmentZkData(Map<String, Seq<Object>> map) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater(map)})));
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.createEphemeral(path, (Object)data);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path$4, String data$3) {
        ObjectRef storedData$1;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path$4, data$3);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData$1 = new ObjectRef(null);
                try {
                    storedData$1.elem = (String)this.readData(client, path$4)._1();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData$1.elem == null) break block6;
                String string = (String)storedData$1.elem;
                String string2 = data$3;
                if (string != null ? !string.equals(string2) : string2 != null) break block6;
                this.info((Function0<String>)new Serializable(path$4, data$3){
                    public static final long serialVersionUID;
                    private final String path$4;
                    private final String data$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)this.path$4).append((Object)" exists with value ").append((Object)this.data$3).append((Object)" during connection loss; this is ok").toString();
                    }
                    {
                        this.path$4 = string;
                        this.data$3 = string2;
                    }
                });
            }
            return;
        }
        this.info((Function0<String>)new Serializable(path$4, data$3, storedData$1){
            public static final long serialVersionUID;
            private final String path$4;
            private final String data$3;
            private final ObjectRef storedData$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"conflict in ").append((Object)this.path$4).append((Object)" data: ").append((Object)this.data$3).append((Object)" stored data: ").append((Object)((String)this.storedData$1.elem)).toString();
            }
            {
                this.path$4 = string;
                this.data$3 = string2;
                this.storedData$1 = objectRef;
            }
        });
        throw zkNodeExistsException2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createEphemeralPathExpectConflictHandleZKBug(ZkClient zkClient, String path$2, String data$2, Object expectedCallerData, Function2<String, Object, Object> checker, int backoffTime) {
        this.createEphemeralPathExpectConflict(zkClient, path$2, data$2);
        return;
    }

    public void createPersistentPath(ZkClient client, String path, String data) {
        try {
            client.createPersistent(path, (Object)data);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createPersistent(path, (Object)data);
        }
    }

    public String createPersistentPath$default$3() {
        return "";
    }

    public String createSequentialPersistentPath(ZkClient client, String path, String data) {
        return client.createPersistentSequential(path, (Object)data);
    }

    public String createSequentialPersistentPath$default$3() {
        return "";
    }

    public void updatePersistentPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, (Object)data);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, (Object)data);
            }
        }
    }

    public Tuple2<Object, Object> conditionalUpdatePersistentPath(ZkClient client, String path$1, String data$1, int expectVersion$1) {
        Tuple2 exceptionResult1 = null;
        try {
            Stat stat$1 = client.writeDataReturnStat(path$1, (Object)data$1, expectVersion$1);
            this.debug((Function0<String>)new Serializable(path$1, data$1, expectVersion$1, stat$1){
                public static final long serialVersionUID;
                private final String path$1;
                private final String data$1;
                private final int expectVersion$1;
                private final Stat stat$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, this.data$1, BoxesRunTime.boxToInteger((int)this.expectVersion$1), BoxesRunTime.boxToInteger((int)this.stat$1.getVersion())}));
                }
                {
                    this.path$1 = string;
                    this.data$1 = string2;
                    this.expectVersion$1 = n;
                    this.stat$1 = stat;
                }
            });
            exceptionResult1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)stat$1.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(path$1, data$1, expectVersion$1, exception){
                public static final long serialVersionUID;
                private final String path$1;
                private final String data$1;
                private final int expectVersion$1;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, this.data$1, BoxesRunTime.boxToInteger((int)this.expectVersion$1), this.e$1.getMessage()}));
                }
                {
                    this.path$1 = string;
                    this.data$1 = string2;
                    this.expectVersion$1 = n;
                    this.e$1 = exception;
                }
            });
            exceptionResult1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        return exceptionResult1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Object, Object> conditionalUpdatePersistentPathIfExists(ZkClient client, String path$5, String data$4, int expectVersion$2) {
        Tuple2 exceptionResult2 = null;
        try {
            Stat stat$2 = client.writeDataReturnStat(path$5, (Object)data$4, expectVersion$2);
            this.debug((Function0<String>)new Serializable(path$5, data$4, expectVersion$2, stat$2){
                public static final long serialVersionUID;
                private final String path$5;
                private final String data$4;
                private final int expectVersion$2;
                private final Stat stat$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with value %s and expected version %d succeeded, returning the new version: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$5, this.data$4, BoxesRunTime.boxToInteger((int)this.expectVersion$2), BoxesRunTime.boxToInteger((int)this.stat$2.getVersion())}));
                }
                {
                    this.path$5 = string;
                    this.data$4 = string2;
                    this.expectVersion$2 = n;
                    this.stat$2 = stat;
                }
            });
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)stat$2.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(path$5, data$4, expectVersion$2, exception){
                public static final long serialVersionUID;
                private final String path$5;
                private final String data$4;
                private final int expectVersion$2;
                private final Exception e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Conditional update of path %s with data %s and expected version %d failed due to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$5, this.data$4, BoxesRunTime.boxToInteger((int)this.expectVersion$2), this.e$2.getMessage()}));
                }
                {
                    this.path$5 = string;
                    this.data$4 = string2;
                    this.expectVersion$2 = n;
                    this.e$2 = exception;
                }
            });
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean deletePath(ZkClient client, String path$3) {
        void var3_3;
        boolean exceptionResult3 = false;
        try {
            exceptionResult3 = client.delete(path$3);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new Serializable(path$3){
                public static final long serialVersionUID;
                private final String path$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$3).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$3 = string;
                }
            });
            exceptionResult3 = false;
        }
        return (boolean)var3_3;
    }

    public void deletePathRecursive(ZkClient client, String path$6) {
        try {
            client.deleteRecursive(path$6);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new Serializable(path$6){
                public static final long serialVersionUID;
                private final String path$6;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.path$6).append((Object)" deleted during connection loss; this is ok").toString();
                }
                {
                    this.path$6 = string;
                }
            });
        }
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public Tuple2<String, Stat> readData(ZkClient client, String path) {
        Stat stat = new Stat();
        String dataStr = (String)client.readData(path, stat);
        return new Tuple2((Object)dataStr, (Object)stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient client, String path) {
        Stat stat = new Stat();
        Tuple2 exceptionResult4 = null;
        try {
            exceptionResult4 = new Tuple2((Object)new Some(client.readData(path, stat)), (Object)stat);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            exceptionResult4 = new Tuple2((Object)None$.MODULE$, (Object)stat);
        }
        Tuple2 dataAndStat = exceptionResult4;
        return dataAndStat;
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        Buffer exceptionResult5 = null;
        try {
            exceptionResult5 = JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
            return exceptionResult5;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$5) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$5, this.BrokerIdsPath());
        nodes.foreach((Function1)new Serializable(zkClient$5, cluster$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$5;
            private final Cluster cluster$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Broker> apply(String node) {
                String brokerZKString = (String)ZkUtils$.MODULE$.readData(this.zkClient$5, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)node).toString())._1();
                return this.cluster$1.add(Broker$.MODULE$.createBroker(Predef$.MODULE$.augmentString(node).toInt(), brokerZKString));
            }
            {
                this.zkClient$5 = zkClient;
                this.cluster$1 = cluster;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient$7, Set<TopicAndPartition> topicAndPartitions) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topicAndPartitions.foreach((Function1)new Serializable(zkClient$7, ret$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$7;
            private final HashMap ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(TopicAndPartition topicAndPartition) {
                Option<LeaderIsrAndControllerEpoch> option;
                block4: {
                    Option option2;
                    block3: {
                        block2: {
                            option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkClient$7, topicAndPartition.topic(), topicAndPartition.partition());
                            if (!(option instanceof Some)) break block2;
                            option2 = this.ret$1.put((Object)topicAndPartition, ((Some)option).x());
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<LeaderIsrAndControllerEpoch> option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                        option2 = BoxedUnit.UNIT;
                    }
                    return option2;
                }
                throw new MatchError(option);
            }
            {
                this.zkClient$7 = zkClient;
                this.ret$1 = hashMap;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> getReplicaAssignmentForTopics(ZkClient zkClient$1, Seq<String> topics) {
        void var3_3;
        HashMap ret$2 = new HashMap();
        topics.foreach((Function1)new Serializable(zkClient$1, ret$2){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;
            public final HashMap ret$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String topic$2) {
                Option option;
                block12: {
                    block11: {
                        block10: {
                            Option jsonPartitionMapOpt = (Option)ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$1, ZkUtils$.MODULE$.getTopicPath(topic$2))._1();
                            option = jsonPartitionMapOpt;
                            if (!(option instanceof Some)) break block10;
                            Some some = (Some)option;
                            String string = (String)some.x();
                            String jsonPartitionMap = string;
                            Option<Object> option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                            if (option2 instanceof Some) {
                                Some some2 = (Some)option2;
                                Object object = some2.x();
                                Object m = object;
                                Option option3 = ((Map)m).get((Object)"partitions");
                                if (option3 instanceof Some) {
                                    Object object2;
                                    Some some3 = (Some)option3;
                                    Object repl = object2 = some3.x();
                                    Map replicaMap = (Map)repl;
                                    ((IterableLike)replicaMap.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(Tuple2<String, Seq<Object>> tuple2) {
                                            Tuple2<String, Seq<Object>> tuple22 = tuple2;
                                            return tuple22 != null;
                                        }
                                    })).foreach((Function1)new Serializable(this, topic$2){
                                        public static final long serialVersionUID;
                                        private final anonfun.getReplicaAssignmentForTopics.1 $outer;
                                        public final String topic$2;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final void apply(Tuple2<String, Seq<Object>> tuple2) {
                                            Tuple2<String, Seq<Object>> tuple22 = tuple2;
                                            if (tuple22 != null) {
                                                String string = (String)tuple22._1();
                                                Seq seq = (Seq)tuple22._2();
                                                String partition$2 = string;
                                                Seq replicas$1 = seq;
                                                this.$outer.ret$2.put((Object)new TopicAndPartition(this.topic$2, Predef$.MODULE$.augmentString(partition$2).toInt()), (Object)replicas$1);
                                                ZkUtils$.MODULE$.debug((Function0<String>)new Serializable(this, partition$2, replicas$1){
                                                    public static final long serialVersionUID;
                                                    private final anonfun$getReplicaAssignmentForTopics$1$$anonfun$apply$3 $outer;
                                                    private final String partition$2;
                                                    private final Seq replicas$1;

                                                    static {
                                                        long l = serialVersionUID = 0L;
                                                    }

                                                    public final String apply() {
                                                        return Predef$.MODULE$.augmentString("Replicas assigned to topic [%s], partition [%s] are [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, this.partition$2, this.replicas$1}));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.partition$2 = string;
                                                        this.replicas$1 = seq;
                                                    }
                                                });
                                                return;
                                            }
                                            throw new MatchError(tuple22);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topic$2 = string;
                                        }
                                    });
                                } else {
                                    None$ none$ = None$.MODULE$;
                                    Option option4 = option3;
                                    if (none$ == null ? option4 != null : !none$.equals(option4)) {
                                        throw new MatchError((Object)option3);
                                    }
                                }
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option<Object> option5 = option2;
                                if (none$ == null ? option5 != null : !none$.equals(option5)) {
                                    throw new MatchError(option2);
                                }
                            }
                            break block11;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option6 = option;
                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block12;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$1 = zkClient;
                this.ret$2 = hashMap;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> getPartitionAssignmentForTopics(ZkClient zkClient$2, Seq<String> topics) {
        void var3_3;
        HashMap ret$3 = new HashMap();
        topics.foreach((Function1)new Serializable(zkClient$2, ret$3){
            public static final long serialVersionUID;
            private final ZkClient zkClient$2;
            private final HashMap ret$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final HashMap<String, Map<Object, Seq<Object>>> apply(String topic$3) {
                Option option;
                block8: {
                    Map map;
                    block5: {
                        block2: {
                            Option<Object> option2;
                            block7: {
                                block3: {
                                    Option option3;
                                    block6: {
                                        block4: {
                                            Object object;
                                            Option jsonPartitionMapOpt = (Option)ZkUtils$.MODULE$.readDataMaybeNull(this.zkClient$2, ZkUtils$.MODULE$.getTopicPath(topic$3))._1();
                                            option = jsonPartitionMapOpt;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string = (String)some.x();
                                            String jsonPartitionMap = string;
                                            option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            Object object2 = some2.x();
                                            Object m = object2;
                                            option3 = ((Map)m).get((Object)"partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            Object replicaMap = object = some3.x();
                                            Map m1 = (Map)replicaMap;
                                            map = (Map)m1.map((Function1)new Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final Tuple2<Object, Seq<Object>> apply(Tuple2<String, Seq<Object>> p) {
                                                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString((String)p._1()).toInt()), p._2());
                                                }
                                            }, scala.collection.Map$.MODULE$.canBuildFrom());
                                            break block5;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option4 = option3;
                                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                                        map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                                        break block5;
                                    }
                                    throw new MatchError((Object)option3);
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Object> option5 = option2;
                                if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                                break block5;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option option6 = option;
                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                        map = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    Map partitionMap$1 = map;
                    ZkUtils$.MODULE$.debug((Function0<String>)new Serializable(this, topic$3, partitionMap$1){
                        public static final long serialVersionUID;
                        private final String topic$3;
                        private final Map partitionMap$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Partition map for /brokers/topics/%s is %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, this.partitionMap$1}));
                        }
                        {
                            this.topic$3 = string;
                            this.partitionMap$1 = map;
                        }
                    });
                    return this.ret$3.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)topic$3).$minus$greater((Object)partitionMap$1));
                }
                throw new MatchError((Object)option);
            }
            {
                this.zkClient$2 = zkClient;
                this.ret$3 = hashMap;
            }
        });
        return var3_3;
    }

    public scala.collection.mutable.Map<String, Seq<Object>> getPartitionsForTopics(ZkClient zkClient, Seq<String> topics) {
        return (scala.collection.mutable.Map)this.getPartitionAssignmentForTopics(zkClient, topics).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Map<Object, Seq<Object>>> topicAndPartitionMap) {
                String topic$4 = (String)topicAndPartitionMap._1();
                Map partitionMap$2 = (Map)topicAndPartitionMap._2();
                ZkUtils$.MODULE$.debug((Function0<String>)new Serializable(this, topic$4, partitionMap$2){
                    public static final long serialVersionUID;
                    private final String topic$4;
                    private final Map partitionMap$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("partition assignment of /brokers/topics/%s is %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, this.partitionMap$2}));
                    }
                    {
                        this.topic$4 = string;
                        this.partitionMap$2 = map;
                    }
                });
                return Predef$.MODULE$.any2ArrowAssoc((Object)topic$4).$minus$greater(partitionMap$2.keys().toSeq().sortWith((Function2)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(int s, int t) {
                        return this.apply$mcZII$sp(s, t);
                    }

                    public boolean apply$mcZII$sp(int v1, int v2) {
                        return v1 < v2;
                    }
                }));
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option option;
        block4: {
            scala.collection.immutable.Map map;
            block3: {
                block2: {
                    String string;
                    Option jsonPartitionMapOpt = (Option)this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = jsonPartitionMapOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String jsonPartitionMap = string = (String)some.x();
                    Map<TopicAndPartition, Seq<Object>> reassignedPartitions = this.parsePartitionReassignmentData(jsonPartitionMap);
                    map = (Map)reassignedPartitions.map((Function1)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Tuple2<TopicAndPartition, ReassignedPartitionsContext> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                            return Predef$.MODULE$.any2ArrowAssoc(p._1()).$minus$greater((Object)new ReassignedPartitionsContext((Seq<Object>)((Seq)p._2()), ReassignedPartitionsContext$.MODULE$.init$default$2()));
                        }
                    }, scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                map = scala.collection.Map$.MODULE$.empty();
            }
            return map;
        }
        throw new MatchError((Object)option);
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        Option<Object> option;
        block9: {
            scala.collection.mutable.Map reassignedPartitions$1;
            block8: {
                block7: {
                    reassignedPartitions$1 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object object = some.x();
                    Object m = object;
                    Option option2 = ((Map)m).get((Object)"partitions");
                    if (option2 instanceof Some) {
                        ((Seq)((Some)option2).x()).foreach((Function1)new Serializable(reassignedPartitions$1){
                            public static final long serialVersionUID;
                            private final scala.collection.mutable.Map reassignedPartitions$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> apply(Map<String, Object> p) {
                                String topic = (String)p.get((Object)"topic").get();
                                int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                                Seq newReplicas = (Seq)p.get((Object)"replicas").get();
                                return (scala.collection.mutable.Map)this.reassignedPartitions$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, partition)).$minus$greater((Object)newReplicas));
                            }
                            {
                                this.reassignedPartitions$1 = map;
                            }
                        });
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError((Object)option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return reassignedPartitions$1;
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block9: {
            ObjectRef topics$1;
            block8: {
                block7: {
                    topics$1 = new ObjectRef((Object)List$.MODULE$.empty());
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object object = some.x();
                    Object m = object;
                    Option option2 = ((Map)m).get((Object)"topics");
                    if (option2 instanceof Some) {
                        Object object2;
                        Some some2 = (Some)option2;
                        Object partitionsSeq = object2 = some2.x();
                        Seq mapPartitionSeq = (Seq)partitionsSeq;
                        mapPartitionSeq.foreach((Function1)new Serializable(topics$1){
                            public static final long serialVersionUID;
                            private final ObjectRef topics$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(Map<String, Object> p) {
                                String topic = (String)p.get((Object)"topic").get();
                                this.topics$1.elem = (List)((List)this.topics$1.elem).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), List$.MODULE$.canBuildFrom());
                            }
                            {
                                this.topics$1 = objectRef;
                            }
                        });
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError((Object)option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return (List)topics$1.elem;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater(partitionsToBeReassigned.map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Map<String, Object> apply(Tuple2<TopicAndPartition, Seq<Object>> e) {
                return (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"topic").$minus$greater((Object)((TopicAndPartition)e._1()).topic()), Predef$.MODULE$.any2ArrowAssoc((Object)"partition").$minus$greater((Object)BoxesRunTime.boxToInteger((int)((TopicAndPartition)e._1()).partition())), Predef$.MODULE$.any2ArrowAssoc((Object)"replicas").$minus$greater(e._2())}));
            }
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        String zkPath$1 = this.ReassignPartitionsPath();
        int n = partitionsToBeReassigned.size();
        if (n == 0) {
            this.deletePath(zkClient, zkPath$1);
            this.info((Function0<String>)new Serializable(zkPath$1){
                public static final long serialVersionUID;
                private final String zkPath$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("No more partitions need to be reassigned. Deleting zk path %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkPath$1}));
                }
                {
                    this.zkPath$1 = string;
                }
            });
        } else {
            String jsonData$1 = this.getPartitionReassignmentZkData(partitionsToBeReassigned);
            try {
                this.updatePersistentPath(zkClient, zkPath$1, jsonData$1);
                this.info((Function0<String>)new Serializable(jsonData$1){
                    public static final long serialVersionUID;
                    private final String jsonData$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Updated partition reassignment path with %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonData$1}));
                    }
                    {
                        this.jsonData$1 = string;
                    }
                });
            }
            catch (Throwable throwable) {
                throw new AdminOperationException(throwable.toString());
            }
            catch (ZkNoNodeException zkNoNodeException) {
                this.createPersistentPath(zkClient, zkPath$1, jsonData$1);
                this.debug((Function0<String>)new Serializable(zkPath$1, jsonData$1){
                    public static final long serialVersionUID;
                    private final String zkPath$1;
                    private final String jsonData$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Created path %s with %s for partition reassignment").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkPath$1, this.jsonData$1}));
                    }
                    {
                        this.zkPath$1 = string;
                        this.jsonData$1 = string2;
                    }
                });
            }
        }
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option option;
        block4: {
            Set set;
            block3: {
                block2: {
                    Option jsonPartitionListOpt = (Option)this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = jsonPartitionListOpt;
                    if (!(option instanceof Some)) break block2;
                    set = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData((String)((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                set = Set$.MODULE$.empty();
            }
            return set;
        }
        throw new MatchError((Object)option);
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient$6, String group$1) {
        ZKGroupDirs dirs = new ZKGroupDirs(group$1);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient$6, dirs.consumerRegistryDir());
        HashMap consumersPerTopicMap$1 = new HashMap();
        consumers.foreach((Function1)new Serializable(zkClient$6, group$1, consumersPerTopicMap$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$6;
            private final String group$1;
            public final HashMap consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String consumer) {
                TopicCount topicCount = TopicCount$.MODULE$.constructTopicCount(this.group$1, consumer, this.zkClient$6);
                ((IterableLike)topicCount.getConsumerThreadIdsPerTopic().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<String, Set<String>> tuple2) {
                        Tuple2<String, Set<String>> tuple22 = tuple2;
                        return tuple22 != null;
                    }
                })).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.getConsumersPerTopic.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<String, Set<String>> tuple2) {
                        Tuple2<String, Set<String>> tuple22 = tuple2;
                        if (tuple22 != null) {
                            String string;
                            String topic$5 = string = (String)tuple22._1();
                            ((IterableLike)tuple22._2()).foreach((Function1)new Serializable(this, topic$5){
                                public static final long serialVersionUID;
                                private final anonfun$getConsumersPerTopic$1$$anonfun$apply$8 $outer;
                                private final String topic$5;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Option<List<String>> apply(String consumerThreadId) {
                                    Option option;
                                    Option option2 = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.get((Object)this.topic$5);
                                    if (option2 instanceof Some) {
                                        String string = consumerThreadId;
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put((Object)this.topic$5, (Object)((List)((Some)option2).x()).$colon$colon((Object)string));
                                    } else {
                                        option = this.$outer.kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer().consumersPerTopicMap$1.put((Object)this.topic$5, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{consumerThreadId})));
                                    }
                                    return option;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topic$5 = string;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public anonfun.getConsumersPerTopic.1 kafka$utils$ZkUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.zkClient$6 = zkClient;
                this.group$1 = string;
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        ((HashMap)consumersPerTopicMap$1.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, List<String>> tuple2) {
                Tuple2<String, List<String>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(consumersPerTopicMap$1){
            public static final long serialVersionUID;
            private final HashMap consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<List<String>> apply(Tuple2<String, List<String>> tuple2) {
                Tuple2<String, List<String>> tuple22 = tuple2;
                if (tuple22 != null) {
                    return this.consumersPerTopicMap$1.put(tuple22._1(), ((SeqLike)tuple22._2()).sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(String s, String t) {
                            return Predef$.MODULE$.augmentString(s).$less((Object)t);
                        }
                    }));
                }
                throw new MatchError(tuple22);
            }
            {
                this.consumersPerTopicMap$1 = hashMap;
            }
        });
        return consumersPerTopicMap$1;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int brokerId) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = (Option)this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    some = new Some((Object)Broker$.MODULE$.createBroker(brokerId, (String)((Some)option).x()));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq topics = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return topics == null ? (Seq)Seq$.MODULE$.empty() : topics;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient$3) {
        Seq<String> topics = this.getChildrenParentMayNotExist(zkClient$3, this.BrokerTopicsPath());
        return topics == null ? Set$.MODULE$.empty() : ((TraversableOnce)((GenericTraversableTemplate)topics.map((Function1)new Serializable(zkClient$3){
            public static final long serialVersionUID;
            private final ZkClient zkClient$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<TopicAndPartition> apply(String topic$6) {
                return (Seq)((TraversableLike)ZkUtils$.MODULE$.getChildren(this.zkClient$3, ZkUtils$.MODULE$.getTopicPartitionsPath(topic$6)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(String string) {
                        return Predef$.MODULE$.augmentString(string).toInt();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, topic$6){
                    public static final long serialVersionUID;
                    private final String topic$6;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(int n) {
                        return new TopicAndPartition(this.topic$6, n);
                    }
                    {
                        this.topic$6 = string;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.zkClient$3 = zkClient;
            }
        }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms())).toSet();
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.TopicConfigPath = "/config/topics";
        this.TopicConfigChangesPath = "/config/changes";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
    }
}

