/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.InvalidTopicException;
import kafka.server.OffsetManager$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Topic$
implements ScalaObject {
    public static final Topic$ MODULE$;
    private final String legalChars;
    private final int maxNameLength;
    private final Regex rgx;
    private final Set<String> InternalTopics;

    static {
        new Topic$();
    }

    public String legalChars() {
        return this.legalChars;
    }

    private int maxNameLength() {
        return this.maxNameLength;
    }

    private Regex rgx() {
        return this.rgx;
    }

    public Set<String> InternalTopics() {
        return this.InternalTopics;
    }

    public void validate(String topic) {
        if (topic.length() <= 0) {
            throw new InvalidTopicException("topic name is illegal, can't be empty");
        }
        if (topic.equals(".") || topic.equals("..")) {
            throw new InvalidTopicException("topic name cannot be \".\" or \"..\"");
        }
        if (topic.length() > this.maxNameLength()) {
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name is illegal, can't be longer than ").append((Object)BoxesRunTime.boxToInteger((int)this.maxNameLength())).append((Object)" characters").toString());
        }
        Option option = this.rgx().findFirstIn((CharSequence)topic);
        if (option instanceof Some) {
            if (((String)((Some)option).x()).equals(topic)) {
                return;
            }
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name ").append((Object)topic).append((Object)" is illegal, contains a character other than ASCII alphanumerics, '.', '_' and '-'").toString());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name ").append((Object)topic).append((Object)" is illegal,  contains a character other than ASCII alphanumerics, '.', '_' and '-'").toString());
        }
        throw new MatchError((Object)option);
    }

    private Topic$() {
        MODULE$ = this;
        this.legalChars = "[a-zA-Z0-9\\._\\-]";
        this.maxNameLength = 255;
        this.rgx = new Regex(new StringBuilder().append((Object)this.legalChars()).append((Object)"+").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.InternalTopics = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{OffsetManager$.MODULE$.OffsetsTopicName()}));
    }
}

