/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import kafka.common.OffsetAndMetadata;
import kafka.common.TopicAndPartition;
import kafka.server.GroupTopicPartition;
import kafka.server.OffsetManager;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetManager$
implements ScalaObject {
    public static final OffsetManager$ MODULE$;
    private final String OffsetsTopicName;
    private final short CURRENT_OFFSET_SCHEMA_VERSION;
    private final Schema OFFSET_COMMIT_KEY_SCHEMA_V0;
    private final Field KEY_GROUP_FIELD;
    private final Field KEY_TOPIC_FIELD;
    private final Field KEY_PARTITION_FIELD;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private final Field VALUE_OFFSET_FIELD;
    private final Field VALUE_METADATA_FIELD;
    private final Field VALUE_TIMESTAMP_FIELD;
    private final Map<Object, OffsetManager.KeyAndValueSchemas> OFFSET_SCHEMAS;
    private final OffsetManager.KeyAndValueSchemas CURRENT_SCHEMA;

    static {
        new OffsetManager$();
    }

    public String OffsetsTopicName() {
        return this.OffsetsTopicName;
    }

    private short CURRENT_OFFSET_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA_V0() {
        return this.OFFSET_COMMIT_KEY_SCHEMA_V0;
    }

    private Field KEY_GROUP_FIELD() {
        return this.KEY_GROUP_FIELD;
    }

    private Field KEY_TOPIC_FIELD() {
        return this.KEY_TOPIC_FIELD;
    }

    private Field KEY_PARTITION_FIELD() {
        return this.KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private Field VALUE_OFFSET_FIELD() {
        return this.VALUE_OFFSET_FIELD;
    }

    private Field VALUE_METADATA_FIELD() {
        return this.VALUE_METADATA_FIELD;
    }

    private Field VALUE_TIMESTAMP_FIELD() {
        return this.VALUE_TIMESTAMP_FIELD;
    }

    private Map<Object, OffsetManager.KeyAndValueSchemas> OFFSET_SCHEMAS() {
        return this.OFFSET_SCHEMAS;
    }

    private OffsetManager.KeyAndValueSchemas CURRENT_SCHEMA() {
        return this.CURRENT_SCHEMA;
    }

    private OffsetManager.KeyAndValueSchemas schemaFor(int version) {
        Option schemaOpt = this.OFFSET_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (option instanceof Some) {
            return (OffsetManager.KeyAndValueSchemas)((Some)option).x();
        }
        throw new KafkaException(new StringBuilder().append((Object)"Unknown offset schema version ").append((Object)BoxesRunTime.boxToInteger((int)version)).toString());
    }

    public byte[] offsetCommitKey(String group, String topic, int partition, short versionId) {
        Struct key = new Struct(this.CURRENT_SCHEMA().keySchema());
        key.set(this.KEY_GROUP_FIELD(), (Object)group);
        key.set(this.KEY_TOPIC_FIELD(), (Object)topic);
        key.set(this.KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger((int)partition));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public short offsetCommitKey$default$4() {
        return 0;
    }

    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata) {
        Struct value2 = new Struct(this.CURRENT_SCHEMA().valueSchema());
        value2.set(this.VALUE_OFFSET_FIELD(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
        value2.set(this.VALUE_METADATA_FIELD(), (Object)offsetAndMetadata.metadata());
        value2.set(this.VALUE_TIMESTAMP_FIELD(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.timestamp()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_SCHEMA_VERSION());
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public GroupTopicPartition readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Schema keySchema = this.schemaFor(version).keySchema();
        Struct key = (Struct)keySchema.read(buffer);
        String group = (String)key.get(this.KEY_GROUP_FIELD());
        String topic = (String)key.get(this.KEY_TOPIC_FIELD());
        int partition = BoxesRunTime.unboxToInt((Object)key.get(this.KEY_PARTITION_FIELD()));
        return new GroupTopicPartition(group, new TopicAndPartition(topic, partition));
    }

    public OffsetAndMetadata readMessageValue(ByteBuffer buffer) {
        OffsetAndMetadata offsetAndMetadata;
        if (buffer == null) {
            offsetAndMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.schemaFor(version).valueSchema();
            Struct value2 = (Struct)valueSchema.read(buffer);
            long offset = BoxesRunTime.unboxToLong((Object)value2.get(this.VALUE_OFFSET_FIELD()));
            String metadata = (String)value2.get(this.VALUE_METADATA_FIELD());
            long timestamp = BoxesRunTime.unboxToLong((Object)value2.get(this.VALUE_TIMESTAMP_FIELD()));
            offsetAndMetadata = new OffsetAndMetadata(offset, metadata, timestamp);
        }
        return offsetAndMetadata;
    }

    private OffsetManager$() {
        MODULE$ = this;
        this.OffsetsTopicName = "__consumer_offsets";
        this.CURRENT_OFFSET_SCHEMA_VERSION = (short)0;
        this.OFFSET_COMMIT_KEY_SCHEMA_V0 = new Schema(new Field[]{new Field("group", Type.STRING), new Field("topic", Type.STRING), new Field("partition", Type.INT32)});
        this.KEY_GROUP_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA_V0().get("group");
        this.KEY_TOPIC_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA_V0().get("topic");
        this.KEY_PARTITION_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA_V0().get("partition");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", Type.INT64)});
        this.VALUE_OFFSET_FIELD = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        this.VALUE_METADATA_FIELD = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        this.VALUE_TIMESTAMP_FIELD = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        this.OFFSET_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)).$minus$greater((Object)new OffsetManager.KeyAndValueSchemas(this.OFFSET_COMMIT_KEY_SCHEMA_V0(), this.OFFSET_COMMIT_VALUE_SCHEMA_V0()))}));
        this.CURRENT_SCHEMA = this.schemaFor(this.CURRENT_OFFSET_SCHEMA_VERSION());
    }
}

