/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.Whitelist;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher;
import kafka.tools.ReplicaVerificationTool$$anonfun$3$;
import kafka.tools.TopicPartitionReplica;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ToolsUtils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicaVerificationTool$
implements Logging {
    public static final ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaVerificationTool$ replicaVerificationTool$ = this;
        synchronized (replicaVerificationTool$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(SystemTime$.MODULE$.milliseconds()));
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.FetchSize()), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(30000L), (Object[])new Long[0]);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        Whitelist topicWhiteListFiler$1 = new Whitelist(regex);
        Pattern exceptionResult1 = null;
        try {
            exceptionResult1 = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder().append((Object)regex).append((Object)" is an invalid regex.").toString());
        }
        int fetchSize$1 = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs$1 = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Getting topic metatdata...";
            }
        });
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        TopicMetadataResponse topicsMetadataResponse = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), metadataTargetBrokers, this.clientId(), maxWaitMs$1, ClientUtils$.MODULE$.fetchTopicMetadata$default$5());
        Map brokerMap$1 = ((TraversableOnce)topicsMetadataResponse.brokers().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, Broker> apply(Broker b) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)b.id()), (Object)b);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Seq filteredTopicMetadata = (Seq)topicsMetadataResponse.topicsMetadata().filter((Function1)new Serializable(topicWhiteListFiler$1){
            public static final long serialVersionUID;
            private final Whitelist topicWhiteListFiler$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(TopicMetadata topicMetadata) {
                return this.topicWhiteListFiler$1.isTopicAllowed(topicMetadata.topic(), false);
            }
            {
                this.topicWhiteListFiler$1 = whitelist;
            }
        });
        Seq topicPartitionReplicaList$1 = (Seq)filteredTopicMetadata.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<TopicPartitionReplica> apply(TopicMetadata topicMetadataResponse$1) {
                return (Seq)topicMetadataResponse$1.partitionsMetadata().flatMap((Function1)new Serializable(this, topicMetadataResponse$1){
                    public static final long serialVersionUID;
                    public final TopicMetadata topicMetadataResponse$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Seq<TopicPartitionReplica> apply(PartitionMetadata partitionMetadata$1) {
                        return (Seq)partitionMetadata$1.replicas().map((Function1)new Serializable(this, partitionMetadata$1){
                            public static final long serialVersionUID;
                            private final anonfun$3$$anonfun$apply$1 $outer;
                            private final PartitionMetadata partitionMetadata$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final TopicPartitionReplica apply(Broker broker) {
                                return new TopicPartitionReplica(this.$outer.topicMetadataResponse$1.topic(), this.partitionMetadata$1.partitionId(), broker.id());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.partitionMetadata$1 = partitionMetadata;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.topicMetadataResponse$1 = topicMetadata;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new Serializable(topicPartitionReplicaList$1){
            public static final long serialVersionUID;
            private final Seq topicPartitionReplicaList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Selected topic partitions: ").append((Object)this.topicPartitionReplicaList$1).toString();
            }
            {
                this.topicPartitionReplicaList$1 = seq;
            }
        });
        Map topicAndPartitionsPerBroker$1 = (Map)topicPartitionReplicaList$1.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(TopicPartitionReplica topicPartitionReplica) {
                return topicPartitionReplica.replicaId();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, Seq<TopicAndPartition>> apply(Tuple2<Object, Seq<TopicPartitionReplica>> tuple2) {
                Tuple2<Object, Seq<TopicPartitionReplica>> tuple22 = tuple2;
                if (tuple22 != null) {
                    return Predef$.MODULE$.any2ArrowAssoc(tuple22._1()).$minus$greater(((TraversableLike)tuple22._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final TopicAndPartition apply(TopicPartitionReplica topicPartitionReplica) {
                            TopicPartitionReplica topicPartitionReplica2;
                            TopicPartitionReplica partition = topicPartitionReplica2 = topicPartitionReplica;
                            return new TopicAndPartition(partition.topic(), partition.partitionId());
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                }
                throw new MatchError(tuple22);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new Serializable(topicAndPartitionsPerBroker$1){
            public static final long serialVersionUID;
            private final Map topicAndPartitionsPerBroker$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Topic partitions per broker: ").append((Object)this.topicAndPartitionsPerBroker$1).toString();
            }
            {
                this.topicAndPartitionsPerBroker$1 = map;
            }
        });
        Map expectedReplicasPerTopicAndPartition$1 = (Map)topicPartitionReplicaList$1.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TopicAndPartition apply(TopicPartitionReplica replica) {
                return new TopicAndPartition(replica.topic(), replica.partitionId());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, Seq<TopicPartitionReplica>> tuple2) {
                Tuple2<TopicAndPartition, Seq<TopicPartitionReplica>> tuple22 = tuple2;
                if (tuple22 != null) {
                    return Predef$.MODULE$.any2ArrowAssoc(tuple22._1()).$minus$greater((Object)BoxesRunTime.boxToInteger((int)((SeqLike)tuple22._2()).size()));
                }
                throw new MatchError(tuple22);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new Serializable(expectedReplicasPerTopicAndPartition$1){
            public static final long serialVersionUID;
            private final Map expectedReplicasPerTopicAndPartition$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Expected replicas per topic partition: ").append((Object)this.expectedReplicasPerTopicAndPartition$1).toString();
            }
            {
                this.expectedReplicasPerTopicAndPartition$1 = map;
            }
        });
        Map leadersPerBroker$1 = ((TraversableLike)filteredTopicMetadata.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Tuple2<TopicAndPartition, Object>> apply(TopicMetadata topicMetadataResponse$2) {
                return (Seq)topicMetadataResponse$2.partitionsMetadata().map((Function1)new Serializable(this, topicMetadataResponse$2){
                    public static final long serialVersionUID;
                    private final TopicMetadata topicMetadataResponse$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, Object> apply(PartitionMetadata partitionMetadata) {
                        return new Tuple2((Object)new TopicAndPartition(this.topicMetadataResponse$2.topic(), partitionMetadata.partitionId()), (Object)BoxesRunTime.boxToInteger((int)((Broker)partitionMetadata.leader().get()).id()));
                    }
                    {
                        this.topicMetadataResponse$2 = topicMetadata;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Tuple2<TopicAndPartition, Object> tuple2) {
                return tuple2._2$mcI$sp();
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<TopicAndPartition> apply(Seq<Tuple2<TopicAndPartition, Object>> topicAndPartitionAndLeaderIds) {
                return (Seq)topicAndPartitionAndLeaderIds.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Object> tuple2) {
                        Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return (TopicAndPartition)tuple22._1();
                        }
                        throw new MatchError(tuple22);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
        this.debug((Function0<String>)new Serializable(leadersPerBroker$1){
            public static final long serialVersionUID;
            private final Map leadersPerBroker$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Leaders per broker: ").append((Object)this.leadersPerBroker$1).toString();
            }
            {
                this.leadersPerBroker$1 = map;
            }
        });
        ReplicaBuffer replicaBuffer$1 = new ReplicaBuffer((Map<TopicAndPartition, Object>)expectedReplicasPerTopicAndPartition$1, (Map<Object, Seq<TopicAndPartition>>)leadersPerBroker$1, topicAndPartitionsPerBroker$1.size(), (Map<Object, Broker>)brokerMap$1, initialOffsetTime, reportInterval);
        int verificationBrokerId$1 = ((Tuple2)topicAndPartitionsPerBroker$1.head())._1$mcI$sp();
        Iterable fetcherThreads$1 = (Iterable)topicAndPartitionsPerBroker$1.map((Function1)new Serializable(fetchSize$1, maxWaitMs$1, brokerMap$1, replicaBuffer$1, verificationBrokerId$1){
            public static final long serialVersionUID;
            private final int fetchSize$1;
            private final int maxWaitMs$1;
            private final Map brokerMap$1;
            private final ReplicaBuffer replicaBuffer$1;
            private final int verificationBrokerId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ReplicaFetcher apply(Tuple2<Object, Seq<TopicAndPartition>> tuple2) {
                Tuple2<Object, Seq<TopicAndPartition>> tuple22 = tuple2;
                if (tuple22 != null) {
                    int n;
                    int brokerId = n = BoxesRunTime.unboxToInt((Object)tuple22._1());
                    return new ReplicaFetcher(new StringBuilder().append((Object)"ReplicaFetcher-").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString(), (Broker)this.brokerMap$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Iterable<TopicAndPartition>)((Iterable)tuple22._2()), this.replicaBuffer$1, 30000, 256000, this.fetchSize$1, this.maxWaitMs$1, 1, brokerId == this.verificationBrokerId$1);
                }
                throw new MatchError(tuple22);
            }
            {
                this.fetchSize$1 = n;
                this.maxWaitMs$1 = n2;
                this.brokerMap$1 = map;
                this.replicaBuffer$1 = replicaBuffer;
                this.verificationBrokerId$1 = n3;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Runtime.getRuntime().addShutdownHook(new Thread(fetcherThreads$1){
            private final Iterable fetcherThreads$1;

            public void run() {
                ReplicaVerificationTool$.MODULE$.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Stopping all fetchers";
                    }
                });
                this.fetcherThreads$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ReplicaFetcher replicaFetcher) {
                        replicaFetcher.shutdown();
                    }
                });
            }
            {
                this.fetcherThreads$1 = iterable;
            }
        });
        fetcherThreads$1.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ReplicaFetcher replicaFetcher) {
                replicaFetcher.start();
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)this.getCurrentTimeString()).append((Object)": verification process is started.").toString());
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

