/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import org.apache.karaf.jaas.modules.publickey.PublickeyCallback;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafJaasAuthenticator
implements PasswordAuthenticator,
PublickeyAuthenticator {
    public static final Session.AttributeKey<Subject> SUBJECT_ATTRIBUTE_KEY = new Session.AttributeKey();
    private final Logger LOGGER = LoggerFactory.getLogger(KarafJaasAuthenticator.class);
    private String realm;
    private String role;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean authenticate(final String username, final String password, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            if (this.role != null && this.role.length() > 0) {
                String clazz = "org.apache.karaf.jaas.boot.principal.RolePrincipal";
                String name = this.role;
                int idx = this.role.indexOf(58);
                if (idx > 0) {
                    clazz = this.role.substring(0, idx);
                    name = this.role.substring(idx + 1);
                }
                boolean found = false;
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getClass().getName().equals(clazz) || !p.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new FailedLoginException("User does not have the required role " + this.role);
                }
            }
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.warn("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean authenticate(final String username, final PublicKey key, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PublickeyCallback) {
                            ((PublickeyCallback)callback).setPublicKey(key);
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            if (this.role != null && this.role.length() > 0) {
                String clazz = "org.apache.karaf.jaas.boot.principal.RolePrincipal";
                String name = this.role;
                int idx = this.role.indexOf(58);
                if (idx > 0) {
                    clazz = this.role.substring(0, idx);
                    name = this.role.substring(idx + 1);
                }
                boolean found = false;
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getClass().getName().equals(clazz) || !p.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new FailedLoginException("User does not have the required role " + this.role);
                }
            }
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.warn("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

