/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.ssh.SshTerminal;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.osgi.service.blueprint.container.ReifiedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellFactoryImpl
implements Factory<Command> {
    private CommandProcessor commandProcessor;

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public Command create() {
        return new ShellImpl();
    }

    private static void flush(OutputStream ... streams) {
        for (OutputStream s : streams) {
            try {
                s.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static Converter getConverter() {
        return new Converter();
    }

    public class LfToCrLfFilterOutputStream
    extends FilterOutputStream {
        private boolean lastWasCr;

        public LfToCrLfFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (!this.lastWasCr && b == 10) {
                this.out.write(13);
                this.out.write(10);
            } else {
                this.out.write(b);
            }
            this.lastWasCr = b == 13;
        }
    }

    public static class Converter
    implements org.osgi.service.blueprint.container.Converter {
        public boolean canConvert(Object sourceObject, ReifiedType targetType) {
            return ShellFactoryImpl.class.isAssignableFrom(sourceObject.getClass()) && Factory.class.equals((Object)targetType.getRawClass()) && Command.class.equals((Object)targetType.getActualTypeArgument(0).getRawClass());
        }

        public Object convert(Object sourceObject, ReifiedType targetType) throws Exception {
            return sourceObject;
        }
    }

    public class ShellImpl
    implements Command,
    SessionAware {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            try {
                SshTerminal terminal = new SshTerminal(env);
                String encoding = (String)env.getEnv().get("LC_CTYPE");
                if (encoding != null && encoding.indexOf(46) > 0) {
                    encoding = encoding.substring(encoding.indexOf(46) + 1);
                }
                Console console = new Console(ShellFactoryImpl.this.commandProcessor, this.in, new PrintStream(new LfToCrLfFilterOutputStream(this.out), true), new PrintStream(new LfToCrLfFilterOutputStream(this.err), true), (Terminal)terminal, encoding, new Runnable(){

                    public void run() {
                        ShellImpl.this.destroy();
                    }
                });
                CommandSession session = console.getSession();
                session.put("APPLICATION", (Object)System.getProperty("karaf.name", "root"));
                for (Map.Entry e : env.getEnv().entrySet()) {
                    session.put((String)e.getKey(), e.getValue());
                }
                session.put("#LINES", (Object)new Function((Terminal)terminal){
                    final /* synthetic */ Terminal val$terminal;
                    {
                        this.val$terminal = terminal;
                    }

                    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                        return Integer.toString(this.val$terminal.getHeight());
                    }
                });
                session.put("#COLUMNS", (Object)new Function((Terminal)terminal){
                    final /* synthetic */ Terminal val$terminal;
                    {
                        this.val$terminal = terminal;
                    }

                    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                        return Integer.toString(this.val$terminal.getWidth());
                    }
                });
                session.put(".jline.terminal", (Object)terminal);
                new Thread((Runnable)console){

                    public void run() {
                        Subject subject;
                        Subject subject2 = subject = ShellImpl.this.session != null ? (Subject)ShellImpl.this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                        if (subject != null) {
                            Subject.doAs(subject, new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    this.doRun();
                                    return null;
                                }
                            });
                        } else {
                            this.doRun();
                        }
                    }

                    protected void doRun() {
                        super.run();
                    }
                }.start();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to start shell").initCause(e);
            }
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.flush(new OutputStream[]{this.out, this.err});
                ShellFactoryImpl.close(new Closeable[]{this.in, this.out, this.err});
                this.callback.onExit(0);
            }
        }
    }
}

