/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.bundles.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlesSelector {
    private BundleContext bundleContext;

    public BundlesSelector(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<Bundle> selectBundles(String bundleId) throws Exception {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (bundleId != null && bundleId.length() > 0) {
            Pattern pattern = Pattern.compile("^\\d+$");
            Matcher matcher = pattern.matcher(bundleId);
            if (matcher.find()) {
                Bundle bundle = this.getBundleById(bundleId);
                bundles.add(bundle);
                return bundles;
            }
            pattern = Pattern.compile("^(\\d+)-(\\d+)$");
            matcher = pattern.matcher(bundleId);
            if (matcher.find()) {
                long stopId;
                int index = bundleId.indexOf(45);
                long startId = Long.parseLong(bundleId.substring(0, index));
                if (startId < (stopId = Long.parseLong(bundleId.substring(index + 1)))) {
                    for (long i = startId; i <= stopId; ++i) {
                        Bundle bundle = this.bundleContext.getBundle(i);
                        bundles.add(bundle);
                    }
                }
                return bundles;
            }
            int index = bundleId.indexOf(47);
            if (index != -1) {
                return this.getBundleByNameAndVersion(bundleId.substring(0, index), bundleId.substring(index + 1));
            }
            return this.getBundleByName(bundleId);
        }
        return bundles;
    }

    private Bundle getBundleById(String id) {
        Bundle bundle = null;
        try {
            long idNumber = Long.parseLong(id);
            bundle = this.bundleContext.getBundle(idNumber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bundle;
    }

    private List<Bundle> getBundleByName(String name) {
        return this.getBundleByNameAndVersion(name, null);
    }

    private List<Bundle> getBundleByNameAndVersion(String name, String version) {
        Bundle[] bundles = this.bundleContext.getBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        Pattern namePattern = Pattern.compile(name);
        for (int i = 0; i < bundles.length; ++i) {
            boolean nameMatch;
            String bundleSymbolicName = bundles[i].getSymbolicName();
            if (bundleSymbolicName == null) continue;
            Matcher symbolicNameMatcher = namePattern.matcher(bundleSymbolicName);
            Matcher nameMatcher = null;
            String bundleName = (String)bundles[i].getHeaders().get("Bundle-Name");
            if (bundleName != null) {
                nameMatcher = namePattern.matcher(bundleName);
            }
            if (version != null) {
                Pattern versionPattern;
                Matcher versionMatcher;
                boolean nameMatch2;
                String bundleVersion = (String)bundles[i].getHeaders().get("Bundle-Version");
                if (bundleVersion == null) continue;
                boolean bl = nameMatch2 = nameMatcher != null && nameMatcher.find() || symbolicNameMatcher.find();
                if (!nameMatch2 || !(versionMatcher = (versionPattern = Pattern.compile(version)).matcher(bundleVersion)).find()) continue;
                result.add(bundles[i]);
                continue;
            }
            boolean bl = nameMatch = nameMatcher != null && nameMatcher.find() || symbolicNameMatcher.find();
            if (!nameMatch) continue;
            result.add(bundles[i]);
        }
        return result;
    }
}

