/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

class StartupListener
implements FrameworkListener,
SynchronousBundleListener {
    private static final String SYSTEM_PROP_KARAF_CONSOLE_STARTED = "karaf.console.started";
    private final BundleContext context;

    StartupListener(BundleContext context) {
        this.context = context;
        context.addBundleListener(this);
        context.addFrameworkListener(this);
    }

    public synchronized void bundleChanged(BundleEvent bundleEvent) {
        Bundle[] bundles = this.context.getBundles();
        int numActive = 0;
        int numBundles = bundles.length;
        for (Bundle bundle : bundles) {
            if (bundle.getHeaders().get("Fragment-Host") != null) {
                --numBundles;
                continue;
            }
            if (bundle.getState() != 32) continue;
            ++numActive;
        }
        boolean started = Boolean.parseBoolean(System.getProperty(SYSTEM_PROP_KARAF_CONSOLE_STARTED, "false"));
        if (!started) {
            this.showProgressBar(numActive, numBundles);
        }
    }

    public synchronized void frameworkEvent(FrameworkEvent frameworkEvent) {
        if (frameworkEvent.getType() == 8) {
            int defStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
            int startLevel = this.context.getBundle(0L).adapt(FrameworkStartLevel.class).getStartLevel();
            if (startLevel >= defStartLevel) {
                this.context.removeBundleListener(this);
                this.context.removeFrameworkListener(this);
            }
        }
    }

    public void showProgressBar(int done, int total) {
        int percent = done * 100 / total;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\r%3d%% [", percent));
        for (int i = 0; i < 100; ++i) {
            if (i < percent) {
                sb.append('=');
                continue;
            }
            if (i == percent) {
                sb.append('>');
                continue;
            }
            sb.append(' ');
        }
        sb.append(']');
        System.out.print(sb.toString());
        System.out.flush();
        if (done == total) {
            System.out.println();
        }
    }
}

