/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.EnumSet;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X11ForwardSupport
extends IoHandlerAdapter {
    private static String xauthCommand = System.getProperty("sshd.xauthCommand", "xauth");
    public static final int X11_DISPLAY_OFFSET = 10;
    public static final int MAX_DISPLAYS = 1000;
    public static final String ENV_DISPLAY = "DISPLAY";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ServerSession session;
    private IoAcceptor acceptor;

    public X11ForwardSupport(ServerSession session) {
        this.session = session;
    }

    public synchronized void initialize() {
        if (this.acceptor == null) {
            NioSocketAcceptor acceptor = this.session.getServerFactoryManager().getX11ForwardingAcceptorFactory().createNioSocketAcceptor(this.session);
            acceptor.setHandler((IoHandler)this);
            acceptor.setReuseAddress(true);
            acceptor.getFilterChain().addLast("executor", (IoFilter)new ExecutorFilter(EnumSet.complementOf(EnumSet.of(IoEventType.SESSION_CREATED)).toArray(new IoEventType[0])));
            this.acceptor = acceptor;
        }
    }

    public synchronized void close() {
        if (this.acceptor != null) {
            this.acceptor.dispose();
            this.acceptor = null;
        }
    }

    public synchronized String createDisplay(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        int displayNumber;
        this.initialize();
        InetSocketAddress addr = null;
        for (displayNumber = 10; displayNumber < 1000; ++displayNumber) {
            int port = 6000 + displayNumber;
            try {
                addr = new InetSocketAddress("127.0.0.1", port);
                this.acceptor.bind(new SocketAddress[]{addr});
                break;
            }
            catch (BindException bindErr) {
                continue;
            }
        }
        if (displayNumber >= 1000) {
            this.log.error("Failed to allocate internet-domain X11 display socket.");
            if (this.acceptor.getLocalAddresses().isEmpty()) {
                this.close();
            }
            return null;
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") < 0) {
            try {
                String authDisplay = "unix:" + displayNumber + "." + screen;
                Process p = new ProcessBuilder(xauthCommand, "remove", authDisplay).start();
                int result = p.waitFor();
                if (result == 0) {
                    p = new ProcessBuilder(xauthCommand, "add", authDisplay, authenticationProtocol, authenticationCookie).start();
                    result = p.waitFor();
                }
            }
            catch (Exception e) {
                this.log.error("Could not run xauth", (Throwable)e);
                return null;
            }
            return "localhost:" + displayNumber + "." + screen;
        }
        return null;
    }

    public void sessionCreated(IoSession session) throws Exception {
        ChannelForwardedX11 channel = new ChannelForwardedX11(session);
        session.setAttribute(ChannelForwardedX11.class, (Object)channel);
        this.session.registerChannel(channel);
        OpenFuture future = (OpenFuture)channel.open().await();
        Throwable t = future.getException();
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t != null) {
            throw new Exception(t);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        if (channel != null) {
            channel.close(false);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        IoBuffer ioBuffer = (IoBuffer)message;
        int r = ioBuffer.remaining();
        byte[] b = new byte[r];
        ioBuffer.get(b, 0, r);
        channel.getOut().write(b, 0, r);
        channel.getOut().flush();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(false);
    }

    public static class ChannelForwardedX11
    extends AbstractClientChannel {
        private final IoSession serverSession;

        public ChannelForwardedX11(IoSession serverSession) {
            super("x11");
            this.serverSession = serverSession;
        }

        public synchronized OpenFuture open() throws Exception {
            InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
            if (this.closeFuture.isClosed()) {
                throw new SshException("Session has been closed");
            }
            this.openFuture = new DefaultOpenFuture(this.lock);
            this.log.info("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this.id);
            Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN, 0);
            buffer.putString(this.type);
            buffer.putInt(this.id);
            buffer.putInt(this.localWindow.getSize());
            buffer.putInt(this.localWindow.getPacketSize());
            buffer.putString(remote.getAddress().getHostAddress());
            buffer.putInt(remote.getPort());
            this.session.writePacket(buffer);
            return this.openFuture;
        }

        protected synchronized void doOpen() throws Exception {
            this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        }

        protected synchronized void doClose() {
            this.serverSession.close(false);
            super.doClose();
        }

        protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
            IoBuffer buf = IoBuffer.allocate((int)len);
            buf.put(data, off, len);
            buf.flip();
            this.localWindow.consumeAndCheck(len);
            this.serverSession.write((Object)buf);
        }

        public void handleEof() throws IOException {
            super.handleEof();
            this.serverSession.close(false);
        }
    }
}

