/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.EnumSet;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;

public abstract class FeaturesCommandSupport
implements Action {
    protected EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
    @Reference
    private FeaturesService featuresService;

    public Object execute() throws Exception {
        if (this.featuresService == null) {
            throw new IllegalStateException("FeaturesService not found");
        }
        this.doExecute(this.featuresService);
        return null;
    }

    protected abstract void doExecute(FeaturesService var1) throws Exception;

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected void addOption(FeaturesService.Option option, boolean shouldAdd) {
        if (shouldAdd) {
            this.options.add(option);
        }
    }

    protected String getFeatureId(FeaturesService admin, String nameOrId) throws Exception {
        Feature[] matchingFeatures = admin.getFeatures(nameOrId);
        if (matchingFeatures.length == 0) {
            throw new IllegalArgumentException("No matching feature found for " + nameOrId);
        }
        if (matchingFeatures.length > 1) {
            throw new IllegalArgumentException("More than one matching feature found for " + nameOrId);
        }
        return matchingFeatures[0].getId();
    }
}

