/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.dev;

import java.io.File;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="dev", name="system-property", description="Get or set a system property.")
public class SystemProperty
extends OsgiCommandSupport {
    @Option(name="-p", aliases={"--persistent"}, description="Persist the new value to the etc/system.properties file")
    boolean persistent;
    @Argument(index=0, name="key", description="The system property name")
    String key;
    @Argument(index=1, name="value", required=false, description="New value for the system property")
    String value;

    protected Object doExecute() throws Exception {
        if (this.value != null) {
            if (this.persistent) {
                String base = System.getProperty("karaf.base");
                Properties props = new Properties(new File(base, "etc/system.properties"));
                props.put(this.key, this.value);
                props.save();
            }
            return System.setProperty(this.key, this.value);
        }
        return System.getProperty(this.key);
    }
}

