/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole.http;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.karaf.http.core.ProxyService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.karaf.webconsole.http.HttpPlugin;
import org.ops4j.pax.web.service.WebContainer;

@Services(requires={@RequireService(value=WebContainer.class), @RequireService(value=ProxyService.class)})
public class Activator
extends BaseActivator {
    private HttpPlugin httpPlugin;

    @Override
    protected void doStart() throws Exception {
        ProxyService proxyService = this.getTrackedService(ProxyService.class);
        if (proxyService == null) {
            return;
        }
        WebContainer webContainer = this.getTrackedService(WebContainer.class);
        if (webContainer == null) {
            return;
        }
        this.httpPlugin = new HttpPlugin();
        this.httpPlugin.setBundleContext(this.bundleContext);
        this.httpPlugin.setWebContainer(webContainer);
        this.httpPlugin.setProxyService(proxyService);
        this.httpPlugin.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("felix.webconsole.label", "http");
        this.register(Servlet.class, this.httpPlugin, props);
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.httpPlugin != null) {
            this.httpPlugin.stop();
            this.httpPlugin = null;
        }
    }
}

