/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kudu.Common;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.ConnectToClusterResponse;
import org.apache.kudu.client.ConnectToMasterRequest;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.NoLeaderFoundException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RpcProxy;
import org.apache.kudu.client.RpcRemoteException;
import org.apache.kudu.client.Status;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.apache.kudu.rpc.RpcHeader;
import org.apache.kudu.shaded.com.google.common.base.Functions;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.util.NetUtil;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class ConnectToCluster {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectToCluster.class);
    private final List<HostAndPort> masterAddrs;
    private final Deferred<ConnectToClusterResponse> responseD;
    private final AtomicBoolean responseDCalled = new AtomicBoolean(false);
    private final AtomicInteger countResponsesReceived = new AtomicInteger(0);
    private final List<Exception> exceptionsReceived = Collections.synchronizedList(new ArrayList());
    private AtomicReference<List<Common.HostPortPB>> knownMasters = new AtomicReference();
    private int numMasters;

    ConnectToCluster(List<HostAndPort> masterAddrs) {
        this.masterAddrs = masterAddrs;
        this.responseD = new Deferred();
        this.numMasters = masterAddrs.size();
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public Deferred<ConnectToClusterResponse> getDeferred() {
        return this.responseD;
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    List<Exception> getExceptionsReceived() {
        return this.exceptionsReceived;
    }

    private static Deferred<Master.ConnectToMasterResponsePB> connectToMaster(KuduTable masterTable, final RpcProxy masterProxy, KuduRpc<?> parentRpc, Timer timer, long defaultTimeoutMs) {
        long timeoutMillis = parentRpc == null ? defaultTimeoutMs : parentRpc.timeoutTracker.getMillisBeforeTimeout();
        final ConnectToMasterRequest rpc = new ConnectToMasterRequest(masterTable, timer, timeoutMillis);
        rpc.setParentRpc(parentRpc);
        Deferred<Master.ConnectToMasterResponsePB> d = rpc.getDeferred();
        ++rpc.attempt;
        masterProxy.sendRpc(rpc);
        d.addErrback(new Callback<Deferred<Master.ConnectToMasterResponsePB>, Exception>(){

            @Override
            public Deferred<Master.ConnectToMasterResponsePB> call(Exception result) throws Exception {
                RpcRemoteException rre;
                if (result instanceof RpcRemoteException && (rre = (RpcRemoteException)result).getErrPB().getCode() == RpcHeader.ErrorStatusPB.RpcErrorCodePB.ERROR_INVALID_REQUEST && rre.getErrPB().getUnsupportedFeatureFlagsCount() > 0) {
                    AsyncKuduClient.LOG.debug("Falling back to GetMasterRegistration() RPC to connect to server running Kudu < 1.3.");
                    Deferred<Master.ConnectToMasterResponsePB> newAttempt = Preconditions.checkNotNull(rpc.getDeferred());
                    rpc.setUseOldMethod();
                    masterProxy.sendRpc(rpc);
                    return newAttempt;
                }
                return Deferred.fromError(result);
            }
        });
        return d;
    }

    public static Deferred<ConnectToClusterResponse> run(KuduTable masterTable, List<HostAndPort> masterAddresses, KuduRpc<?> parentRpc, long defaultTimeoutMs, Connection.CredentialsPolicy credentialsPolicy) {
        ConnectToCluster connector = new ConnectToCluster(masterAddresses);
        connector.connectToMasters(masterTable, parentRpc, defaultTimeoutMs, credentialsPolicy);
        return connector.responseD;
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    List<Deferred<Master.ConnectToMasterResponsePB>> connectToMasters(KuduTable masterTable, KuduRpc<?> parentRpc, long defaultTimeoutMs, Connection.CredentialsPolicy credentialsPolicy) {
        ArrayList<Deferred<Master.ConnectToMasterResponsePB>> deferreds = new ArrayList<Deferred<Master.ConnectToMasterResponsePB>>();
        ArrayList<Pair<InetAddress, HostAndPort>> masterAddrsWithNames = new ArrayList<Pair<InetAddress, HostAndPort>>();
        for (HostAndPort hostAndPort : this.masterAddrs) {
            InetAddress[] inetAddrs = NetUtil.getAllInetAddresses(hostAndPort.getHost());
            if (inetAddrs != null) {
                if (inetAddrs.length > 1) {
                    LOG.info("Specified master server address {} resolved to multiple IPs {}. Connecting to each one of them.", (Object)hostAndPort.getHost(), (Object)inetAddrs);
                }
                for (InetAddress addr : inetAddrs) {
                    masterAddrsWithNames.add(new Pair<InetAddress, HostAndPort>(addr, new HostAndPort(addr.getHostAddress(), hostAndPort.getPort())));
                }
                continue;
            }
            masterAddrsWithNames.add(new Pair<Object, HostAndPort>(null, hostAndPort));
        }
        this.numMasters = masterAddrsWithNames.size();
        for (Pair pair : masterAddrsWithNames) {
            Deferred<Master.ConnectToMasterResponsePB> d;
            InetAddress addr = (InetAddress)pair.getFirst();
            HostAndPort hostAndPort = (HostAndPort)pair.getSecond();
            if (addr != null) {
                AsyncKuduClient client = masterTable.getAsyncClient();
                RpcProxy proxy = client.newMasterRpcProxy(hostAndPort, addr, credentialsPolicy);
                d = ConnectToCluster.connectToMaster(masterTable, proxy, parentRpc, client.getTimer(), defaultTimeoutMs);
            } else {
                String message = "Couldn't resolve this master's address " + hostAndPort.toString();
                LOG.warn(message);
                Status statusIOE = Status.IOError(message);
                d = Deferred.fromError(new NonRecoverableException(statusIOE));
            }
            d.addCallbacks(this.callbackForNode(hostAndPort), this.errbackForNode(hostAndPort));
            deferreds.add(d);
        }
        return deferreds;
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    Callback<Void, Master.ConnectToMasterResponsePB> callbackForNode(HostAndPort hostAndPort) {
        return new ConnectToMasterCB(hostAndPort);
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    Callback<Void, Exception> errbackForNode(HostAndPort hostAndPort) {
        return new ConnectToMasterErrCB(hostAndPort);
    }

    private void incrementCountAndCheckExhausted() {
        if (this.countResponsesReceived.incrementAndGet() == this.numMasters && this.responseDCalled.compareAndSet(false, true)) {
            boolean allUnrecoverable = true;
            if (this.exceptionsReceived.size() == this.countResponsesReceived.get()) {
                for (Exception ex : this.exceptionsReceived) {
                    if (ex instanceof NonRecoverableException) continue;
                    allUnrecoverable = false;
                    break;
                }
            } else {
                allUnrecoverable = false;
            }
            String allHosts = NetUtil.hostsAndPortsToString(this.masterAddrs);
            if (allUnrecoverable) {
                String msg = String.format("Couldn't find a valid master in (%s). Exceptions received: [%s]", allHosts, Joiner.on(", ").join(Lists.transform(this.exceptionsReceived, Functions.toStringFunction())));
                Status s2 = Status.ServiceUnavailable(msg);
                this.responseD.callback(new NonRecoverableException(s2));
            } else {
                NoLeaderFoundException ex;
                List<Common.HostPortPB> knownMastersLocal = this.knownMasters.get();
                if (knownMastersLocal != null && knownMastersLocal.size() > this.numMasters) {
                    String msg = String.format("Could not connect to a leader master. Client configured with %s master(s) (%s) but cluster indicates it expects %s master(s) (%s)", this.numMasters, allHosts, knownMastersLocal.size(), ProtobufHelper.hostPortPbListToString(knownMastersLocal));
                    LOG.warn(msg);
                    NonRecoverableException e = new NonRecoverableException(Status.ConfigurationError(msg));
                    if (!LOG.isDebugEnabled()) {
                        e.setStackTrace(new StackTraceElement[0]);
                    }
                    this.responseD.callback(e);
                    return;
                }
                String message = String.format("Master config (%s) has no leader.", allHosts);
                if (this.exceptionsReceived.isEmpty()) {
                    LOG.warn("None of the provided masters {} is a leader; will retry", (Object)allHosts);
                    ex = new NoLeaderFoundException(Status.ServiceUnavailable(message));
                } else {
                    LOG.warn("Unable to find the leader master {}; will retry", (Object)allHosts);
                    String joinedMsg = message + " Exceptions received: " + Joiner.on(",").join(Lists.transform(this.exceptionsReceived, Functions.toStringFunction()));
                    Status s3 = Status.ServiceUnavailable(joinedMsg);
                    ex = new NoLeaderFoundException(s3, this.exceptionsReceived.get(this.exceptionsReceived.size() - 1));
                }
                this.responseD.callback(ex);
            }
        }
    }

    private void recordKnownMasters(Master.ConnectToMasterResponsePB r) {
        if (r.getMasterAddrsCount() == 0) {
            return;
        }
        this.knownMasters.compareAndSet(null, r.getMasterAddrsList());
    }

    final class ConnectToMasterErrCB
    implements Callback<Void, Exception> {
        private final HostAndPort hostAndPort;

        public ConnectToMasterErrCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        @Override
        public Void call(Exception e) throws Exception {
            LOG.info("Unable to connect to master {}: {}", (Object)this.hostAndPort, (Object)e.getMessage());
            ConnectToCluster.this.exceptionsReceived.add(e);
            ConnectToCluster.this.incrementCountAndCheckExhausted();
            return null;
        }

        public String toString() {
            return "ConnectToMasterErrCB for " + this.hostAndPort.toString();
        }
    }

    final class ConnectToMasterCB
    implements Callback<Void, Master.ConnectToMasterResponsePB> {
        private final HostAndPort hostAndPort;

        public ConnectToMasterCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        @Override
        public Void call(Master.ConnectToMasterResponsePB r) throws Exception {
            ConnectToCluster.this.recordKnownMasters(r);
            if (!r.getRole().equals(Metadata.RaftPeerPB.Role.LEADER)) {
                ConnectToCluster.this.incrementCountAndCheckExhausted();
                return null;
            }
            if (!ConnectToCluster.this.responseDCalled.compareAndSet(false, true)) {
                LOG.debug("Callback already invoked, discarding response({}) from {}", (Object)r, (Object)this.hostAndPort);
                return null;
            }
            ConnectToCluster.this.responseD.callback(new ConnectToClusterResponse(this.hostAndPort, r));
            return null;
        }

        public String toString() {
            return "ConnectToMasterCB for " + this.hostAndPort.toString();
        }
    }
}

