/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.client.Connection;
import org.apache.kudu.client.SecurityContext;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.shaded.com.google.common.collect.HashMultimap;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class ConnectionCache {
    private final SecurityContext securityContext;
    private final Bootstrap bootstrap;
    private final String saslProtocolName;
    private boolean requireAuthentication;
    private boolean requireEncryption;
    private boolean encryptLoopback;
    private long negotiationTimeoutMs;
    @GuardedBy(value="connsByAddress")
    private final HashMultimap<InetSocketAddress, Connection> connsByAddress = HashMultimap.create();

    ConnectionCache(SecurityContext securityContext, Bootstrap bootstrap, String saslProtocolName, boolean requireAuthentication, boolean requireEncryption, boolean encryptLoopback, long negotiationTimeoutMs) {
        this.securityContext = securityContext;
        this.bootstrap = bootstrap;
        this.saslProtocolName = saslProtocolName;
        this.requireAuthentication = requireAuthentication;
        this.requireEncryption = requireEncryption;
        this.encryptLoopback = encryptLoopback;
        this.negotiationTimeoutMs = negotiationTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(ServerInfo serverInfo, Connection.CredentialsPolicy credentialsPolicy) {
        Connection result = null;
        HashMultimap<InetSocketAddress, Connection> hashMultimap = this.connsByAddress;
        synchronized (hashMultimap) {
            Set connections = this.connsByAddress.get((Object)serverInfo.getResolvedAddress());
            Iterator it = connections.iterator();
            while (it.hasNext()) {
                Connection c = (Connection)it.next();
                if (c.isTerminated()) {
                    it.remove();
                    continue;
                }
                if (credentialsPolicy != Connection.CredentialsPolicy.ANY_CREDENTIALS && credentialsPolicy != c.getCredentialsPolicy()) continue;
                result = c;
            }
            if (result == null) {
                result = new Connection(serverInfo, this.securityContext, this.bootstrap, credentialsPolicy, this.saslProtocolName, this.requireAuthentication, this.requireEncryption, this.encryptLoopback, this.negotiationTimeoutMs);
                connections.add(result);
                assert (connections.size() <= 2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Deferred<ArrayList<Void>> disconnectEverything() {
        HashMultimap<InetSocketAddress, Connection> hashMultimap = this.connsByAddress;
        synchronized (hashMultimap) {
            ArrayList deferreds = new ArrayList(this.connsByAddress.size());
            for (Connection c : this.connsByAddress.values()) {
                deferreds.add(c.shutdown());
            }
            return Deferred.group(deferreds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    List<Connection> getConnectionListCopy() {
        HashMultimap<InetSocketAddress, Connection> hashMultimap = this.connsByAddress;
        synchronized (hashMultimap) {
            return ImmutableList.copyOf(this.connsByAddress.values());
        }
    }
}

