/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.NoSuchElementException;
import org.apache.kudu.Schema;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.RowwiseRowResult;
import org.apache.kudu.client.Status;
import org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class RowwiseRowResultIterator
extends RowResultIterator {
    private static final RowwiseRowResultIterator EMPTY = new RowwiseRowResultIterator(0L, null, null, 0, null, null, false);
    private final Slice bs;
    private final Slice indirectBs;
    private final RowResult sharedRowResult;

    RowwiseRowResultIterator(long elapsedMillis, String tsUUID, Schema schema, int numRows, Slice bs, Slice indirectBs, boolean reuseRowResult) {
        super(elapsedMillis, tsUUID, schema, numRows);
        this.bs = bs;
        this.indirectBs = indirectBs;
        this.sharedRowResult = reuseRowResult && numRows != 0 ? new RowwiseRowResult(this.schema, this.bs, this.indirectBs, -1) : null;
    }

    static RowwiseRowResultIterator makeRowResultIterator(long elapsedMillis, String tsUUID, Schema schema, WireProtocol.RowwiseRowBlockPB data, CallResponse callResponse, boolean reuseRowResult) throws KuduException {
        int rowSize;
        if (data == null || data.getNumRows() == 0) {
            return new RowwiseRowResultIterator(elapsedMillis, tsUUID, schema, 0, null, null, reuseRowResult);
        }
        Slice bs = callResponse.getSidecar(data.getRowsSidecar());
        Slice indirectBs = callResponse.getSidecar(data.getIndirectDataSidecar());
        int numRows = data.getNumRows();
        int expectedSize = numRows * (rowSize = schema.getRowSize());
        if (expectedSize != bs.length()) {
            Status statusIllegalState = Status.IllegalState("RowResult block has " + bs.length() + " bytes of data but expected " + expectedSize + " for " + numRows + " rows");
            throw new NonRecoverableException(statusIllegalState);
        }
        return new RowwiseRowResultIterator(elapsedMillis, tsUUID, schema, numRows, bs, indirectBs, reuseRowResult);
    }

    public static RowwiseRowResultIterator empty() {
        return EMPTY;
    }

    @Override
    public RowResult next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.sharedRowResult != null) {
            this.sharedRowResult.advancePointerTo(this.currentRow++);
            return this.sharedRowResult;
        }
        return new RowwiseRowResult(this.schema, this.bs, this.indirectBs, this.currentRow++);
    }

    public String toString() {
        return "RowwiseRowResultIterator for " + this.numRows + " rows";
    }
}

