/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Counter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.DistributionSummary;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionCounter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.LongTaskTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Meter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tags;
import org.apache.kudu.shaded.io.micrometer.core.instrument.TimeGauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Timer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.search.MeterNotFoundException;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

public final class RequiredSearch {
    final MeterRegistry registry;
    final List<Tag> requiredTags = new ArrayList<Tag>();
    final Set<String> requiredTagKeys = new HashSet<String>();
    @Nullable
    String exactNameMatch;
    @Nullable
    Predicate<String> nameMatches;

    private RequiredSearch(MeterRegistry registry) {
        this.registry = registry;
    }

    public RequiredSearch name(String exactName) {
        this.nameMatches = n -> n.equals(exactName);
        this.exactNameMatch = exactName;
        return this;
    }

    public RequiredSearch name(Predicate<String> nameMatches) {
        this.nameMatches = nameMatches;
        return this;
    }

    public RequiredSearch tags(Iterable<Tag> tags) {
        tags.forEach(this.requiredTags::add);
        return this;
    }

    public RequiredSearch tags(String ... tags) {
        return this.tags(Tags.of(tags));
    }

    public RequiredSearch tag(String tagKey, String tagValue) {
        return this.tags(Tags.of(tagKey, tagValue));
    }

    public RequiredSearch tagKeys(String ... tagKeys) {
        Collections.addAll(this.requiredTagKeys, tagKeys);
        return this;
    }

    public Timer timer() {
        return this.findOne(Timer.class);
    }

    public Counter counter() {
        return this.findOne(Counter.class);
    }

    public Gauge gauge() {
        return this.findOne(Gauge.class);
    }

    public FunctionCounter functionCounter() {
        return this.findOne(FunctionCounter.class);
    }

    public TimeGauge timeGauge() {
        return this.findOne(TimeGauge.class);
    }

    public FunctionTimer functionTimer() {
        return this.findOne(FunctionTimer.class);
    }

    public DistributionSummary summary() {
        return this.findOne(DistributionSummary.class);
    }

    public LongTaskTimer longTaskTimer() {
        return this.findOne(LongTaskTimer.class);
    }

    public Meter meter() {
        return this.findOne(Meter.class);
    }

    private <M extends Meter> M findOne(Class<M> clazz) {
        Optional<Meter> meter = this.meterStream().filter(clazz::isInstance).findAny().map(clazz::cast);
        if (meter.isPresent()) {
            return (M)meter.get();
        }
        throw MeterNotFoundException.forSearch(this, clazz);
    }

    private <M extends Meter> Collection<M> findAll(Class<M> clazz) {
        List meters = this.meterStream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
        if (meters.isEmpty()) {
            throw MeterNotFoundException.forSearch(this, clazz);
        }
        return meters;
    }

    public Collection<Meter> meters() {
        List<Meter> meters = this.meterStream().collect(Collectors.toList());
        if (meters.isEmpty()) {
            throw MeterNotFoundException.forSearch(this, Meter.class);
        }
        return meters;
    }

    private Stream<Meter> meterStream() {
        Stream<Meter> meterStream = this.registry.getMeters().stream().filter(m3 -> this.nameMatches == null || this.nameMatches.test(m3.getId().getName()));
        if (!this.requiredTags.isEmpty() || !this.requiredTagKeys.isEmpty()) {
            meterStream = meterStream.filter(m3 -> {
                boolean requiredKeysPresent = true;
                if (!this.requiredTagKeys.isEmpty()) {
                    ArrayList tagKeys = new ArrayList();
                    m3.getId().getTagsAsIterable().forEach(t -> tagKeys.add(t.getKey()));
                    requiredKeysPresent = tagKeys.containsAll(this.requiredTagKeys);
                }
                return requiredKeysPresent && m3.getId().getTags().containsAll(this.requiredTags);
            });
        }
        return meterStream;
    }

    public Collection<Counter> counters() {
        return this.findAll(Counter.class);
    }

    public Collection<Gauge> gauges() {
        return this.findAll(Gauge.class);
    }

    public Collection<Timer> timers() {
        return this.findAll(Timer.class);
    }

    public Collection<DistributionSummary> summaries() {
        return this.findAll(DistributionSummary.class);
    }

    public Collection<LongTaskTimer> longTaskTimers() {
        return this.findAll(LongTaskTimer.class);
    }

    public Collection<FunctionCounter> functionCounters() {
        return this.findAll(FunctionCounter.class);
    }

    public Collection<FunctionTimer> functionTimers() {
        return this.findAll(FunctionTimer.class);
    }

    public Collection<TimeGauge> timeGauges() {
        return this.findAll(TimeGauge.class);
    }

    public static RequiredSearch in(MeterRegistry registry) {
        return new RequiredSearch(registry);
    }
}

