/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.store;

import java.io.IOException;
import org.apache.lucene.backward_codecs.store.EndiannessReverserIndexInput;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;

final class EndiannessReverserChecksumIndexInput
extends ChecksumIndexInput {
    private final ChecksumIndexInput in;

    EndiannessReverserChecksumIndexInput(IndexInput in) {
        super("Endianness reverser Checksum Index Input wrapper");
        this.in = new BufferedChecksumIndexInput(in);
    }

    public long getChecksum() throws IOException {
        return this.in.getChecksum();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
    }

    public short readShort() throws IOException {
        return Short.reverseBytes(this.in.readShort());
    }

    public int readInt() throws IOException {
        return Integer.reverseBytes(this.in.readInt());
    }

    public long readLong() throws IOException {
        return Long.reverseBytes(this.in.readLong());
    }

    public void close() throws IOException {
        this.in.close();
    }

    public long getFilePointer() {
        return this.in.getFilePointer();
    }

    public long length() {
        return this.in.length();
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new EndiannessReverserIndexInput(this.in.slice(sliceDescription, offset, length));
    }
}

