/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.mutable.MutableValue;

public class FunctionSecondPassGroupingCollector
extends AbstractSecondPassGroupingCollector<MutableValue> {
    private final ValueSource groupByVS;
    private final Map<?, ?> vsContext;
    private FunctionValues.ValueFiller filler;
    private MutableValue mval;

    public FunctionSecondPassGroupingCollector(Collection<SearchGroup<MutableValue>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields, ValueSource groupByVS, Map<?, ?> vsContext) throws IOException {
        super(searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        this.groupByVS = groupByVS;
        this.vsContext = vsContext;
    }

    @Override
    protected AbstractSecondPassGroupingCollector.SearchGroupDocs<MutableValue> retrieveGroup(int doc) throws IOException {
        this.filler.fillValue(doc);
        return (AbstractSecondPassGroupingCollector.SearchGroupDocs)this.groupMap.get(this.mval);
    }

    @Override
    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        FunctionValues values = this.groupByVS.getValues(this.vsContext, readerContext);
        this.filler = values.getValueFiller();
        this.mval = this.filler.getValue();
    }
}

