/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterNumericDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.search.comparators.FloatComparator;
import org.apache.lucene.search.comparators.IntComparator;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.BlockJoinSelector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.NumericUtils;

public class ToParentBlockJoinSortField
extends SortField {
    private final boolean order;
    private final BitSetProducer parentFilter;
    private final BitSetProducer childFilter;

    public ToParentBlockJoinSortField(String field, SortField.Type type, boolean reverse, BitSetProducer parentFilter, BitSetProducer childFilter) {
        super(field, type, reverse);
        switch (this.getType()) {
            case STRING: 
            case DOUBLE: 
            case FLOAT: 
            case LONG: 
            case INT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sort type " + type + " is not supported");
            }
        }
        this.order = reverse;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public ToParentBlockJoinSortField(String field, SortField.Type type, boolean reverse, boolean order, BitSetProducer parentFilter, BitSetProducer childFilter) {
        super(field, type, reverse);
        this.order = order;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public FieldComparator<?> getComparator(int numHits, int sortPos) {
        switch (this.getType()) {
            case STRING: {
                return this.getStringComparator(numHits);
            }
            case DOUBLE: {
                return this.getDoubleComparator(numHits, sortPos);
            }
            case FLOAT: {
                return this.getFloatComparator(numHits, sortPos);
            }
            case LONG: {
                return this.getLongComparator(numHits, sortPos);
            }
            case INT: {
                return this.getIntComparator(numHits, sortPos);
            }
        }
        throw new UnsupportedOperationException("Sort type " + this.getType() + " is not supported");
    }

    private FieldComparator<?> getStringComparator(int numHits) {
        return new FieldComparator.TermOrdValComparator(numHits, this.getField(), this.missingValue == STRING_LAST){

            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                SortedSetDocValues sortedSet = DocValues.getSortedSet((LeafReader)context.reader(), (String)field);
                BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return DocValues.emptySorted();
                }
                return BlockJoinSelector.wrap(sortedSet, type, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
            }
        };
    }

    private FieldComparator<?> getIntComparator(int numHits, int sortPos) {
        return new IntComparator(numHits, this.getField(), (Integer)this.missingValue, this.getReverse(), sortPos){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new IntComparator.IntLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                        BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                        BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                        BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                        if (children == null) {
                            return DocValues.emptyNumeric();
                        }
                        return BlockJoinSelector.wrap(sortedNumeric, type, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
                    }

                    protected PointValues getPointValues(LeafReaderContext context, String field) {
                        return null;
                    }
                };
            }
        };
    }

    private FieldComparator<?> getLongComparator(int numHits, int sortPos) {
        return new LongComparator(numHits, this.getField(), (Long)this.missingValue, this.getReverse(), sortPos){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new LongComparator.LongLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                        BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                        BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                        BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                        if (children == null) {
                            return DocValues.emptyNumeric();
                        }
                        return BlockJoinSelector.wrap(sortedNumeric, type, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children));
                    }

                    protected PointValues getPointValues(LeafReaderContext context, String field) {
                        return null;
                    }
                };
            }
        };
    }

    private FieldComparator<?> getFloatComparator(int numHits, int sortPos) {
        return new FloatComparator(numHits, this.getField(), (Float)this.missingValue, this.getReverse(), sortPos){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new FloatComparator.FloatLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                        BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                        BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                        BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                        if (children == null) {
                            return DocValues.emptyNumeric();
                        }
                        return new FilterNumericDocValues(BlockJoinSelector.wrap(sortedNumeric, type, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children))){

                            public long longValue() throws IOException {
                                return NumericUtils.sortableFloatBits((int)((int)super.longValue()));
                            }
                        };
                    }

                    protected PointValues getPointValues(LeafReaderContext context, String field) {
                        return null;
                    }
                };
            }
        };
    }

    private FieldComparator<?> getDoubleComparator(int numHits, int sortPost) {
        return new DoubleComparator(numHits, this.getField(), (Double)this.missingValue, this.getReverse(), sortPost){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new DoubleComparator.DoubleLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                        BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                        BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                        BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                        if (children == null) {
                            return DocValues.emptyNumeric();
                        }
                        return new FilterNumericDocValues(BlockJoinSelector.wrap(sortedNumeric, type, parents, (DocIdSetIterator)BlockJoinSelector.toIter(children))){

                            public long longValue() throws IOException {
                                return NumericUtils.sortableDoubleBits((long)super.longValue());
                            }
                        };
                    }

                    protected PointValues getPointValues(LeafReaderContext context, String field) {
                        return null;
                    }
                };
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.childFilter == null ? 0 : this.childFilter.hashCode());
        result = 31 * result + (this.order ? 1231 : 1237);
        result = 31 * result + (this.parentFilter == null ? 0 : this.parentFilter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ToParentBlockJoinSortField other = (ToParentBlockJoinSortField)((Object)obj);
        if (this.childFilter == null ? other.childFilter != null : !this.childFilter.equals(other.childFilter)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        return !(this.parentFilter == null ? other.parentFilter != null : !this.parentFilter.equals(other.parentFilter));
    }
}

