/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mockintblock;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blockterms.BlockTermsReader;
import org.apache.lucene.codecs.blockterms.BlockTermsWriter;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexReader;
import org.apache.lucene.codecs.blockterms.FixedGapTermsIndexWriter;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.codecs.intblock.VariableIntBlockIndexInput;
import org.apache.lucene.codecs.intblock.VariableIntBlockIndexOutput;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.codecs.sep.IntStreamFactory;
import org.apache.lucene.codecs.sep.SepPostingsReader;
import org.apache.lucene.codecs.sep.SepPostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class MockVariableIntBlockPostingsFormat
extends PostingsFormat {
    private final int baseBlockSize;

    public MockVariableIntBlockPostingsFormat() {
        this(1);
    }

    public MockVariableIntBlockPostingsFormat(int baseBlockSize) {
        super("MockVariableIntBlock");
        this.baseBlockSize = baseBlockSize;
    }

    public String toString() {
        return this.getName() + "(baseBlockSize=" + this.baseBlockSize + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        FixedGapTermsIndexWriter indexWriter;
        SepPostingsWriter postingsWriter = new SepPostingsWriter(state, (IntStreamFactory)new MockIntFactory(this.baseBlockSize));
        boolean success = false;
        try {
            indexWriter = new FixedGapTermsIndexWriter(state);
            success = true;
        }
        finally {
            if (!success) {
                postingsWriter.close();
            }
        }
        success = false;
        try {
            BlockTermsWriter ret = new BlockTermsWriter((TermsIndexWriterBase)indexWriter, state, (PostingsWriterBase)postingsWriter);
            success = true;
            BlockTermsWriter blockTermsWriter = ret;
            return blockTermsWriter;
        }
        finally {
            if (!success) {
                try {
                    postingsWriter.close();
                }
                finally {
                    indexWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        FixedGapTermsIndexReader indexReader;
        SepPostingsReader postingsReader = new SepPostingsReader(state.dir, state.fieldInfos, state.segmentInfo, state.context, (IntStreamFactory)new MockIntFactory(this.baseBlockSize), state.segmentSuffix);
        boolean success = false;
        try {
            indexReader = new FixedGapTermsIndexReader(state.dir, state.fieldInfos, state.segmentInfo.name, state.termsIndexDivisor, BytesRef.getUTF8SortedAsUnicodeComparator(), state.segmentSuffix, state.context);
            success = true;
        }
        finally {
            if (!success) {
                postingsReader.close();
            }
        }
        success = false;
        try {
            BlockTermsReader ret = new BlockTermsReader((TermsIndexReaderBase)indexReader, state.dir, state.fieldInfos, state.segmentInfo, (PostingsReaderBase)postingsReader, state.context, 1024, state.segmentSuffix);
            success = true;
            BlockTermsReader blockTermsReader = ret;
            return blockTermsReader;
        }
        finally {
            if (!success) {
                try {
                    postingsReader.close();
                }
                finally {
                    indexReader.close();
                }
            }
        }
    }

    public static class MockIntFactory
    extends IntStreamFactory {
        private final int baseBlockSize;

        public MockIntFactory(int baseBlockSize) {
            this.baseBlockSize = baseBlockSize;
        }

        public IntIndexInput openInput(Directory dir, String fileName, IOContext context) throws IOException {
            IndexInput in = dir.openInput(fileName, context);
            final int baseBlockSize = in.readInt();
            return new VariableIntBlockIndexInput(in){

                protected VariableIntBlockIndexInput.BlockReader getBlockReader(final IndexInput in, final int[] buffer) {
                    return new VariableIntBlockIndexInput.BlockReader(){

                        public void seek(long pos) {
                        }

                        public int readBlock() throws IOException {
                            int count;
                            buffer[0] = in.readVInt();
                            int n = count = buffer[0] <= 3 ? baseBlockSize - 1 : 2 * baseBlockSize - 1;
                            assert (buffer.length >= count) : "buffer.length=" + buffer.length + " count=" + count;
                            for (int i = 0; i < count; ++i) {
                                buffer[i + 1] = in.readVInt();
                            }
                            return 1 + count;
                        }
                    };
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IntIndexOutput createOutput(Directory dir, String fileName, IOContext context) throws IOException {
            VariableIntBlockIndexOutput variableIntBlockIndexOutput;
            block3: {
                IndexOutput out = dir.createOutput(fileName, context);
                boolean success = false;
                try {
                    out.writeInt(this.baseBlockSize);
                    VariableIntBlockIndexOutput ret = new VariableIntBlockIndexOutput(out, 2 * this.baseBlockSize){
                        int pendingCount;
                        final int[] buffer;
                        {
                            this.buffer = new int[2 + 2 * MockIntFactory.this.baseBlockSize];
                        }

                        protected int add(int value) throws IOException {
                            int flushAt;
                            this.buffer[this.pendingCount++] = value;
                            int n = flushAt = this.buffer[0] <= 3 ? MockIntFactory.this.baseBlockSize : 2 * MockIntFactory.this.baseBlockSize;
                            if (this.pendingCount == flushAt + 1) {
                                for (int i = 0; i < flushAt; ++i) {
                                    this.out.writeVInt(this.buffer[i]);
                                }
                                this.buffer[0] = this.buffer[flushAt];
                                this.pendingCount = 1;
                                return flushAt;
                            }
                            return 0;
                        }
                    };
                    success = true;
                    variableIntBlockIndexOutput = ret;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
            }
            return variableIntBlockIndexOutput;
        }
    }
}

