/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Strings;
import org.apache.maven.buildcache.PluginScanConfig;
import org.apache.maven.buildcache.ScanConfigProperties;
import org.apache.maven.buildcache.xml.config.DirScanConfig;
import org.apache.maven.buildcache.xml.config.TagExclude;
import org.apache.maven.buildcache.xml.config.TagScanConfig;

public class PluginScanConfigImpl
implements PluginScanConfig {
    private final DirScanConfig dto;

    public PluginScanConfigImpl(DirScanConfig scanConfig) {
        this.dto = scanConfig;
    }

    @Override
    public boolean isSkip() {
        return Strings.CS.equals(this.dto.getMode(), "skip");
    }

    @Override
    public boolean accept(String tagName) {
        List<TagScanConfig> includes = this.dto.getIncludes();
        if (!includes.isEmpty()) {
            return this.findTagScanProperties(tagName) != null;
        }
        return !this.contains(this.dto.getExcludes(), tagName);
    }

    private boolean contains(List<TagExclude> excludes, String tagName) {
        for (TagExclude exclude : excludes) {
            if (!Strings.CS.equals(exclude.getTagName(), tagName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public PluginScanConfig mergeWith(PluginScanConfig overrideConfig) {
        if (this.dto == null) {
            return overrideConfig;
        }
        DirScanConfig override = overrideConfig.dto();
        if (override == null) {
            return this;
        }
        if (override.isIgnoreParent()) {
            return overrideConfig;
        }
        DirScanConfig merged = new DirScanConfig();
        if (override.getMode() != null) {
            merged.setMode(override.getMode());
        } else {
            merged.setMode(this.dto.getMode());
        }
        merged.getExcludes().addAll(this.dto.getExcludes());
        merged.getExcludes().addAll(override.getExcludes());
        merged.getIncludes().addAll(this.dto.getIncludes());
        merged.getIncludes().addAll(override.getIncludes());
        return new PluginScanConfigImpl(merged);
    }

    @Override
    @Nonnull
    public ScanConfigProperties getTagScanProperties(String tagName) {
        ScanConfigProperties scanProperties = this.findTagScanProperties(tagName);
        return scanProperties != null ? scanProperties : PluginScanConfigImpl.defaultScanConfig();
    }

    @Override
    public DirScanConfig dto() {
        return this.dto;
    }

    private ScanConfigProperties findTagScanProperties(String tagName) {
        ScanConfigProperties scanConfigProperties = this.findConfigByName(tagName, this.dto.getIncludes());
        if (scanConfigProperties == null) {
            scanConfigProperties = this.findConfigByName(tagName, this.dto.getTagScanConfigs());
        }
        return scanConfigProperties;
    }

    private ScanConfigProperties findConfigByName(String tagName, List<TagScanConfig> configs) {
        if (configs == null) {
            return null;
        }
        for (TagScanConfig config : configs) {
            if (!Strings.CS.equals(tagName, config.getTagName())) continue;
            return new ScanConfigProperties(config.isRecursive(), config.getGlob());
        }
        return null;
    }

    private static ScanConfigProperties defaultScanConfig() {
        return new ScanConfigProperties(true, null);
    }
}

