/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml.diff.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.buildcache.xml.diff.Diff;
import org.apache.maven.buildcache.xml.diff.Mismatch;
import org.apache.maven.buildcache.xml.diff.MismatchDetail;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class BuildCacheDiffXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Diff diff) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(diff.getModelEncoding(), null);
        this.writeDiff(diff, "diff", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Diff diff) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, diff.getModelEncoding());
        serializer.startDocument(diff.getModelEncoding(), null);
        this.writeDiff(diff, "diff", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeDiff(Diff diff, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "http://maven.apache.org/BUILD-CACHE-DIFF/1.2.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/BUILD-CACHE-DIFF/1.2.0 https://maven.apache.org/xsd/build-cache-diff-1.2.0.xsd");
        if (diff.getMismatches() != null && diff.getMismatches().size() > 0) {
            serializer.startTag(NAMESPACE, "mismatches");
            for (Mismatch o : diff.getMismatches()) {
                this.writeMismatch(o, "mismatch", serializer);
            }
            serializer.endTag(NAMESPACE, "mismatches");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMismatch(Mismatch mismatch, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (mismatch.getItem() != null) {
            serializer.attribute(NAMESPACE, "item", mismatch.getItem());
        }
        if (mismatch.getCurrent() != null) {
            serializer.attribute(NAMESPACE, "current", mismatch.getCurrent());
        }
        if (mismatch.getBaseline() != null) {
            serializer.attribute(NAMESPACE, "baseline", mismatch.getBaseline());
        }
        if (mismatch.getReason() != null) {
            serializer.attribute(NAMESPACE, "reason", mismatch.getReason());
        }
        if (mismatch.getResolution() != null) {
            serializer.attribute(NAMESPACE, "resolution", mismatch.getResolution());
        }
        if (mismatch.getContext() != null) {
            serializer.attribute(NAMESPACE, "context", mismatch.getContext());
        }
        if (mismatch.getDetail() != null && mismatch.getDetail().size() > 0) {
            serializer.startTag(NAMESPACE, "detail");
            for (MismatchDetail o : mismatch.getDetail()) {
                this.writeMismatchDetail(o, "detail", serializer);
            }
            serializer.endTag(NAMESPACE, "detail");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMismatchDetail(MismatchDetail mismatchDetail, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        serializer.endTag(NAMESPACE, tagName);
    }
}

