/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Section for management of reports and their configuration.
 * 
 * @version $Revision$ $Date$
 */
public class Reporting implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If true, then the default reports are not included in the
     * site generation.
     *             This includes the reports in the "Project Info"
     * menu.
     */
    private boolean excludeDefaults = false;

    /**
     * 
     *             
     *             Where to store all of the generated reports. The
     * default is
     *             <code>${project.build.directory}/site</code>
     *             .
     *             
     *           
     */
    private String outputDirectory;

    /**
     * Field plugins.
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin.
     * 
     * @param reportPlugin
     */
    public void addPlugin( ReportPlugin reportPlugin )
    {
        if ( !(reportPlugin instanceof ReportPlugin) )
        {
            throw new ClassCastException( "Reporting.addPlugins(reportPlugin) parameter must be instanceof " + ReportPlugin.class.getName() );
        }
        getPlugins().add( reportPlugin );
    } //-- void addPlugin( ReportPlugin ) 

    /**
     * Get 
     *             
     *             Where to store all of the generated reports. The
     * default is
     *             <code>${project.build.directory}/site</code>
     *             .
     *             
     *           
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Method getPlugins.
     * 
     * @return java.util.List
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
    
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Get if true, then the default reports are not included in
     * the site generation.
     *             This includes the reports in the "Project Info"
     * menu.
     * 
     * @return boolean
     */
    public boolean isExcludeDefaults()
    {
        return this.excludeDefaults;
    } //-- boolean isExcludeDefaults() 

    /**
     * Method removePlugin.
     * 
     * @param reportPlugin
     */
    public void removePlugin( ReportPlugin reportPlugin )
    {
        if ( !(reportPlugin instanceof ReportPlugin) )
        {
            throw new ClassCastException( "Reporting.removePlugins(reportPlugin) parameter must be instanceof " + ReportPlugin.class.getName() );
        }
        getPlugins().remove( reportPlugin );
    } //-- void removePlugin( ReportPlugin ) 

    /**
     * Set if true, then the default reports are not included in
     * the site generation.
     *             This includes the reports in the "Project Info"
     * menu.
     * 
     * @param excludeDefaults
     */
    public void setExcludeDefaults( boolean excludeDefaults )
    {
        this.excludeDefaults = excludeDefaults;
    } //-- void setExcludeDefaults( boolean ) 

    /**
     * Set 
     *             
     *             Where to store all of the generated reports. The
     * default is
     *             <code>${project.build.directory}/site</code>
     *             .
     *             
     *           
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String ) 

    /**
     * Set the reporting plugins to use and their configuration.
     * 
     * @param plugins
     */
    public void setPlugins( java.util.List plugins )
    {
        this.plugins = plugins;
    } //-- void setPlugins( java.util.List ) 


            
    java.util.Map reportPluginMap;

    /**
     * Reset the <code>reportPluginMap</code> field to <code>null</code>
     */
    public synchronized void flushReportPluginMap()
    {
        this.reportPluginMap = null;
    }

    /**
     * @return a Map of plugins field with <code>ReportPlugin#getKey()</code> as key
     * @see org.apache.maven.model.ReportPlugin#getKey()
     */
    public synchronized java.util.Map getReportPluginsAsMap()
    {
        if ( reportPluginMap == null )
        {
            reportPluginMap = new java.util.LinkedHashMap();
            if ( getPlugins() != null )
            {
                for ( java.util.Iterator it = getPlugins().iterator(); it.hasNext(); )
                {
                    ReportPlugin reportPlugin = (ReportPlugin) it.next();
                    reportPluginMap.put( reportPlugin.getKey(), reportPlugin );
                }
            }
        }

        return reportPluginMap;
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
