/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.testing.stubs.DefaultArtifactHandlerStub;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactStubFactory {
    private File workingDir;
    private boolean createFiles;
    private File srcFile;
    private boolean createUnpackableFile;
    private ArchiverManager archiverManager;

    public ArtifactStubFactory() {
        this.workingDir = null;
        this.createFiles = false;
    }

    public ArtifactStubFactory(File workingDir, boolean createFiles) {
        this.workingDir = new File(workingDir, "localTestRepo");
        this.createFiles = createFiles;
    }

    public void setUnpackableFile(ArchiverManager archiverManager) {
        this.createUnpackableFile = true;
        this.archiverManager = archiverManager;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version) throws IOException {
        return this.createArtifact(groupId, artifactId, version, "compile", "jar", "");
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope) throws IOException {
        return this.createArtifact(groupId, artifactId, version, scope, "jar", "");
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier) throws IOException {
        VersionRange vr = VersionRange.createFromVersion((String)version);
        return this.createArtifact(groupId, artifactId, vr, scope, type, classifier, false);
    }

    public Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String scope, String type, String classifier, boolean optional) throws IOException {
        DefaultArtifact artifact;
        DefaultArtifactHandlerStub ah = new DefaultArtifactHandlerStub(type, classifier);
        artifact.setRelease(!(artifact = new DefaultArtifact(groupId, artifactId, versionRange, scope, type, classifier, (ArtifactHandler)ah, optional)).isSnapshot());
        if (this.createFiles) {
            this.setArtifactFile((Artifact)artifact, this.workingDir, this.srcFile, this.createUnpackableFile);
        }
        return artifact;
    }

    public void setArtifactFile(Artifact artifact, File workingDir) throws IOException {
        this.setArtifactFile(artifact, workingDir, null, false);
    }

    public void setArtifactFile(Artifact artifact, File workingDir, File srcFile) throws IOException {
        this.setArtifactFile(artifact, workingDir, srcFile, false);
    }

    public void setUnpackableArtifactFile(Artifact artifact, File workingDir) throws IOException {
        this.setArtifactFile(artifact, workingDir, null, true);
    }

    public void setUnpackableArtifactFile(Artifact artifact, File workingDir, File srcFile) throws IOException {
        this.setArtifactFile(artifact, workingDir, srcFile, true);
    }

    private void setArtifactFile(Artifact artifact, File workingDir, File srcFile, boolean createUnpackableFile) throws IOException {
        if (workingDir == null) {
            throw new IllegalArgumentException("The workingDir must be set.");
        }
        String fileName = ArtifactStubFactory.getFormattedFileName(artifact, false);
        File theFile = new File(workingDir, fileName);
        theFile.getParentFile().mkdirs();
        if (srcFile == null) {
            theFile.createNewFile();
        } else if (createUnpackableFile) {
            try {
                this.createUnpackableFile(artifact, theFile);
            }
            catch (NoSuchArchiverException e) {
                throw new IOException("NoSuchArchiverException: " + e.getMessage());
            }
            catch (ArchiverException e) {
                throw new IOException("ArchiverException: " + e.getMessage());
            }
        } else {
            FileUtils.copyFile((File)srcFile, (File)theFile);
        }
        artifact.setFile(theFile);
    }

    public static String getUnpackableFileName(Artifact artifact) {
        return "" + artifact.getGroupId() + "-" + artifact.getArtifactId() + "-" + artifact.getVersion() + "-" + artifact.getClassifier() + "-" + artifact.getType() + ".txt";
    }

    public void createUnpackableFile(Artifact artifact, File destFile) throws NoSuchArchiverException, ArchiverException, IOException {
        Archiver archiver = this.archiverManager.getArchiver(destFile);
        archiver.setDestFile(destFile);
        archiver.addFile(this.srcFile, ArtifactStubFactory.getUnpackableFileName(artifact));
        if (archiver instanceof WarArchiver) {
            WarArchiver war = (WarArchiver)archiver;
            war.setExpectWebXml(false);
        }
        archiver.createArchive();
    }

    public Artifact getReleaseArtifact() throws IOException {
        return this.createArtifact("testGroupId", "release", "1.0");
    }

    public Artifact getSnapshotArtifact() throws IOException {
        return this.createArtifact("testGroupId", "snapshot", "2.0-SNAPSHOT");
    }

    public Set<Artifact> getReleaseAndSnapshotArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.getReleaseArtifact());
        set.add(this.getSnapshotArtifact());
        return set;
    }

    public Set<Artifact> getScopedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "compile", "1.0", "compile"));
        set.add(this.createArtifact("g", "provided", "1.0", "provided"));
        set.add(this.createArtifact("g", "test", "1.0", "test"));
        set.add(this.createArtifact("g", "runtime", "1.0", "runtime"));
        set.add(this.createArtifact("g", "system", "1.0", "system"));
        return set;
    }

    public Set<Artifact> getTypedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "a", "1.0", "compile", "war", null));
        set.add(this.createArtifact("g", "b", "1.0", "compile", "jar", null));
        set.add(this.createArtifact("g", "c", "1.0", "compile", "sources", null));
        set.add(this.createArtifact("g", "d", "1.0", "compile", "zip", null));
        set.add(this.createArtifact("g", "e", "1.0", "compile", "rar", null));
        return set;
    }

    public Set<Artifact> getClassifiedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "a", "1.0", "compile", "jar", "one"));
        set.add(this.createArtifact("g", "b", "1.0", "compile", "jar", "two"));
        set.add(this.createArtifact("g", "c", "1.0", "compile", "jar", "three"));
        set.add(this.createArtifact("g", "d", "1.0", "compile", "jar", "four"));
        return set;
    }

    public Set<Artifact> getTypedArchiveArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "a", "1.0", "compile", "war", null));
        set.add(this.createArtifact("g", "b", "1.0", "compile", "jar", null));
        set.add(this.createArtifact("g", "d", "1.0", "compile", "zip", null));
        set.add(this.createArtifact("g", "e", "1.0", "compile", "rar", null));
        return set;
    }

    public Set<Artifact> getArtifactArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("g", "one", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("g", "two", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("g", "three", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("g", "four", "1.0", "compile", "jar", "a"));
        return set;
    }

    public Set<Artifact> getGroupIdArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.add(this.createArtifact("one", "group-one", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("two", "group-two", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("three", "group-three", "1.0", "compile", "jar", "a"));
        set.add(this.createArtifact("four", "group-four", "1.0", "compile", "jar", "a"));
        return set;
    }

    public Set<Artifact> getMixedArtifacts() throws IOException {
        HashSet<Artifact> set = new HashSet<Artifact>();
        set.addAll(this.getTypedArtifacts());
        set.addAll(this.getScopedArtifacts());
        set.addAll(this.getReleaseAndSnapshotArtifacts());
        return set;
    }

    public boolean isCreateFiles() {
        return this.createFiles;
    }

    public void setCreateFiles(boolean createFiles) {
        this.createFiles = createFiles;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public static void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        field.set(object, value);
    }

    public static String getFormattedFileName(Artifact artifact, boolean removeVersion) {
        String destFileName = null;
        if (artifact.getFile() != null && !removeVersion) {
            destFileName = artifact.getFile().getName();
        } else {
            String versionString = null;
            versionString = !removeVersion ? "-" + artifact.getVersion() : "";
            String classifierString = "";
            if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
                classifierString = "-" + artifact.getClassifier();
            }
            destFileName = artifact.getArtifactId() + versionString + classifierString + "." + artifact.getArtifactHandler().getExtension();
        }
        return destFileName;
    }
}

