/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.converter;

import com.thoughtworks.qdox.model.DocletTag;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.converter.JavadocInlineTagsToXhtmlConverter;
import org.apache.maven.tools.plugin.extractor.annotations.converter.tag.block.JavadocBlockTagToHtmlConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class JavadocBlockTagsToXhtmlConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JavadocBlockTagsToXhtmlConverter.class);
    private final JavadocInlineTagsToXhtmlConverter inlineTagsConverter;
    private final Map<String, JavadocBlockTagToHtmlConverter> blockTagConverters;

    @Inject
    public JavadocBlockTagsToXhtmlConverter(JavadocInlineTagsToXhtmlConverter inlineTagsConverter, Map<String, JavadocBlockTagToHtmlConverter> blockTagConverters) {
        this.inlineTagsConverter = inlineTagsConverter;
        this.blockTagConverters = blockTagConverters;
    }

    public String convert(DocletTag docletTag, ConverterContext context) {
        return this.convert(docletTag.getName(), docletTag.getValue(), context);
    }

    public String convert(String name, String text, ConverterContext context) {
        JavadocBlockTagToHtmlConverter converter = this.blockTagConverters.get(name);
        if (converter == null) {
            return JavadocBlockTagsToXhtmlConverter.getOriginalTag(name, text) + "<!-- unknown block tag '" + name + "' -->";
        }
        try {
            String convertedBlockTagValue = converter.convert(text, context);
            return this.inlineTagsConverter.convert(convertedBlockTagValue, context);
        }
        catch (Throwable t) {
            LOG.warn("Error converting javadoc block tag '{}' in {}", new Object[]{name, context.getLocation(), t});
            return JavadocBlockTagsToXhtmlConverter.getOriginalTag(name, text) + "<!-- error processing javadoc tag '" + name + "': " + t.getMessage() + "-->";
        }
    }

    private static String getOriginalTag(String name, String text) {
        return "@" + name + " " + text;
    }
}

