/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.util.Locale;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="reproducible-central", defaultPhase=LifecyclePhase.SITE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, threadSafe=true)
public class ReproducibleCentralReport
extends AbstractMavenReport {
    @Component
    private MavenSession session;

    protected void executeReport(Locale locale) throws MavenReportException {
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text("Reproducible Central Report");
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text("Reproducible Central Report");
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("this project:");
        sink.paragraph_();
        sink.paragraph();
        this.renderReproducibleCentralArtifact(sink, this.project);
        sink.paragraph_();
        sink.paragraph();
        sink.text("project's dependencies:");
        sink.paragraph_();
        sink.list();
        new TreeMap<String, Artifact>(this.project.getArtifactMap()).forEach((key, a) -> {
            sink.listItem();
            this.renderReproducibleCentralArtifact(sink, (Artifact)a);
            sink.listItem_();
        });
        sink.list_();
        sink.paragraph();
        sink.text("(*) ");
        sink.link("https://reproducible-builds.org/");
        sink.text("Reproducible Builds");
        sink.link_();
        sink.text(" check is done through ");
        sink.link("https://github.com/jvm-repo-rebuild/reproducible-central");
        sink.text("Reproducible Central");
        sink.link_();
        sink.text(" data.");
        sink.text("If you think data is not accurate, please help improve.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
    }

    private void renderReproducibleCentralArtifact(Sink sink, MavenProject project) {
        this.renderReproducibleCentralArtifact(sink, project.getGroupId(), project.getArtifactId(), project.getVersion(), null);
    }

    private void renderReproducibleCentralArtifact(Sink sink, Artifact a) {
        this.renderReproducibleCentralArtifact(sink, a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getScope());
    }

    private void renderReproducibleCentralArtifact(Sink sink, String groupId, String artifactId, String version, String scope) {
        String url = "https://jvm-repo-rebuild.github.io/reproducible-central/badge/artifact/" + groupId.replace('.', '/') + '/' + artifactId + ".html";
        String badge = "https://img.shields.io/reproducible-central/artifact/" + groupId + '/' + artifactId + '/' + version + "?labelColor=1e5b96";
        sink.link(url);
        sink.figureGraphics(badge);
        sink.link_();
        sink.text(' ' + groupId + ':' + artifactId + ':' + version);
        if (scope != null) {
            sink.text(" (" + scope + ")");
        }
    }

    public String getOutputName() {
        return "reproducible-central";
    }

    public String getName(Locale locale) {
        return "Reproducible Central";
    }

    public String getDescription(Locale locale) {
        return "This reports shows if dependencies are proven Reproducible Builds at Reproducible Central.";
    }
}

