/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changelog;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.changelog.ChangeLogReport;
import org.apache.maven.plugins.changelog.FileActivityComparator;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.command.changelog.ChangeLogSet;

@Mojo(name="file-activity")
public class FileActivityReport
extends ChangeLogReport {
    @Override
    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.file-activity.description");
    }

    @Override
    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.file-activity.name");
    }

    @Override
    public String getOutputName() {
        return "file-activity";
    }

    @Override
    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.file-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.file-activity.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    @Override
    protected void doGenerateReport(List<ChangeLogSet> changeLogSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.file-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.file-activity.mainTitle"));
        sink.sectionTitle1_();
        for (ChangeLogSet set : changeLogSets) {
            this.doChangedSets(set, bundle, sink);
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doChangedSets(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        this.doChangeSetTitle(set, bundle, sink);
        this.doSummary(set, bundle, sink);
        sink.table();
        sink.tableRows(new int[]{1}, false);
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.file-activity.filename"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.file-activity.timesChanged"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.doRows(set, sink);
        sink.tableRows_();
        sink.table_();
        sink.section2_();
    }

    private void doRows(ChangeLogSet set, Sink sink) {
        List<List<ChangeFile>> list = this.getOrderedFileList(set.getChangeSets());
        this.initReportUrls();
        for (List<ChangeFile> revision : list) {
            ChangeFile file = revision.get(0);
            sink.tableRow();
            sink.tableCell();
            try {
                this.generateLinks(this.getConnection(), file.getName(), sink);
            }
            catch (Exception e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                } else {
                    this.getLog().error((CharSequence)e.getMessage());
                }
                sink.text(file.getName());
            }
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + revision.size());
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    private List<List<ChangeFile>> getOrderedFileList(Collection<ChangeSet> entries) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (ChangeSet entry : entries) {
            for (ChangeFile file : entry.getFiles()) {
                List revisions = map.computeIfAbsent(file.getName(), k -> new LinkedList());
                revisions.add(file);
            }
        }
        LinkedList<List<ChangeFile>> list = new LinkedList<List<ChangeFile>>(map.values());
        list.sort(new FileActivityComparator());
        return list;
    }
}

