/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.changes.IssueType;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssueManagementSystem;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;

public class IssueAdapter {
    private static final String UNKNOWN_ISSUE_TYPE = "";
    private IssueManagementSystem ims;

    public IssueAdapter(IssueManagementSystem ims) {
        this.ims = ims;
    }

    private Map<String, IssueType> getIssueTypeMap() {
        return this.ims.getIssueTypeMap();
    }

    public List<Release> getReleases(List<Issue> issues) {
        HashMap<String, Release> releasesMap = new HashMap<String, Release>();
        for (Issue issue : issues) {
            if (issue.getFixVersions() == null) continue;
            for (String fixVersion : issue.getFixVersions()) {
                Release release = (Release)releasesMap.get(fixVersion);
                if (release == null) {
                    release = new Release();
                    release.setVersion(fixVersion);
                    releasesMap.put(fixVersion, release);
                }
                Action action = this.createAction(issue);
                release.addAction(action);
            }
        }
        ArrayList<Release> releasesList = new ArrayList<Release>();
        for (Release release : releasesMap.values()) {
            releasesList.add(release);
        }
        return releasesList;
    }

    public Action createAction(Issue issue) {
        Action action = new Action();
        action.setIssue(issue.getKey());
        if (this.getIssueTypeMap().containsKey(issue.getType())) {
            IssueType type = this.getIssueTypeMap().get(issue.getType());
            action.setType(type.modelRepresentation());
        } else {
            action.setType(UNKNOWN_ISSUE_TYPE);
        }
        action.setDev(issue.getAssignee());
        action.setDueTo(issue.getReporter() == null ? UNKNOWN_ISSUE_TYPE : issue.getReporter());
        action.setAction(issue.getSummary());
        return action;
    }
}

