/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.github;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;

public class GitHubDownloader {
    private GitHubClient client;
    private boolean includeOpenIssues;
    private boolean onlyMilestoneIssues;
    private String githubOwner;
    private String githubRepo;
    private String githubIssueURL;

    public GitHubDownloader(MavenProject project, String githubScheme, int githubPort, boolean includeOpenIssues, boolean onlyMilestoneIssues) throws MalformedURLException {
        String[] urlPathParts;
        String urlPath;
        this.includeOpenIssues = includeOpenIssues;
        this.onlyMilestoneIssues = onlyMilestoneIssues;
        URL githubURL = new URL(project.getIssueManagement().getUrl());
        this.client = githubURL.getHost().equalsIgnoreCase("github.com") ? new GitHubClient() : new GitHubClient(githubURL.getHost(), githubPort, githubScheme);
        this.githubIssueURL = project.getIssueManagement().getUrl();
        if (!this.githubIssueURL.endsWith("/")) {
            this.githubIssueURL = this.githubIssueURL + "/";
        }
        if ((urlPath = githubURL.getPath()).startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (urlPath.endsWith("/")) {
            urlPath = urlPath.substring(0, urlPath.length() - 2);
        }
        if ((urlPathParts = urlPath.split("/")).length != 3) {
            throw new MalformedURLException("GitHub issue management URL must look like, [GITHUB_DOMAIN]/[OWNER]/[REPO]/issues");
        }
        this.githubOwner = urlPathParts[0];
        this.githubRepo = urlPathParts[1];
    }

    protected org.apache.maven.plugin.issues.Issue createIssue(Issue githubIssue) {
        org.apache.maven.plugin.issues.Issue issue = new org.apache.maven.plugin.issues.Issue();
        issue.setKey(String.valueOf(githubIssue.getNumber()));
        issue.setId(String.valueOf(githubIssue.getNumber()));
        issue.setLink(this.githubIssueURL + githubIssue.getNumber());
        issue.setCreated(githubIssue.getCreatedAt());
        issue.setUpdated(githubIssue.getUpdatedAt());
        if (githubIssue.getAssignee() != null) {
            if (githubIssue.getAssignee().getName() != null) {
                issue.setAssignee(githubIssue.getAssignee().getName());
            } else {
                issue.setAssignee(githubIssue.getAssignee().getLogin());
            }
        }
        issue.setTitle(githubIssue.getTitle());
        issue.setSummary(githubIssue.getTitle());
        if (githubIssue.getMilestone() != null) {
            issue.addFixVersion(githubIssue.getMilestone().getTitle());
        }
        issue.setReporter(githubIssue.getUser().getLogin());
        if (githubIssue.getClosedAt() != null) {
            issue.setStatus("closed");
        } else {
            issue.setStatus("open");
        }
        List labels = githubIssue.getLabels();
        if (labels != null && !labels.isEmpty()) {
            issue.setType(((Label)labels.get(0)).getName());
        }
        return issue;
    }

    public List<org.apache.maven.plugin.issues.Issue> getIssueList() throws IOException {
        ArrayList<org.apache.maven.plugin.issues.Issue> issueList = new ArrayList<org.apache.maven.plugin.issues.Issue>();
        IssueService service = new IssueService(this.client);
        HashMap<String, String> issueFilter = new HashMap<String, String>();
        if (this.includeOpenIssues) {
            for (Issue issue : service.getIssues(this.githubOwner, this.githubRepo, issueFilter)) {
                if (this.onlyMilestoneIssues && issue.getMilestone() == null) continue;
                issueList.add(this.createIssue(issue));
            }
        }
        issueFilter.put("state", "closed");
        for (Issue issue : service.getIssues(this.githubOwner, this.githubRepo, issueFilter)) {
            if (this.onlyMilestoneIssues && issue.getMilestone() == null) continue;
            issueList.add(this.createIssue(issue));
        }
        return issueList;
    }

    public void configureAuthentication(String githubAPIServerId, Settings settings, Log log) {
        boolean configured = false;
        List servers = settings.getServers();
        for (Server server : servers) {
            if (!server.getId().equals(githubAPIServerId)) continue;
            String user = server.getUsername();
            String password = server.getPassword();
            this.client.setCredentials(user, password);
            configured = true;
            break;
        }
        if (!configured) {
            log.warn((CharSequence)("Can't find server id [" + githubAPIServerId + "] configured in githubAPIServerId."));
        }
    }
}

