/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.issues;

import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.issues.AbstractIssuesReportGenerator;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssuesReportHelper;

public class IssuesReportGenerator
extends AbstractIssuesReportGenerator {
    private static final String NOT_AVAILABLE = "n/a";
    private int[] columns;

    public IssuesReportGenerator(int[] includedColumns) {
        this.columns = includedColumns;
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        sink.paragraph();
        sink.text(bundle.getString("report.issues.error"));
        sink.paragraph_();
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink, List<Issue> issueList) {
        this.sinkBeginReport(sink, bundle);
        this.constructHeaderRow(sink, issueList, bundle);
        this.constructDetailRows(sink, issueList, bundle, new Locale("sv"));
        this.sinkEndReport(sink);
    }

    private void constructHeaderRow(Sink sink, List<Issue> issueList, ResourceBundle bundle) {
        if (issueList == null) {
            return;
        }
        sink.table();
        sink.tableRow();
        block16: for (int column : this.columns) {
            switch (column) {
                case 0: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.assignee"));
                    continue block16;
                }
                case 1: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.component"));
                    continue block16;
                }
                case 2: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.created"));
                    continue block16;
                }
                case 3: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.fixVersion"));
                    continue block16;
                }
                case 4: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.id"));
                    continue block16;
                }
                case 5: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.key"));
                    continue block16;
                }
                case 6: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.priority"));
                    continue block16;
                }
                case 7: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.reporter"));
                    continue block16;
                }
                case 8: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.resolution"));
                    continue block16;
                }
                case 9: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.status"));
                    continue block16;
                }
                case 10: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.summary"));
                    continue block16;
                }
                case 11: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.type"));
                    continue block16;
                }
                case 12: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.updated"));
                    continue block16;
                }
                case 13: {
                    this.sinkHeader(sink, bundle.getString("report.issues.label.version"));
                    continue block16;
                }
            }
        }
        sink.tableRow_();
    }

    private void constructDetailRows(Sink sink, List<Issue> issueList, ResourceBundle bundle, Locale locale) {
        if (issueList == null) {
            return;
        }
        for (Issue issue : issueList) {
            DateFormat df = DateFormat.getDateInstance(3, locale);
            sink.tableRow();
            block17: for (int column : this.columns) {
                switch (column) {
                    case 0: {
                        this.sinkCell(sink, issue.getAssignee());
                        continue block17;
                    }
                    case 1: {
                        this.sinkCell(sink, IssuesReportHelper.printValues(issue.getComponents()));
                        continue block17;
                    }
                    case 2: {
                        String created = NOT_AVAILABLE;
                        if (issue.getCreated() != null) {
                            created = df.format(issue.getCreated());
                        }
                        this.sinkCell(sink, created);
                        continue block17;
                    }
                    case 3: {
                        this.sinkCell(sink, IssuesReportHelper.printValues(issue.getFixVersions()));
                        continue block17;
                    }
                    case 4: {
                        sink.tableCell();
                        sink.link(issue.getLink());
                        sink.text(issue.getId());
                        sink.link_();
                        sink.tableCell_();
                        continue block17;
                    }
                    case 5: {
                        sink.tableCell();
                        sink.link(issue.getLink());
                        sink.text(issue.getKey());
                        sink.link_();
                        sink.tableCell_();
                        continue block17;
                    }
                    case 6: {
                        this.sinkCell(sink, issue.getPriority());
                        continue block17;
                    }
                    case 7: {
                        this.sinkCell(sink, issue.getReporter());
                        continue block17;
                    }
                    case 8: {
                        this.sinkCell(sink, issue.getResolution());
                        continue block17;
                    }
                    case 9: {
                        this.sinkCell(sink, issue.getStatus());
                        continue block17;
                    }
                    case 10: {
                        this.sinkCell(sink, issue.getSummary());
                        continue block17;
                    }
                    case 11: {
                        this.sinkCell(sink, issue.getType());
                        continue block17;
                    }
                    case 12: {
                        String updated = NOT_AVAILABLE;
                        if (issue.getUpdated() != null) {
                            updated = df.format(issue.getUpdated());
                        }
                        this.sinkCell(sink, updated);
                        continue block17;
                    }
                    case 13: {
                        this.sinkCell(sink, issue.getVersion());
                        continue block17;
                    }
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }
}

