/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.checkstyle.CheckstyleReportGenerator;
import org.apache.maven.plugin.checkstyle.CheckstyleReportListener;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.plugin.checkstyle.Locator;
import org.apache.maven.plugin.checkstyle.ReportResource;
import org.apache.maven.plugin.checkstyle.VelocityTemplate;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

public class CheckstyleReport
extends AbstractMavenReport {
    private static final String PLUGIN_RESOURCES = "org/apache/maven/plugin/checkstyle";
    private static final Map FORMAT_TO_CONFIG_LOCATION;
    private File outputDirectory;
    private boolean enableRulesSummary;
    private boolean enableSeveritySummary;
    private boolean enableFilesSummary;
    private boolean enableRSS;
    private String includes;
    private String excludes;
    private String configLocation;
    private String format;
    private String propertiesLocation;
    private File propertiesFile;
    private URL propertiesURL;
    private String propertyExpansion;
    private String headerLocation;
    private File headerFile;
    private String cacheFile;
    private File useFile;
    private String suppressionsLocation;
    private String suppressionsFileExpression;
    private String suppressionsFile;
    private File outputFile;
    private String outputFileFormat;
    private String packageNamesLocation;
    private String packageNamesFile;
    private boolean failsOnError;
    private File sourceDirectory;
    private MavenProject project;
    private boolean consoleOutput;
    private boolean linkXRef;
    private File xrefLocation;
    private SiteRenderer siteRenderer;
    private VelocityComponent velocityComponent;
    private static final File[] EMPTY_FILE_ARRAY;
    private StringOutputStream stringOutputStream;
    private Locator locator;
    static /* synthetic */ Class class$com$puppycrawl$tools$checkstyle$PackageNamesLoader;
    static /* synthetic */ Class class$org$apache$maven$plugin$checkstyle$CheckstyleReport;

    public String getName(Locale locale) {
        return CheckstyleReport.getBundle(locale).getString("report.checkstyle.name");
    }

    public String getDescription(Locale locale) {
        return CheckstyleReport.getBundle(locale).getString("report.checkstyle.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        CheckstyleResults results;
        Configuration config;
        ModuleFactory moduleFactory;
        this.mergeDeprecatedInfo();
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"Source directory does not exist - skipping report.");
            return;
        }
        this.locator = new Locator(this.getLog(), new File(this.project.getBuild().getDirectory()));
        String configFile = this.getConfigFile();
        Properties overridingProperties = this.getOverridingProperties();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader checkstyleClassLoader = (class$com$puppycrawl$tools$checkstyle$PackageNamesLoader == null ? (class$com$puppycrawl$tools$checkstyle$PackageNamesLoader = CheckstyleReport.class$("com.puppycrawl.tools.checkstyle.PackageNamesLoader")) : class$com$puppycrawl$tools$checkstyle$PackageNamesLoader).getClassLoader();
            Thread.currentThread().setContextClassLoader(checkstyleClassLoader);
            moduleFactory = this.getModuleFactory();
            config = ConfigurationLoader.loadConfiguration((String)configFile, (PropertyResolver)new PropertiesExpander(overridingProperties));
            results = this.executeCheckstyle(config, moduleFactory);
        }
        catch (CheckstyleException e) {
            throw new MavenReportException("Failed during checkstyle configuration", (Exception)((Object)e));
        }
        ResourceBundle bundle = CheckstyleReport.getBundle(locale);
        this.generateReportStatics();
        this.generateMainReport(results, config, moduleFactory, bundle);
        if (this.enableRSS) {
            this.generateRSS(results);
        }
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    private void generateReportStatics() throws MavenReportException {
        ReportResource rresource = new ReportResource(PLUGIN_RESOURCES, this.outputDirectory);
        try {
            rresource.copy("images/rss.png");
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }

    private void generateRSS(CheckstyleResults results) throws MavenReportException {
        VelocityTemplate vtemplate = new VelocityTemplate(this.velocityComponent, PLUGIN_RESOURCES);
        vtemplate.setLog(this.getLog());
        VelocityContext context = new VelocityContext();
        context.put("results", (Object)results);
        context.put("project", (Object)this.project);
        context.put("copyright", (Object)this.getCopyright());
        context.put("levelInfo", (Object)SeverityLevel.INFO);
        context.put("levelWarning", (Object)SeverityLevel.WARNING);
        context.put("levelError", (Object)SeverityLevel.ERROR);
        context.put("stringutils", (Object)new StringUtils());
        try {
            vtemplate.generate(this.outputDirectory.getPath() + "/checkstyle.rss", "checkstyle-rss.vm", (Context)context);
        }
        catch (ResourceNotFoundException e) {
            throw new MavenReportException("Unable to find checkstyle-rss.vm resource.", (Exception)((Object)e));
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Unable to generate checkstyle.rss.", (Exception)((Object)e));
        }
        catch (VelocityException e) {
            throw new MavenReportException("Unable to generate checkstyle.rss.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to generate checkstyle.rss.", (Exception)e);
        }
    }

    private String getCopyright() {
        int currentYear = Calendar.getInstance().get(1);
        String copyright = StringUtils.isNotEmpty((String)this.project.getInceptionYear()) && !String.valueOf(currentYear).equals(this.project.getInceptionYear()) ? this.project.getInceptionYear() + " - " + currentYear : String.valueOf(currentYear);
        if (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName())) {
            copyright = copyright + " " + this.project.getOrganization().getName();
        }
        return copyright;
    }

    private void generateMainReport(CheckstyleResults results, Configuration config, ModuleFactory moduleFactory, ResourceBundle bundle) {
        CheckstyleReportGenerator generator = new CheckstyleReportGenerator(this.getSink(), bundle);
        generator.setLog(this.getLog());
        generator.setEnableRulesSummary(this.enableRulesSummary);
        generator.setEnableSeveritySummary(this.enableSeveritySummary);
        generator.setEnableFilesSummary(this.enableFilesSummary);
        generator.setEnableRSS(this.enableRSS);
        generator.setCheckstyleConfig(config);
        generator.setCheckstyleModuleFactory(moduleFactory);
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                generator.setXrefLocation(relativePath);
            } else {
                Iterator reports = this.getProject().getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin report = (ReportPlugin)reports.next();
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    generator.setXrefLocation(relativePath);
                }
            }
            if (generator.getXrefLocation() == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        generator.generateReport(results);
    }

    private void mergeDeprecatedInfo() {
        File defaultHeaderFile;
        if ("config/sun_checks.xml".equals(this.configLocation) && !"sun".equals(this.format)) {
            this.configLocation = (String)FORMAT_TO_CONFIG_LOCATION.get(this.format);
        }
        if (StringUtils.isEmpty((String)this.propertiesLocation)) {
            if (this.propertiesFile != null) {
                this.propertiesLocation = this.propertiesFile.getPath();
            } else if (this.propertiesURL != null) {
                this.propertiesLocation = this.propertiesURL.toExternalForm();
            }
        }
        if ("LICENSE.txt".equals(this.headerLocation) && !(defaultHeaderFile = new File(this.project.getBasedir(), "LICENSE.txt")).equals(this.headerFile)) {
            this.headerLocation = this.headerFile.getPath();
        }
        if (StringUtils.isEmpty((String)this.suppressionsLocation)) {
            this.suppressionsLocation = this.suppressionsFile;
        }
        if (StringUtils.isEmpty((String)this.packageNamesLocation)) {
            this.packageNamesLocation = this.packageNamesFile;
        }
    }

    private CheckstyleResults executeCheckstyle(Configuration config, ModuleFactory moduleFactory) throws MavenReportException, CheckstyleException {
        List classPathStrings;
        File[] files;
        try {
            files = this.getFilesToProcess(this.includes, this.excludes);
        }
        catch (IOException e) {
            throw new MavenReportException("Error getting files to process", (Exception)e);
        }
        FilterSet filterSet = this.getSuppressions();
        Checker checker = new Checker();
        try {
            classPathStrings = this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        ArrayList<URL> URLs = new ArrayList<URL>(classPathStrings.size());
        Iterator iter = classPathStrings.iterator();
        while (iter.hasNext()) {
            try {
                URLs.add(new File((String)iter.next()).toURL());
            }
            catch (MalformedURLException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
        }
        URLClassLoader projectClassLoader = new URLClassLoader(URLs.toArray(new URL[URLs.size()]), null);
        checker.setClassloader((ClassLoader)projectClassLoader);
        if (moduleFactory != null) {
            checker.setModuleFactory(moduleFactory);
        }
        if (filterSet != null) {
            checker.addFilter((Filter)filterSet);
        }
        checker.configure(config);
        AuditListener listener = this.getListener();
        if (listener != null) {
            checker.addListener(listener);
        }
        if (this.consoleOutput) {
            checker.addListener((AuditListener)this.getConsoleListener());
        }
        CheckstyleReportListener sinkListener = new CheckstyleReportListener(this.sourceDirectory);
        checker.addListener((AuditListener)sinkListener);
        int nbErrors = checker.process(files);
        checker.destroy();
        if (this.stringOutputStream != null) {
            this.getLog().info((CharSequence)this.stringOutputStream.toString());
        }
        if (this.failsOnError && nbErrors > 0) {
            throw new MavenReportException("There are " + nbErrors + " checkstyle errors.");
        }
        if (nbErrors > 0) {
            this.getLog().info((CharSequence)("There are " + nbErrors + " checkstyle errors."));
        }
        return sinkListener.getResults();
    }

    public String getOutputName() {
        return "checkstyle";
    }

    private AuditListener getListener() throws MavenReportException {
        XMLLogger listener = null;
        if (StringUtils.isNotEmpty((String)this.outputFileFormat)) {
            File resultFile = this.outputFile;
            OutputStream out = this.getOutputStream(resultFile);
            if ("xml".equals(this.outputFileFormat)) {
                listener = new XMLLogger(out, true);
            } else if ("plain".equals(this.outputFileFormat)) {
                listener = new DefaultLogger(out, true);
            } else {
                throw new MavenReportException("Invalid output file format: (" + this.outputFileFormat + "). Must be 'plain' or 'xml'.");
            }
        }
        return listener;
    }

    private OutputStream getOutputStream(File file) throws MavenReportException {
        FileOutputStream fileOutputStream;
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MavenReportException("Unable to create output stream: " + file, (Exception)e);
        }
        return fileOutputStream;
    }

    private File[] getFilesToProcess(String includes, String excludes) throws IOException {
        StringBuffer excludesStr = new StringBuffer();
        if (StringUtils.isNotEmpty((String)excludes)) {
            excludesStr.append(excludes);
        }
        String[] defaultExcludes = FileUtils.getDefaultExcludes();
        for (int i = 0; i < defaultExcludes.length; ++i) {
            if (excludesStr.length() > 0) {
                excludesStr.append(",");
            }
            excludesStr.append(defaultExcludes[i]);
        }
        List files = FileUtils.getFiles((File)this.sourceDirectory, (String)includes, (String)excludesStr.toString());
        return files.toArray(EMPTY_FILE_ARRAY);
    }

    private Properties getOverridingProperties() throws MavenReportException {
        Properties p = new Properties();
        try {
            File propertiesFile = this.locator.resolveLocation(this.propertiesLocation, "checkstyle-checker.properties");
            if (propertiesFile != null) {
                p.load(new FileInputStream(propertiesFile));
            }
            if (StringUtils.isNotEmpty((String)this.propertyExpansion)) {
                p.load((InputStream)new StringInputStream(this.propertyExpansion));
            }
            if (StringUtils.isNotEmpty((String)this.headerLocation)) {
                try {
                    File headerFile = this.locator.resolveLocation(this.headerLocation, "checkstyle-header.txt");
                    if (headerFile != null) {
                        p.setProperty("checkstyle.header.file", headerFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    throw new MavenReportException("Unable to process header location.", (Exception)e);
                }
            }
            if (this.cacheFile != null) {
                p.setProperty("checkstyle.cache.file", this.cacheFile);
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to get overriding properties", (Exception)e);
        }
        if (this.suppressionsFileExpression != null) {
            String suppresionFile = this.getSuppressionLocation();
            p.setProperty(this.suppressionsFileExpression, suppresionFile);
        }
        return p;
    }

    private String getConfigFile() throws MavenReportException {
        try {
            File configFile = this.locator.resolveLocation(this.configLocation, "checkstyle-checker.xml");
            if (configFile == null) {
                throw new MavenReportException("Unable to process null config location.");
            }
            return configFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to find configuration file location.", (Exception)e);
        }
    }

    private ModuleFactory getModuleFactory() throws CheckstyleException {
        ModuleFactory moduleFactory = PackageNamesLoader.loadModuleFactory((ClassLoader)Thread.currentThread().getContextClassLoader());
        try {
            File packageNamesFile = this.locator.resolveLocation(this.packageNamesLocation, "checkstyle-packages.xml");
            if (packageNamesFile != null) {
                moduleFactory = PackageNamesLoader.loadModuleFactory((String)packageNamesFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to process package names location: " + this.packageNamesLocation), (Throwable)e);
        }
        return moduleFactory;
    }

    private String getSuppressionLocation() throws MavenReportException {
        try {
            File suppressionsFile = this.locator.resolveLocation(this.suppressionsLocation, "checkstyle-suppressions.xml");
            if (suppressionsFile == null) {
                return null;
            }
            return suppressionsFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to process supressions location: " + this.suppressionsLocation, (Exception)e);
        }
    }

    private FilterSet getSuppressions() throws MavenReportException {
        if (this.suppressionsFileExpression != null) {
            return null;
        }
        try {
            File suppressionsFile = this.locator.resolveLocation(this.suppressionsLocation, "checkstyle-suppressions.xml");
            if (suppressionsFile == null) {
                return null;
            }
            return SuppressionsLoader.loadSuppressions((String)suppressionsFile.getAbsolutePath());
        }
        catch (CheckstyleException ce) {
            throw new MavenReportException("failed to load suppressions location: " + this.suppressionsLocation, (Exception)((Object)ce));
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to process supressions location: " + this.suppressionsLocation, (Exception)e);
        }
    }

    private DefaultLogger getConsoleListener() throws MavenReportException {
        DefaultLogger consoleListener;
        if (this.useFile == null) {
            this.stringOutputStream = new StringOutputStream();
            consoleListener = new DefaultLogger((OutputStream)this.stringOutputStream, false);
        } else {
            OutputStream out = this.getOutputStream(this.useFile);
            consoleListener = new DefaultLogger(out, true);
        }
        return consoleListener;
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("checkstyle-report", locale, (class$org$apache$maven$plugin$checkstyle$CheckstyleReport == null ? (class$org$apache$maven$plugin$checkstyle$CheckstyleReport = CheckstyleReport.class$("org.apache.maven.plugin.checkstyle.CheckstyleReport")) : class$org$apache$maven$plugin$checkstyle$CheckstyleReport).getClassLoader());
    }

    public boolean canGenerateReport() {
        return this.sourceDirectory.exists();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, String> fmt2Cfg = new HashMap<String, String>();
        fmt2Cfg.put("sun", "config/sun_checks.xml");
        fmt2Cfg.put("turbine", "config/turbine_checks.xml");
        fmt2Cfg.put("avalon", "config/avalon_checks.xml");
        fmt2Cfg.put("maven", "config/maven_checks.xml");
        FORMAT_TO_CONFIG_LOCATION = Collections.unmodifiableMap(fmt2Cfg);
        EMPTY_FILE_ARRAY = new File[0];
    }
}

