/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.plugin.checkstyle.CheckstyleResults;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class CheckstyleReportGenerator {
    private static final String EOL = System.getProperty("line.separator");
    private Log log;
    private ResourceBundle bundle;
    private Sink sink;
    private SeverityLevel severityLevel;
    private Configuration checkstyleConfig;
    private ModuleFactory checkstyleModuleFactory;
    private boolean enableRulesSummary;
    private boolean enableSeveritySummary;
    private boolean enableFilesSummary;
    private boolean enableRSS;
    private String xrefLocation;

    public CheckstyleReportGenerator(Sink sink, ResourceBundle bundle) {
        this.bundle = bundle;
        this.sink = sink;
        this.enableRulesSummary = true;
        this.enableSeveritySummary = true;
        this.enableFilesSummary = true;
        this.enableRSS = true;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private String getTitle() {
        String title = this.getSeverityLevel() == null ? this.bundle.getString("report.checkstyle.title") : this.bundle.getString("report.checkstyle.severity_title") + this.severityLevel.getName();
        return title;
    }

    public void generateReport(CheckstyleResults results) {
        this.doHeading();
        if (this.getSeverityLevel() == null) {
            if (this.enableSeveritySummary) {
                this.doSeveritySummary(results);
            }
            if (this.enableRulesSummary) {
                this.doRulesSummary(results);
            }
            if (this.enableFilesSummary) {
                this.doFilesSummary(results);
            }
        }
        this.doDetails(results);
        this.sink.body_();
        this.sink.flush();
    }

    private void doHeading() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.checkstyle.checkstylelink") + " ");
        this.sink.link("http://checkstyle.sourceforge.net/");
        this.sink.text("Checkstyle");
        this.sink.link_();
        this.sink.text(".");
        if (this.enableRSS) {
            this.sink.nonBreakingSpace();
            this.sink.link("checkstyle.rss");
            this.sink.figure();
            this.sink.figureCaption();
            this.sink.text("rss feed");
            this.sink.figureCaption_();
            this.sink.figureGraphics("images/rss.png");
            this.sink.figure_();
            this.sink.link_();
        }
        this.sink.paragraph_();
    }

    private void iconSeverity(String level) {
        if (SeverityLevel.INFO.getName().equalsIgnoreCase(level)) {
            this.iconInfo();
        } else if (SeverityLevel.WARNING.getName().equalsIgnoreCase(level)) {
            this.iconWarning();
        } else if (SeverityLevel.ERROR.getName().equalsIgnoreCase(level)) {
            this.iconError();
        }
    }

    private void iconInfo() {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text("info");
        this.sink.figureCaption_();
        this.sink.figureGraphics("images/icon_info_sml.gif");
        this.sink.figure_();
    }

    private void iconWarning() {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text("warning");
        this.sink.figureCaption_();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    private void iconError() {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text("error");
        this.sink.figureCaption_();
        this.sink.figureGraphics("images/icon_error_sml.gif");
        this.sink.figure_();
    }

    private String getConfigAttribute(Configuration config, String attname, String defvalue) {
        String ret;
        try {
            ret = config.getAttribute(attname);
        }
        catch (CheckstyleException e) {
            ret = defvalue;
        }
        return ret;
    }

    private void doRulesSummary(CheckstyleResults results) {
        if (this.checkstyleConfig == null) {
            return;
        }
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.rules"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.rules"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Violations");
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Severity");
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        if ("checker".equalsIgnoreCase(this.checkstyleConfig.getName())) {
            this.doRuleChildren(this.checkstyleConfig.getChildren(), results);
        } else {
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text("No Rules Found.");
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
        this.sink.section1_();
    }

    private void doRuleChildren(Configuration[] configChildren, CheckstyleResults results) {
        for (int cci = 0; cci < configChildren.length; ++cci) {
            String ruleName = configChildren[cci].getName();
            if ("TreeWalker".equals(ruleName)) {
                this.doRuleChildren(configChildren[cci].getChildren(), results);
                continue;
            }
            this.doRuleRow(configChildren[cci], ruleName, results);
        }
    }

    private void doRuleRow(Configuration checkerConfig, String ruleName, CheckstyleResults results) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(ruleName);
        ArrayList<String> attribnames = new ArrayList<String>(Arrays.asList(checkerConfig.getAttributeNames()));
        attribnames.remove("severity");
        if (!attribnames.isEmpty()) {
            this.sink.list();
            Iterator it = attribnames.iterator();
            while (it.hasNext()) {
                this.sink.listItem();
                String name = (String)it.next();
                this.sink.bold();
                this.sink.text(name);
                this.sink.bold_();
                String value = this.getConfigAttribute(checkerConfig, name, "");
                if ("header".equals(name) && ("Header".equals(ruleName) || "RegexpHeader".equals(ruleName))) {
                    List lines = this.stringSplit(value, "\\n");
                    int linenum = 1;
                    Iterator itl = lines.iterator();
                    while (itl.hasNext()) {
                        String line = (String)itl.next();
                        this.sink.lineBreak();
                        this.sink.rawText("<span style=\"color: gray\">");
                        this.sink.text(linenum + ":");
                        this.sink.rawText("</span>");
                        this.sink.nonBreakingSpace();
                        this.sink.monospaced();
                        this.sink.text(line);
                        this.sink.monospaced_();
                        ++linenum;
                    }
                } else {
                    this.sink.text(": ");
                    this.sink.monospaced();
                    this.sink.text("\"");
                    this.sink.text(value);
                    this.sink.text("\"");
                    this.sink.monospaced_();
                }
                this.sink.listItem_();
            }
            this.sink.list_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        String fixedmessage = this.getConfigAttribute(checkerConfig, "message", null);
        this.sink.text(this.countRuleViolation(results.getFiles().values().iterator(), ruleName, fixedmessage));
        this.sink.tableCell_();
        this.sink.tableCell();
        String configSeverity = this.getConfigAttribute(checkerConfig, "severity", "error");
        this.iconSeverity(configSeverity);
        this.sink.nonBreakingSpace();
        this.sink.text(StringUtils.capitalise((String)configSeverity));
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private List stringSplit(String input, String delim) {
        String line;
        ArrayList<String> ret = new ArrayList<String>();
        int delimLen = delim.length();
        int offset = 0;
        int lastOffset = 0;
        while ((offset = input.indexOf(delim, offset)) >= 0) {
            line = input.substring(lastOffset, offset);
            ret.add(line);
            lastOffset = offset += delimLen;
        }
        line = input.substring(lastOffset);
        ret.add(line);
        return ret;
    }

    private String countRuleViolation(Iterator files, String ruleName, String message) {
        String sourceName;
        long count = 0L;
        try {
            sourceName = this.checkstyleModuleFactory.createModule(ruleName).getClass().getName();
        }
        catch (CheckstyleException e) {
            this.getLog().error((CharSequence)("Unable to obtain Source Name for Rule '" + ruleName + "'."), (Throwable)e);
            return "(report failure)";
        }
        while (files.hasNext()) {
            List errors = (List)files.next();
            Iterator error = errors.iterator();
            while (error.hasNext()) {
                AuditEvent event = (AuditEvent)error.next();
                if (!event.getSourceName().equals(sourceName)) continue;
                if (message != null) {
                    if (!message.equals(event.getMessage())) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        return String.valueOf(count);
    }

    private void doSeveritySummary(CheckstyleResults results) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.summary"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.files"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Infos");
        this.sink.nonBreakingSpace();
        this.iconInfo();
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Warnings");
        this.sink.nonBreakingSpace();
        this.iconWarning();
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("Errors");
        this.sink.nonBreakingSpace();
        this.iconError();
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getFileCount()));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getSeverityCount(SeverityLevel.INFO)));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getSeverityCount(SeverityLevel.WARNING)));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(results.getSeverityCount(SeverityLevel.ERROR)));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.section1_();
    }

    private void doFilesSummary(CheckstyleResults results) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.files"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.checkstyle.files"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("I");
        this.sink.nonBreakingSpace();
        this.iconInfo();
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("W");
        this.sink.nonBreakingSpace();
        this.iconWarning();
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text("E");
        this.sink.nonBreakingSpace();
        this.iconError();
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        Iterator files = results.getFiles().keySet().iterator();
        while (files.hasNext()) {
            String filename = (String)files.next();
            List violations = results.getFileViolations(filename);
            if (violations.isEmpty()) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.link("#" + filename.replace('/', '.'));
            this.sink.text(filename);
            this.sink.link_();
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(results.getSeverityCount(violations, SeverityLevel.INFO)));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(results.getSeverityCount(violations, SeverityLevel.WARNING)));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(results.getSeverityCount(violations, SeverityLevel.ERROR)));
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
        this.sink.section1_();
    }

    private void doDetails(CheckstyleResults results) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.checkstyle.details"));
        this.sink.sectionTitle1_();
        Iterator files = results.getFiles().keySet().iterator();
        while (files.hasNext()) {
            String file = (String)files.next();
            List violations = results.getFileViolations(file);
            if (violations.isEmpty()) continue;
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.anchor(file.replace('/', '.'));
            this.sink.anchor_();
            this.sink.text(file);
            this.sink.sectionTitle2_();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.checkstyle.column.violation"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text("Message");
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text("Line");
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.doFileEvents(violations, file);
            this.sink.table_();
            this.sink.section2_();
        }
        this.sink.section1_();
    }

    private void doFileEvents(List eventList, String filename) {
        Iterator events = eventList.iterator();
        while (events.hasNext()) {
            AuditEvent event = (AuditEvent)events.next();
            SeverityLevel level = event.getSeverityLevel();
            if (this.getSeverityLevel() != null && !this.getSeverityLevel().equals((Object)level)) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            if (SeverityLevel.INFO.equals((Object)level)) {
                this.iconInfo();
            } else if (SeverityLevel.WARNING.equals((Object)level)) {
                this.iconWarning();
            } else if (SeverityLevel.ERROR.equals((Object)level)) {
                this.iconError();
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(event.getMessage());
            this.sink.tableCell_();
            this.sink.tableCell();
            if (this.getXrefLocation() != null) {
                this.sink.link(this.getXrefLocation() + "/" + filename.replaceAll("\\.java$", ".html") + "#" + event.getLine());
            }
            this.sink.text(String.valueOf(event.getLine()));
            if (this.getXrefLocation() != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.severityLevel = severityLevel;
    }

    public boolean isEnableRulesSummary() {
        return this.enableRulesSummary;
    }

    public void setEnableRulesSummary(boolean enableRulesSummary) {
        this.enableRulesSummary = enableRulesSummary;
    }

    public boolean isEnableSeveritySummary() {
        return this.enableSeveritySummary;
    }

    public void setEnableSeveritySummary(boolean enableSeveritySummary) {
        this.enableSeveritySummary = enableSeveritySummary;
    }

    public boolean isEnableFilesSummary() {
        return this.enableFilesSummary;
    }

    public void setEnableFilesSummary(boolean enableFilesSummary) {
        this.enableFilesSummary = enableFilesSummary;
    }

    public boolean isEnableRSS() {
        return this.enableRSS;
    }

    public void setEnableRSS(boolean enableRSS) {
        this.enableRSS = enableRSS;
    }

    public String getXrefLocation() {
        return this.xrefLocation;
    }

    public void setXrefLocation(String xrefLocation) {
        this.xrefLocation = xrefLocation;
    }

    public Configuration getCheckstyleConfig() {
        return this.checkstyleConfig;
    }

    public void setCheckstyleConfig(Configuration config) {
        this.checkstyleConfig = config;
    }

    public ModuleFactory getCheckstyleModuleFactory() {
        return this.checkstyleModuleFactory;
    }

    public void setCheckstyleModuleFactory(ModuleFactory checkstyleModuleFactory) {
        this.checkstyleModuleFactory = checkstyleModuleFactory;
    }
}

