/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CheckstyleViolationCheckMojo
extends AbstractMojo {
    private File outputFile;
    private String outputFileFormat;
    private boolean failOnViolation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"xml".equals(this.outputFileFormat)) {
            throw new MojoExecutionException("Output format is '" + this.outputFileFormat + "', checkstyle:check requires format to be 'xml'.");
        }
        if (!this.outputFile.exists()) {
            this.getLog().info((CharSequence)"Unable to perform checkstyle:check, unable to find checkstyle:checkstyle outputFile.");
            return;
        }
        try {
            MXParser xpp = new MXParser();
            FileReader freader = new FileReader(this.outputFile);
            BufferedReader breader = new BufferedReader(freader);
            xpp.setInput((Reader)breader);
            int violations = this.countViolations((XmlPullParser)xpp);
            if (violations > 0) {
                if (this.failOnViolation) {
                    throw new MojoFailureException("You have " + violations + " checkstyle violation" + (violations > 1 ? "s" : "") + ".");
                }
                this.getLog().warn((CharSequence)"checkstyle:check violations detected but failOnViolation set to false");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Unable to read checkstyle results xml: " + this.outputFile.getAbsolutePath(), (Exception)((Object)e));
        }
    }

    private int countViolations(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int count = 0;
        int eventType = xpp.getEventType();
        while (eventType != 1) {
            if (eventType == 2 && "error".equals(xpp.getName()) && "error".equals(xpp.getAttributeValue("", "severity"))) {
                ++count;
            }
            eventType = xpp.next();
        }
        return count;
    }
}

