/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.checkstyle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class VelocityTemplate {
    private String templateDirectory;
    private Log log;
    private VelocityComponent velocity;

    public VelocityTemplate(VelocityComponent velocityComponent, String templateBaseDirectory) {
        this.velocity = velocityComponent;
        this.templateDirectory = templateBaseDirectory;
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public VelocityComponent getVelocity() {
        return this.velocity;
    }

    public void generate(String outputFilename, String template, Context context) throws ResourceNotFoundException, VelocityException, MojoExecutionException, IOException {
        try {
            File f = new File(outputFilename);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(f);
            this.getVelocity().getEngine().mergeTemplate(this.templateDirectory + "/" + template, context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.getLog().debug((CharSequence)("File " + outputFilename + " created..."));
        }
        catch (ResourceNotFoundException e) {
            throw new ResourceNotFoundException("Template not found: " + this.templateDirectory + "/" + template);
        }
        catch (VelocityException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    public void setVelocity(VelocityComponent velocity) {
        this.velocity = velocity;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

